/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ip.EditIpAddressTable;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class InsertIpAddress
extends InsertForm {
    static final int INTERFACE = 0;
    static final int IPADDR = 1;
    FieldPanel _ports;
    byte[] _ipAddr;
    int[] _tableIndex;
    boolean _isIPFC = false;

    public InsertIpAddress(InsertDialog parent, EditTable table) {
        super(parent, table);
        this._tableIndex = ((EditIpAddressTable)table).getTableIndex();
        this._isIPFC = Discover.getRoot().ifIndexToName(this._tableIndex[0]).startsWith("vsan");
    }

    protected void build() {
        super.build();
        if (this._tableIndex != null && this._tableIndex.length == 1) {
            if (this._isIPFC) {
                this._ports.setText(Discover.getRoot().ifIndexToName(this._tableIndex[0]).substring(4));
            } else {
                this._ports.setText(Discover.getRoot().ifIndexToName(this._tableIndex[0]));
            }
            this._ports.setVisible(false);
            this._labels[0].setVisible(false);
        } else {
            this._ports.setText("");
        }
        ((JTextField)this._values[1]).setText("");
    }

    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0 && this._tableIndex != null && this._isIPFC) {
            return new JLabel("VSAN Id:", 4);
        }
        return new JLabel(this.getFormLabel(mibVar, index) + ":", 4);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            if (this._tableIndex != null && this._isIPFC) {
                this._ports = new FieldPanel(5, (JComponent)new VsanIdMenuButton(null, this.getPeer(), (IfIndexIf)Discover.getRoot()));
                this._ports.setRange(1, 4093);
                this._ports.setText("");
            } else {
                this._ports = new MdsPortChooser(Discover.getDeviceName(), true, (IfIndexIf)Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{2}));
            }
            return this._ports;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected int getWidth(String mibVar, MibNode mibNode, String tc) {
        if (mibVar.equals("ciiIPIfAddressPrefixLength")) {
            return 20;
        }
        return super.getWidth(mibVar, mibNode, tc);
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1) {
            String addrString = this.getComponentText(1);
            if (addrString.equals("")) {
                throw new Exception("Please provide ipaddress.");
            }
            int slash = addrString.indexOf(47);
            this._ipAddr = InsertIpAddress.checkIpAddress(slash != -1 ? addrString.substring(0, slash) : addrString);
            if (this._ipAddr.length == 0) {
                throw new SnmpException("bad ipaddress");
            }
            try {
                int prefix = slash == -1 ? (this._ipAddr.length == 16 ? 64 : 24) : Integer.parseInt(addrString.substring(slash + 1));
                return new SnmpGauge((long)prefix);
            }
            catch (NumberFormatException ex) {
                throw new SnmpException("bad mask");
            }
        }
        if (index == 0) {
            String intString = this._isIPFC ? "VSAN" + ((FieldPanel)this._values[index]).getText() : ((FieldPanel)this._values[index]).getText();
            return new SnmpInt(Discover.getRoot().nameToIfIndex(intString));
        }
        return super.getComponentValue(index);
    }

    public static byte[] checkIpAddress(String addr) throws SnmpException {
        byte[] ipAddr = SnmpIpAddress.parse((String)addr);
        return ipAddr;
    }

    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int ifIndex;
        int[] index = new int[this._ipAddr.length + 3];
        index[0] = ifIndex = Discover.getRoot().nameToIfIndex(this._isIPFC ? "VSAN" + this._ports.getText() : this._ports.getText());
        index[1] = this._ipAddr.length == 16 ? 2 : 1;
        index[2] = this._ipAddr.length;
        int[] ipAddress = SnmpString.valueOf((byte[])this._ipAddr, (boolean)false);
        System.arraycopy(ipAddress, 0, index, 3, ipAddress.length);
        return index;
    }

    public void dispose() {
        if (this._ports != null && this._ports instanceof MdsPortChooser) {
            ((MdsPortChooser)this._ports).dismiss();
        }
        super.dispose();
    }
}

