/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ModuleIdMenuButton;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class InsertVirtualIf
extends InsertForm
implements ItemListener {
    static final int VSANID = 0;
    static final int IPADDR = 1;
    static final int ADMIN = 2;
    static final int CPP = 3;
    static final int MODULE = 4;
    JCheckBox _cpp;
    FieldPanel _modulePanel;
    JLabel _moduelLable;

    public InsertVirtualIf(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            FieldPanel f = new FieldPanel(5, (JComponent)new VsanIdMenuButton(null, this.getPeer(), (IfIndexIf)Discover.getRoot()));
            f.setRange(1, 4093);
            return f;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected void build() {
        super.build();
        this.setComponentText(0, "1");
        this.setComponentText(1, "10.1.1.1/24");
    }

    protected int getWidth(String mibVar, MibNode mibNode, String tc) {
        if (mibVar.equals("ciiIPIfAddressPrefixLength")) {
            return 20;
        }
        return super.getWidth(mibVar, mibNode, tc);
    }

    protected void layoutForm() {
        Array asmSlots = ModuleIdMenuButton.getASMSlots();
        if (asmSlots.size() <= 0) {
            super.layoutForm();
            return;
        }
        JComponent[] labels = new JLabel[this._labels.length + 2];
        System.arraycopy(this._labels, 0, labels, 0, this._labels.length);
        labels[4] = this._moduelLable = new JLabel("Module");
        JComponent[] values = new JComponent[this._values.length + 2];
        System.arraycopy(this._values, 0, values, 0, this._values.length);
        this._cpp = new JCheckBox("CPP (ASM/SSM Only)");
        values[3] = this._cpp;
        this._modulePanel = new FieldPanel(5, (JComponent)((Object)new ModuleIdMenuButton(null, null, null, asmSlots)));
        values[4] = this._modulePanel;
        this._modulePanel.setText(Integer.toString((Integer)asmSlots.elementAt(0)));
        this._cpp.addItemListener(this);
        this._cpp.setSelected(false);
        this._modulePanel.setEnabled(false);
        this._moduelLable.setEnabled(false);
        DialogUtil.buildPanel((Container)this._container, (JComponent[])labels, (JComponent[])values);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected;
        boolean bl = isSelected = e.getStateChange() == 1;
        if (e.getSource() == this._cpp) {
            this._modulePanel.setEnabled(isSelected);
            this._moduelLable.setEnabled(isSelected);
        }
    }

    protected void insert() throws Exception {
        int module;
        int moduleId;
        String addr = this.getComponentText(1);
        int slash = addr.indexOf(47);
        int prefix = slash == -1 ? -1 : Integer.parseInt(addr.substring(slash + 1));
        byte[] ipAddr = InsertVirtualIf.checkIpAddress(addr);
        int vsanId = ((FieldPanel)this._values[0]).getInt();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        if (this._modulePanel != null && this._modulePanel.getText().equals("")) {
            throw new Exception("Please select Module.");
        }
        if (this._modulePanel == null || !this._modulePanel.isEnabled()) {
            moduleId = DmSystem.getProcessorId();
            module = DmSystem.getActiveSup()[0] - 21;
        } else {
            module = Integer.parseInt(this._modulePanel.getText());
            moduleId = DmSystem.getProcessorId(21 + module);
        }
        int ifIndex = this._modulePanel == null || !this._modulePanel.isEnabled() ? 0x8F80000 + vsanId : 0x8000000 + (module - 1 << 19) + 0 + vsanId;
        InsertVirtualIf.doVsanIf(pdu, vsanId, moduleId, 4);
        this.getPeer().set(pdu);
        SnmpPDU ipPDU = new SnmpPDU(-93, new VarBindList());
        InsertVirtualIf.AssignIpAddress(this.getPeer(), ipPDU, ifIndex, ipAddr, prefix, vsanId, moduleId, true);
        this.adminInterface(ifIndex, MibNode.get((String)"ifAdminStatus").getEnums()[((RadioButtonPanel)this._values[2]).getSelected()].getValue());
        this._table.fetchRow(new int[]{ifIndex});
    }

    public static byte[] checkIpAddress(String addr) throws SnmpException {
        int slash = addr.indexOf(47);
        byte[] ipAddr = slash == -1 ? SnmpIpAddress.parse((String)addr) : SnmpIpAddress.parse((String)addr.substring(0, slash));
        int prefix = 0;
        try {
            if (slash != -1) {
                prefix = Integer.parseInt(addr.substring(slash + 1));
            }
        }
        catch (NumberFormatException ex) {
            throw new SnmpException("bad mask");
        }
        return ipAddr;
    }

    public static void doVsanIf(SnmpPDU pdu, int vsanId, int moduleId, int operation) throws SnmpException {
        SnmpInt createAndGo = new SnmpInt(operation);
        int[] index = new int[]{moduleId, 1, vsanId};
        pdu.addVar(new SnmpOID(MibNode.get((String)"virtualNwIfRowStatus").getOid(), index), (SnmpVar)createAndGo);
    }

    public static void AssignIpAddress(SnmpPeer peer, SnmpPDU ipPDU, int ifIndex, byte[] ipAddr, int mask, int vsanId, int moduleId, boolean needRollback) throws SnmpException {
        int[] ipIndex = new int[ipAddr.length + 3];
        ipIndex[0] = ifIndex;
        ipIndex[1] = ipAddr.length == 16 ? 2 : 1;
        ipIndex[2] = ipAddr.length;
        int i = 0;
        int j = 3;
        while (i < ipAddr.length) {
            ipIndex[j] = ipAddr[i] & 0xFF;
            ++i;
            ++j;
        }
        int defaultMask = ipAddr.length == 16 ? 64 : 24;
        ipPDU.addVar(new SnmpOID(MibNode.get((String)"ciiIPIfAddressStatus").getOid(), ipIndex), (SnmpVar)new SnmpInt(4));
        ipPDU.addVar(new SnmpOID(MibNode.get((String)"ciiIPIfAddressPrefixLength").getOid(), ipIndex), (SnmpVar)new SnmpUnsignedInt(mask == -1 ? (long)defaultMask : (long)mask));
        if (!needRollback) {
            return;
        }
        try {
            peer.set(ipPDU);
        }
        catch (SnmpException ex) {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            InsertVirtualIf.doVsanIf(pdu, vsanId, moduleId, 6);
            try {
                peer.set(pdu);
            }
            catch (SnmpException ex1) {
                // empty catch block
            }
            throw new SnmpException(ex.getMessage());
        }
    }

    public static void removeIpAddress(SnmpPeer peer, SnmpPDU ipPDU, int ifIndex, byte[] ipAddr) throws SnmpException {
        int[] ipIndex = new int[ipAddr.length + 3];
        ipIndex[0] = ifIndex;
        ipIndex[1] = ipAddr.length == 16 ? 2 : 1;
        ipIndex[2] = ipAddr.length;
        int i = 0;
        int j = 3;
        while (i < ipAddr.length) {
            ipIndex[j] = ipAddr[i] & 0xFF;
            ++i;
            ++j;
        }
        ipPDU.addVar(new SnmpOID(MibNode.get((String)"ciiIPIfAddressStatus").getOid(), ipIndex), (SnmpVar)new SnmpInt(6));
    }

    private void adminInterface(int ifIndex, int adminState) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
        pdu.addVar(new SnmpOID(MibNode.get((String)"ifAdminStatus").getOid(), new int[]{ifIndex}), (SnmpVar)new SnmpInt(adminState));
        this.getPeer().set(pdu);
    }
}

