/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditEthForm;
import com.cisco.dcbu.lib.jnm.Bits;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;

public class EditEthSubIfTable
extends EditTable {
    static final int IPADDRESS = 6;
    SnmpPDU _ipAddressPDU;
    protected static final int[] _iscsiGigEIfAuthMethodOid = MibNode.get((String)"iscsiGigEIfAuthMethod").getOid();
    protected static final int[] _iscsiGigEIfIsnsServerProfileNameOid = MibNode.get((String)"iscsiGigEIfIsnsServerProfileName").getOid();
    protected static final MibEnum[] _iscsiGigEIfAuthMethodEnums = MibNode.get((String)"iscsiGigEIfAuthMethod").getEnums();
    protected int _ifTypePos = this.getVarIndex("ifType") + 1;
    protected int _authMethodPos = this.getVarIndex("iscsiGigEIfAuthMethod") + 1;
    protected int _profileNamePos = this.getVarIndex("iscsiGigEIfIsnsServerProfileName") + 1;
    protected static final int IPADDRESS_BUTTON = 0;

    public EditEthSubIfTable(String[] vars) {
        super(vars);
    }

    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt((Object)"IP Address(es)...", 0);
        return btns;
    }

    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("x");
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('x', this._table.getSelectedRowCount() > 0);
    }

    protected void buildTable() {
        super.buildTable();
        boolean[] isEditable = this._tableModel.getEditable();
        isEditable[7] = true;
        this._tableModel.setEditable(isEditable);
    }

    protected boolean isEditable(MibNode mibNode) {
        if (SnmpOID.equals((int[])mibNode.getOid(), (int[])EditEthForm._ipAddressOid)) {
            return true;
        }
        return super.isEditable(mibNode);
    }

    protected void get() {
        super.get();
        this._needsRefresh = true;
    }

    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        int ifIndex = oid[oid.length - 1];
        return (ifIndex & 0xFFFFF000) != this.getIndex()[0];
    }

    protected boolean isEnd(int[] req, SnmpVarBind vb, int[] index) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        int ifIndex = oid[oid.length - 1];
        return (ifIndex & 0xFFFFF000) != index[0];
    }

    protected void postProcessing() throws SnmpException {
        if (this._authMethodPos == 0) {
            return;
        }
        VarBindList vbl = new VarBindList();
        int numVar = this._profileNamePos != 0 ? 2 : 1;
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            int[] oid = ((SnmpOID)row[0]).getValue();
            row[this._authMethodPos] = new Bits(_iscsiGigEIfAuthMethodEnums, new byte[0]);
            vbl.add(new SnmpVarBind(new SnmpOID(_iscsiGigEIfAuthMethodOid, oid[oid.length - 1])));
            if (this._profileNamePos == 0) continue;
            row[this._profileNamePos] = "";
            vbl.add(new SnmpVarBind(new SnmpOID(_iscsiGigEIfIsnsServerProfileNameOid, oid[oid.length - 1])));
        }
        if (vbl.size() == 0) {
            return;
        }
        SnmpPDU resp = SnmpFetch.get((SnmpPeer)this.getPeer(), (VarBindList)vbl);
        if (resp == null || resp.getVariables().size() == 0) {
            return;
        }
        vbl = resp.getVariables();
        for (int i = 0; i < vbl.size(); i += numVar) {
            Object[] row = (Object[])this._data.elementAt(i / numVar);
            if (vbl.getVb(i).getVar().getType() == 5) {
                this._tableModel.setNoSuchInstance(i / numVar, this._authMethodPos, true);
                if (this._profileNamePos == 0) continue;
                this._tableModel.setNoSuchInstance(i / numVar, this._profileNamePos, true);
                continue;
            }
            this._tableModel.setNoSuchInstance(i / numVar, this._authMethodPos, false);
            if (this._profileNamePos != 0) {
                this._tableModel.setNoSuchInstance(i / numVar, this._profileNamePos, false);
            }
            SnmpVar vb = vbl.getVb(i).getVar();
            row[this._authMethodPos] = new Bits(_iscsiGigEIfAuthMethodEnums, ((SnmpString)vbl.getVb(i).getVar()).getValue());
            if (this._profileNamePos == 0) continue;
            row[this._profileNamePos] = vbl.get(i + 1).getVar();
        }
    }

    protected void updateTable() {
        if (this._data.size() > 0) {
            int[][] ipAddressIdx = new int[this._data.size()][];
            for (int i = 0; i < this._data.size(); ++i) {
                ipAddressIdx[i] = this._tableModel.getIndex(i);
            }
            try {
                String[] ipAddress = EditEthForm.getIpAddress(this.getPeer(), ipAddressIdx, this._mibNodes[7].getOid());
                for (int i = 0; i < this._data.size() && i < ipAddress.length; ++i) {
                    Object[] row = (Object[])this._data.elementAt(i);
                    row[7] = ipAddress[i];
                    this._tableModel.setNoSuchInstance(i, 7, false);
                }
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this.getParent(), (String)ex.getMessage());
            }
        }
        super.updateTable();
        this.enableButton('x', false);
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        Array changedCells = null;
        this._ipAddressPDU = new SnmpPDU(-93, new VarBindList());
        changedCells = this._tableModel.getChanged();
        for (int i = pdu.getVariables().size() - 1; i >= 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            SnmpOID oid = vb.getOid();
            if (!oid.startsWith(EditEthForm._ipAddressOid)) continue;
            pdu.getVariables().remove(i);
            int index = oid.getValue()[oid.getValue().length - 1];
            String newIpAddress = ((SnmpString)vb.getVar()).toString();
            if (newIpAddress.equals("")) {
                newIpAddress = "n/a";
            }
            Cell cell = (Cell)changedCells.elementAt(i);
            Object[] values = (Object[])this._data.elementAt(cell._row);
            Object[] changed = (Object[])values[this._tableModel.getHeaders().length];
            String oldIpAddress = (String)changed[7];
            SharedUtil.getSetIpAddressPDU((SnmpPDU)pdu, (SnmpPDU)this._ipAddressPDU, (int)index, (String)newIpAddress, (String)oldIpAddress);
        }
        if (pdu.getVariables().size() > 0) {
            super.sendPdu(pdu);
        }
        if (this._ipAddressPDU.getVariables().size() > 0) {
            this.getPeer().set(this._ipAddressPDU);
        }
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'x') {
            Object gigEIndex;
            DMDialog dlg = null;
            String interfaceInfo = "";
            int[] selectedRows = this._table.getSelectedRows();
            if (selectedRows.length > 1) {
                gigEIndex = new int[selectedRows.length][0];
                for (int i = 0; i < selectedRows.length; ++i) {
                    gigEIndex[i] = ((SnmpOID)this._tableModel.getValueAt(selectedRows[i], 0)).getValue();
                }
                dlg = DialogListener.getInstance().dialogAction("IP_Address", gigEIndex);
            } else {
                gigEIndex = ((SnmpOID)this._tableModel.getValueAt(selectedRows[0], 0)).getValue();
                dlg = DialogListener.getInstance().dialogAction("IP_Address", (int[])gigEIndex);
                interfaceInfo = Discover.getRoot().ifIndexToName((int)gigEIndex[0]);
            }
            if (dlg != null) {
                InsertDialog insertD;
                DMPanel p = dlg.getPanel(0);
                if (p != null && (insertD = ((EditTable)p).getInsertDialog()) != null) {
                    insertD.dispose();
                }
                dlg.setParentTable((EditTable)this);
                dlg.setTitle(Discover.getDeviceName() + " - IPAddress  " + interfaceInfo);
                dlg.setLocation(DialogUtil.getPointOnScreen((Point)new Point(0, 0), (Component)((JComponent)e.getSource()), (Dimension)dlg.getSize()));
            }
        } else {
            super.doIt(ch, e);
        }
    }

    protected DmTableModel buildTableModel() {
        return new SnmpEthTableModel();
    }

    class SnmpEthTableModel
    extends DmTableModel {
        SnmpEthTableModel() {
        }

        protected SnmpVar getChangedCell(int row, int col, MibNode[] mibNodes) throws Exception {
            Object o;
            if (col == 7 && (o = this.getValueAt(row, col)) instanceof String) {
                return new SnmpString((String)o);
            }
            return super.getChangedCell(row, col, mibNodes);
        }
    }
}

