/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;

public class EditLunDiscForm
extends EditForm {
    private static final int DEVICE_TYPE = 1;
    private static final int OS = 2;
    static final int[] _ciscoExtScsiStartLunDiscOid = MibNode.get((String)"ciscoExtScsiStartLunDisc").getOid();

    public EditLunDiscForm(String[] vars) {
        super(vars);
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        MibEnum[] enums;
        int selected;
        SnmpPDU spinLockPdu = new SnmpPDU(-96, new VarBindList());
        spinLockPdu.addNull(new SnmpOID(MibNode.get((String)"ciscoExtScsiLunDiscSpinLock").getOid(), 0));
        SnmpPDU resp = this.getPeer().send(spinLockPdu);
        if (resp.getVariables().get(0).getVar().getType() == 5) {
            throw new SnmpException("SpinLock N/A : Not writable; feature disabled or denied");
        }
        SnmpInt nSpinLock = (SnmpInt)resp.getVar(0);
        VarBindList vbl = pdu.getVariables();
        vbl.add(0, new SnmpVarBind(new SnmpOID(MibNode.get((String)"ciscoExtScsiLunDiscSpinLock").getOid(), 0), (SnmpVar)nSpinLock));
        if (!this.isChanged(1) && (selected = ((RadioButtonPanel)this._values[1]).getSelected()) != -1) {
            enums = this._mibNodes[1].getEnums();
            pdu.addVar(new SnmpOID(MibNode.get((String)"ciscoExtScsiDiscType").getOid(), 0), (SnmpVar)new SnmpInt(enums[selected].getValue()));
        }
        if (!this.isChanged(2) && (selected = ((RadioButtonPanel)this._values[2]).getSelected()) != -1) {
            enums = this._mibNodes[2].getEnums();
            pdu.addVar(new SnmpOID(MibNode.get((String)"ciscoExtScsiLunDiscOs").getOid(), 0), (SnmpVar)new SnmpInt(enums[selected].getValue()));
        }
        for (int i = 0; i < pdu.getVariables().size(); ++i) {
            int[] oid = pdu.getVariables().get(i).getOid().getValue();
            if (!SnmpOID.startsWith((int[])oid, (int[])_ciscoExtScsiStartLunDiscOid)) continue;
            SnmpVarBind discoverVB = pdu.getVariables().get(i);
            pdu.getVariables().remove(i);
            pdu.getVariables().add(discoverVB);
        }
        this.getPeer().set(pdu);
    }
}

