/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshDump;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.SmlCommandsHandler;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;

public class QlogicCommandHandlerDM {
    static final String[] EDIT_ERR_CODE = new String[]{"0"};
    static final String RENAME = ".Rename.";
    static final String[][] CLEAN_UP = new String[][]{{"smlsetb Cmd.Switch.CancelAdmin\n", null}};
    static QlogicCommandHandlerDM _Instance;
    private static SmlCommandsHandler _smlCmd;

    public static QlogicCommandHandlerDM getInstance(JFrame frame, SnmpPeer peer) throws Exception {
        if (_Instance == null || _smlCmd == null) {
            _Instance = new QlogicCommandHandlerDM(frame, peer);
        }
        _smlCmd = new SmlCommandsHandler(frame, peer);
        return _Instance;
    }

    private QlogicCommandHandlerDM(JFrame frame, SnmpPeer peer) throws Exception {
    }

    public static void close() {
        if (_Instance != null) {
            _Instance = null;
            _smlCmd = null;
        }
    }

    public void saveConfig() throws Exception {
        String out = _smlCmd.executeCLICommand("copy running-config startup-config", (String)null, false);
        if (out != null && out.indexOf("100%") == -1) {
            throw new Exception(out);
        }
    }

    public void writeErase() throws Exception {
        String out = _smlCmd.executeCLICommand("Write Erase", (String)null, true);
        if (out.indexOf("This command will erase") == -1 || !out.endsWith("[n]")) {
            DefaultLogger._DefLogger.debug((Object)("out = " + out + "!"));
            throw new Exception(out);
        }
    }

    public void resetSwitch() throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("Cmd.Switch.Reset");
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        _smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, (String[][])new String[][]{{"0"}, {"0"}}, null);
        QlogicCommandHandlerDM.close();
        Vsh.close();
    }

    public String[] getSyslogEnable() throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("Config.System.RmLogEnable");
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        return _smlCmd.executeSmlCommands("smlgetb", arCmd, new String[]{"0"}, null);
    }

    public void setSyslogEnable(String isEnable) throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("Cmd.System.StartSetup");
        cmds.add("Config.System.RmLogEnable." + isEnable);
        cmds.add("Cmd.System.SaveSetup");
        cmds.add("Cmd.System.ActSetup");
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        _smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, (String[][])new String[][]{{"0"}, {"0"}, {"0"}, {"0"}, {"0"}}, null);
    }

    public String[] getSyslogServer() throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("Config.System.LogHost");
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        return _smlCmd.executeSmlCommands("smlgetb", arCmd, new String[]{"0"}, null);
    }

    public void setSyslogServer(String ipAddress) throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("Cmd.System.StartSetup");
        cmds.add("Config.System.LogHost." + ipAddress);
        cmds.add("Cmd.System.SaveSetup");
        cmds.add("Cmd.System.ActSetup");
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        _smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, (String[][])new String[][]{{"0"}, {"0"}, {"0"}, {"0"}, {"0"}}, null);
    }

    public void setCopyConfig(String cmd, String localFileName, String remoteFileName, String ipAddress) throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("Cmd.Switch.TFTPSetup.LocalFileName." + localFileName);
        cmds.add("Cmd.Switch.TFTPSetup.RemoteFileName." + remoteFileName);
        cmds.add("Cmd.Switch.TFTPSetup.RemoteIPAddress." + ipAddress);
        cmds.add("Cmd.Switch.TFTPSetup.RemotePort.69");
        cmds.add("Cmd.Switch.TFTP" + cmd);
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        _smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, (String[][])new String[][]{{"0"}, {"0"}, {"0"}, {"0"}, {"0"}}, null, true, false);
    }

    public String[] getRadiusServerList() throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("Config.Radius.Servers");
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        String[] out = _smlCmd.executeSmlCommands("smlgetb", arCmd, new String[]{"0"}, null);
        int numOfServer = Integer.parseInt(out[0]);
        cmds = new ArrayList();
        String[] servers = new String[numOfServer];
        String[][] expectedCode = new String[numOfServer][];
        if (numOfServer > 0) {
            int i;
            for (i = 0; i < numOfServer; ++i) {
                cmds.add("Config.Radius.Server." + i + ".IPAddr");
                expectedCode[i] = new String[]{"0"};
            }
            arCmd = cmds.toArray(new String[cmds.size()]);
            out = _smlCmd.executeSmlCommandsAdv("smlgetb", arCmd, expectedCode, null);
            for (i = 0; i < servers.length && i < out.length; ++i) {
                servers[i] = QlogicCommandHandlerDM.parseHexIpString(out[i]);
            }
        }
        return servers;
    }

    public String[] getRadiusServerSecret() throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("Config.Radius.Servers");
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        String[] out = _smlCmd.executeSmlCommands("smlgetb", arCmd, new String[]{"0"}, null);
        int numOfServer = Integer.parseInt(out[0]);
        cmds = new ArrayList();
        String[] secrets = new String[numOfServer];
        String[][] expectedCode = new String[numOfServer][];
        if (numOfServer > 0) {
            for (int i = 0; i < numOfServer; ++i) {
                cmds.add("Config.Radius.Server." + i + ".Secret");
                expectedCode[i] = new String[]{"0"};
            }
            arCmd = cmds.toArray(new String[cmds.size()]);
            out = _smlCmd.executeSmlCommandsAdv("smlgetb", arCmd, expectedCode, null);
        }
        return out;
    }

    public String[] getRadiusServerIndex(String[] ipAddress) throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        String[][] expectedCode = new String[ipAddress.length + 4][];
        for (int i = 0; i < ipAddress.length; ++i) {
            cmds.add("Oper.Radius.Server." + ipAddress[i] + ".Index");
            expectedCode[i + 1] = new String[]{"0"};
        }
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        String[] out = _smlCmd.executeSmlCommandsAdv("smlgetb", arCmd, expectedCode, null);
        return out;
    }

    public String[] removeRadiusServer(String[] ipAddress, boolean setUserAuthOrder) throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        String[][] expectedCode = new String[ipAddress.length + 4][];
        cmds.add("Cmd.Radius.StartSetup");
        for (int i = 0; i < ipAddress.length; ++i) {
            cmds.add("Cmd.Radius.Server." + ipAddress[i] + ".Remove");
            expectedCode[i + 1] = new String[]{"0"};
        }
        cmds.add("Cmd.Radius.SaveSetup");
        cmds.add("Cmd.Radius.ActSetup");
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        String[] out = _smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, expectedCode, null);
        if (setUserAuthOrder) {
            cmds = new ArrayList();
            cmds.add("Cmd.Radius.StartSetup");
            cmds.add("Config.Radius.UserAuthOrder.Local");
            cmds.add("Cmd.Radius.SaveSetup");
            cmds.add("Cmd.Radius.ActSetup");
            arCmd = cmds.toArray(new String[cmds.size()]);
            out = _smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, (String[][])new String[][]{{"0"}, {"0"}, {"0"}, {"0"}, {"0"}}, null);
        }
        return out;
    }

    public String[] insertRadiusServer(String ipAddress, String secret, boolean setUserAuthOrder) throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        cmds.add("Oper.Radius.ServerOpenIndex");
        arCmd = cmds.toArray(new String[cmds.size()]);
        String[] out = _smlCmd.executeSmlCommands("smlgetb", arCmd, new String[]{"0"}, null);
        int nextIndex = 0;
        try {
            nextIndex = Integer.parseInt(out[0]);
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        cmds = new ArrayList();
        cmds.add("Cmd.Radius.StartSetup");
        cmds.add("Config.Radius.Servers." + (nextIndex + 1));
        cmds.add("Config.Radius.Server." + nextIndex + ".IPAddr." + ipAddress);
        cmds.add("Config.Radius.Server." + nextIndex + ".Secret." + secret);
        cmds.add("Cmd.Radius.SaveSetup");
        cmds.add("Cmd.Radius.ActSetup");
        arCmd = cmds.toArray(new String[cmds.size()]);
        out = _smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, (String[][])new String[][]{{"0"}, {"0"}, {"0"}, {"0"}, {"0"}, {"0"}, {"0"}}, null);
        if (setUserAuthOrder) {
            cmds = new ArrayList();
            cmds.add("Cmd.Radius.StartSetup");
            cmds.add("Config.Radius.UserAuthOrder.RadiusLocal");
            cmds.add("Cmd.Radius.SaveSetup");
            cmds.add("Cmd.Radius.ActSetup");
            arCmd = cmds.toArray(new String[cmds.size()]);
            out = _smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, (String[][])new String[][]{{"0"}, {"0"}, {"0"}, {"0"}, {"0"}}, null);
        }
        return out;
    }

    public void showFlash(SnmpPeer peer) throws Exception {
        try {
            new VshDump((JFrame)DeviceManager.getInstance(), peer + " - Flash Files", new String[]{"dir\n"}, Discover.getPeer()).setVisible(true);
        }
        catch (IOException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (Exception)ex);
        }
    }

    public void showProcess(SnmpPeer peer) throws Exception {
        try {
            new VshDump((JFrame)DeviceManager.getInstance(), peer + " - Running Processes", new String[]{"show Proc\n"}, Discover.getPeer()).setVisible(true);
        }
        catch (IOException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (Exception)ex);
        }
    }

    public void showUsers(SnmpPeer peer) throws Exception {
        try {
            new VshDump((JFrame)DeviceManager.getInstance(), peer + " - Show User Account", new String[]{"show User-account\n"}, Discover.getPeer()).setVisible(true);
        }
        catch (IOException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (Exception)ex);
        }
    }

    public void setBeacon(int port, boolean isOn) throws Exception {
        --port;
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("Cmd.Switch.EditConfig");
        StringBuffer sb = new StringBuffer();
        sb.append("Config.UserPort.0.");
        sb.append(port);
        sb.append(".Beacon.");
        sb.append(isOn ? "True" : "False");
        cmds.add(sb.toString());
        cmds.add("Cmd.Switch.SaveConfig");
        cmds.add("Cmd.Switch.ActConfig");
        String[] arCmd = cmds.toArray(new String[cmds.size()]);
        _smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, (String[][])new String[][]{{"0"}, {"0"}, {"0"}, {"0"}, {"0"}}, null);
    }

    public void loopbackAction(PhysicalElement[] selected, boolean isInternalLoop) throws Exception {
        String[] cmds = new String[selected.length];
        StringBuffer nameList = new StringBuffer();
        for (int i = 0; i < selected.length; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append("sys health ");
            sb.append(isInternalLoop ? "internal-loopback" : "external");
            sb.append(" int fc ");
            sb.append("1/");
            sb.append(selected[i].getIndex()[1]);
            nameList.append(i == 0 ? "fc " : ", ");
            nameList.append(selected[i].getIndex()[0]);
            nameList.append("/");
            nameList.append(selected[i].getIndex()[1]);
            cmds[i] = sb.toString() + "\n";
        }
        String title = isInternalLoop ? "Internal Loopback " : "External Loopback ";
        try {
            if (isInternalLoop) {
                new VshDump((JFrame)DeviceManager.getInstance(), title, cmds, Discover.getPeer()).setVisible(true);
            } else {
                new VshDump((JFrame)DeviceManager.getInstance(), title, cmds, Discover.getPeer(), true).setVisible(true);
            }
        }
        catch (IOException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (Exception)ex);
        }
    }

    public static String extractSmlOutput(String out) {
        int offset = out.indexOf("returned value: ");
        if (offset != -1) {
            out = out.substring(offset + 16);
        } else {
            offset = out.indexOf(35);
            if (offset != -1) {
                out = out.substring(0, offset);
            }
        }
        return out;
    }

    public static boolean parseTrueValueString(String out) throws Exception {
        if (!(out = QlogicCommandHandlerDM.extractSmlOutput(out)).equalsIgnoreCase("True") && !out.equalsIgnoreCase("False")) {
            throw new Exception("Error: output: " + out);
        }
        return out.equalsIgnoreCase("True");
    }

    public static String parseHexIpString(String hex) throws Exception {
        hex = QlogicCommandHandlerDM.extractSmlOutput(hex);
        byte[] b = SnmpString.fromHexString((String)hex, (boolean)false);
        return new SnmpInetAddress(b).toString();
    }
}

