/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020.fc;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.System9020;
import com.cisco.dcbu.lib.jnm.Fc4Decoder;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditNameServerTable
extends EditTable {
    private static final int FCPORTNAME = 6;
    private static final int FC4TYPE = 7;
    private static final int FC4FEATURE = 8;

    public EditNameServerTable(String[] vars) {
        super(vars);
    }

    protected int[] getIndex() {
        return System9020.getUnitId();
    }

    protected void build() {
        super.build();
        this._table.removeColumn(this._table.getColumnModel().getColumn(9));
    }

    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        VarBindList vbl = pdu.getVariables();
        byte[] fWwn = vbl.byteValue(6);
        byte[] fc4Type = vbl.byteValue(7);
        String fc4 = (String)Fc4Decoder.fcNameServerFC4Features((SnmpString)((SnmpString)pdu.getVar(7)), (SnmpString)((SnmpString)pdu.getVar(8)));
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        row[8] = fc4;
        if (WwnDictionary.isCiscoWwn((byte[])fWwn)) {
            int ifIndex = 0;
            if (fc4Type.length >= 32) {
                if (fc4Type[31] == 2) {
                    ifIndex = IfIndexUtil.fWwn2IscsiIfIndex((byte[])fWwn);
                } else if (fc4Type[31] == 4) {
                    ifIndex = IfIndexUtil.fWwn2SvcIfIndex((byte[])fWwn);
                }
            }
            if (ifIndex != 0) {
                row[7] = row[7] + " (" + Discover.getRoot().ifIndexToName(ifIndex) + ")";
            }
        }
        return row;
    }
}

