/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020.security;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020.QlogicCommandHandlerDM;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.CheckBoxListPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JFrame;

public class EditRadiusTable
extends EditTable {
    static final int LIST = 0;
    static final int IPADDRESS = 1;
    static final int UDPPort = 2;
    static final int PASSWD = 3;
    CheckBoxListPanel _listPanel;

    public EditRadiusTable(String[] vars) {
        super(vars);
    }

    protected void buildTable() {
        super.buildTable();
        this._table.setSelectionMode(1);
    }

    protected void get() {
        this._parent.setCursor(Cursor.getPredefinedCursor(3));
        this._data.clear();
        String[] allServers = null;
        try {
            QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance((JFrame)DeviceManager.getInstance(), Discover.getPeer());
            allServers = cmdHandler.getRadiusServerList();
            int num = allServers.length / 2;
            for (int i = 0; i < allServers.length; ++i) {
                Object[] row = new Object[3];
                row[0] = new Integer(i);
                row[1] = new SnmpIpAddress(allServers[i]);
                this._data.addElement((Object)row);
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this._parent, (String)ex.getMessage());
        }
        this._parent.setCursor(Cursor.getDefaultCursor());
        this.setStatus(this._data.size() + " row(s)");
        this.updateTable();
    }

    protected void delete() throws SnmpException {
        int[] selected = this._table.getSelectedRows();
        if (selected.length == 0) {
            return;
        }
        String[] hexAddress = new String[selected.length];
        for (int i = 0; i < hexAddress.length; ++i) {
            Object[] row = (Object[])this._data.elementAt(selected[i]);
            byte[] b = ((SnmpString)row[1]).getValue();
            hexAddress[i] = SnmpString.toHexString((byte[])b, (int)0, (int)b.length, (boolean)false);
        }
        try {
            boolean anySecret;
            String[] allSecrets = null;
            Array serverWithSecret = new Array();
            QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance((JFrame)DeviceManager.getInstance(), Discover.getPeer());
            allSecrets = cmdHandler.getRadiusServerSecret();
            for (int i = 0; i < allSecrets.length; ++i) {
                if (allSecrets[i].equals("")) continue;
                serverWithSecret.addElement((Object)new Integer(i));
                break;
            }
            boolean bl = anySecret = serverWithSecret.size() > 0;
            if (serverWithSecret.size() > 0) {
                String[] out = cmdHandler.getRadiusServerIndex(hexAddress);
                for (int i = 0; i < out.length; ++i) {
                    int j = 0;
                    if (j >= serverWithSecret.size() || !out[i].equals(((Integer)serverWithSecret.elementAt(j)).toString())) continue;
                    serverWithSecret.removeElementAt(j);
                }
            }
            cmdHandler.removeRadiusServer(hexAddress, anySecret && serverWithSecret.size() == 0);
        }
        catch (Exception ex) {
            throw new SnmpException(ex.getMessage());
        }
        this.get();
    }

    public void fetchRow(int[] index) throws SnmpException {
        this.get();
        this.setStatus("created.");
    }
}

