/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.physical;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.physical.GraphOverSubscriptionTable;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CheckOversubscription
extends JDialog
implements ActionListener {
    private static CheckOversubscription _Instance;
    private static final int[] _cieIfInOctetRateOid;
    private static final int[] _cieIfOutOctetRateOid;
    static final String[] BTNS;
    MonitorMenuButton _monitorBtn;
    JButton[] _btns;
    SnmpPeer _peer;
    JFrame _parent;
    JTextArea _log;
    int TAB_SIZE = 12;

    public CheckOversubscription(JFrame parent, SnmpPeer peer) {
        super(parent);
        this._parent = parent;
        this._peer = peer;
        this._log = new JTextArea();
        this._log.setEditable(false);
        this._log.setWrapStyleWord(true);
        this._log.setLineWrap(true);
        this._log.setTabSize(this.TAB_SIZE);
        JScrollPane sp = new JScrollPane(this._log);
        sp.setPreferredSize(new Dimension(680, 200));
        this._btns = DialogUtil.buildButtons((String[])BTNS, (ActionListener)this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        this._monitorBtn = new MonitorMenuButton(null, "Monitor", Discover.getPeer());
        buttonPanel.add((Component)((Object)this._monitorBtn));
        for (int i = 0; i < this._btns.length; ++i) {
            buttonPanel.add(this._btns[i]);
        }
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add("North", buttonPanel);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)sp, (JPanel)southPanel);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
    }

    public static CheckOversubscription getInstance(JFrame frame, SnmpPeer peer) {
        if (_Instance == null) {
            _Instance = new CheckOversubscription(frame, peer);
        }
        return _Instance;
    }

    @Override
    public void dispose() {
        super.dispose();
        this._monitorBtn = null;
    }

    public void showDialog(PhysicalElement[] selected, Integer offset, Integer max, Integer numPortPerGroup) {
        String result;
        if (!this.checkModuleType(selected)) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (String)"Please select the same module type to Check OverSubscription.");
            return;
        }
        this.setTitle(this._peer + " - Check Oversubscription");
        if (this._monitorBtn != null) {
            this._monitorBtn.setGroups(selected, offset, max, numPortPerGroup);
        }
        if (!(result = this.updateLog(selected, offset, max, numPortPerGroup)).equals("")) {
            this._log.setText(result);
            this.setVisible(true);
        }
    }

    private long getMaxSpeed(int cardType) {
        switch (cardType) {
            case 53: 
            case 54: {
                return 3360000000L;
            }
            case 61: {
                return 6724000000L;
            }
        }
        return 1200000000L;
    }

    private String getMaxSpeedString(int cardType) {
        switch (cardType) {
            case 53: 
            case 54: {
                return "3360 MB/s";
            }
            case 61: {
                return "6724 MB/s";
            }
        }
        return "1280 MB/s";
    }

    private String updateLog(PhysicalElement[] selected, int offset, int max, int numPortPerGroup) {
        int[] cardTypes = DmSystem.getCardTypes();
        int cardType = cardTypes[selected[0].getIndex()[0] - 21 - 1];
        long maxSpeed = this.getMaxSpeed(cardType);
        VarBindList vbl = new VarBindList();
        for (int j = 0; j < selected.length; ++j) {
            int card = selected[j].getIndex()[0] - 21;
            for (int i = offset; i <= max; ++i) {
                int ifIndex = Discover.getRoot().nameToIfIndex(card, i, 1);
                vbl.add(new SnmpVarBind(new SnmpOID(_cieIfInOctetRateOid, ifIndex)));
                vbl.add(new SnmpVarBind(new SnmpOID(_cieIfOutOctetRateOid, ifIndex)));
            }
        }
        if (vbl.size() == 0) {
            return "No card matched";
        }
        String maxSpeedString = this.getMaxSpeedString(cardType);
        StringBuffer sb = new StringBuffer();
        try {
            SnmpPDU resp = SnmpFetch.get((SnmpPeer)Discover.getPeer(), (VarBindList)vbl);
            vbl = resp.getVariables();
            long totalRxSpeed = 0L;
            long totalTxSpeed = 0L;
            int numOfObject = numPortPerGroup * 2;
            sb.append("Module\tGroup\tPorts\tMax Thruput\tInputRate\t OutputRate\n");
            for (int i = 0; i < vbl.size(); i += numOfObject) {
                int[] oid = vbl.get(i).getOid().getValue();
                int card = Discover.getRoot().ifIndex2Card(oid[oid.length - 1]) + 1;
                int group = i / numOfObject + 1;
                int startPort = Discover.getRoot().ifIndex2Port(oid[oid.length - 1]) + 1;
                int stopPort = startPort + numPortPerGroup - 1;
                for (int j = 0; j < numOfObject; j += 2) {
                    totalRxSpeed += vbl.longValue(i + j);
                    totalTxSpeed += vbl.longValue(i + j + 1);
                }
                String speedString = DefaultSnmpNumberRenderer.formatLong((long)totalRxSpeed, (boolean)true);
                boolean space = Character.isDigit(speedString.charAt(speedString.length() - 1));
                String rxSpeed = totalRxSpeed == 0L ? "0" : speedString + (space ? " B/s" : "B/s");
                speedString = DefaultSnmpNumberRenderer.formatLong((long)totalTxSpeed, (boolean)true);
                space = Character.isDigit(speedString.charAt(speedString.length() - 1));
                String txSpeed = totalTxSpeed == 0L ? "0" : speedString + (space ? " B/s" : "B/s");
                sb.append(card + "\t" + group + "\t" + startPort + "-" + stopPort + "\t" + maxSpeedString + "\t" + rxSpeed + "\t" + txSpeed);
                if (totalRxSpeed >= maxSpeed || totalTxSpeed >= maxSpeed) {
                    sb.append(" *** Oversubscribed?");
                }
                sb.append("\n");
                totalTxSpeed = 0L;
                totalRxSpeed = 0L;
            }
            sb.append("\n(Max Thruput and rates in bytes/sec after 10->8 bit conversion)\n");
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (String)("Failed to check oversubscription: " + ex.getMessage()));
            return "";
        }
        return sb.toString();
    }

    private boolean checkModuleType(PhysicalElement[] selected) {
        for (int i = 1; i < selected.length; ++i) {
            if (selected[i].getClass() == selected[i - 1].getClass()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = ((JButton)e.getSource()).getText();
        switch (cmd.charAt(0)) {
            case 'C': {
                this.setVisible(false);
            }
        }
    }

    static {
        _cieIfInOctetRateOid = MibNode.get((String)"cieIfInOctetRate").getOid();
        _cieIfOutOctetRateOid = MibNode.get((String)"cieIfOutOctetRate").getOid();
        BTNS = new String[]{"Close"};
    }

    class MonitorMenuButton
    extends MenuButton {
        SnmpPeer _peer;
        String[] _groupMenu;
        int _start;
        int _max;
        int _numPortPerGroup;

        public MonitorMenuButton(JMenu menu, String name, SnmpPeer peer) {
            super(menu, name);
            this._groupMenu = new String[0];
            this._peer = peer;
        }

        void setGroups(PhysicalElement[] selected, Integer offset, Integer max, Integer numPortPerGroup) {
            this._menu = null;
            this._start = offset;
            this._max = max;
            this._numPortPerGroup = numPortPerGroup;
            int numGroup = this._max / this._numPortPerGroup;
            this._groupMenu = new String[numGroup];
            for (int i = 0; i < selected.length; ++i) {
                for (int j = 0; j < numGroup; ++j) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Module ");
                    sb.append(selected[i].getIndex()[0] - 21);
                    sb.append("  Group ");
                    sb.append(j + 1);
                    this._groupMenu[i * numPortPerGroup.intValue() + j] = sb.toString();
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this._menu == null && this._groupMenu != null && this._groupMenu.length > 0) {
                this._menu = new JMenu();
                this.buildMenu(this._groupMenu);
            }
            if (e.getSource() instanceof JMenuItem) {
                int[][] index = new int[this._numPortPerGroup][];
                String text = ((JMenuItem)e.getSource()).getText();
                int grpOffset = text.indexOf("Group");
                int card = Integer.parseInt(text.substring(7, grpOffset - 2));
                int group = Integer.parseInt(text.substring(grpOffset + 6));
                for (int i = 0; i < index.length; ++i) {
                    int port = this._numPortPerGroup * (group - 1) + i + 1;
                    index[i] = new int[]{IfIndexUtil.nameToIfIndex((int)card, (int)port, (int)1)};
                }
                DMDialog dlg = DialogListener.getInstance().dialogAction("OverSubscription_Monitor", (int[][])index);
                if (dlg != null) {
                    dlg.setTitle(Discover.getDeviceName() + " - CheckOverSubscription  Module " + card + "  Group " + group);
                    DMPanel panel = dlg.getPanel(0);
                    if (panel != null) {
                        ((GraphOverSubscriptionTable)panel).setThreshold(new Long(1200000000L));
                    }
                }
            } else {
                super.actionPerformed(e);
            }
        }
    }
}

