/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.EditInetAddrInCFSTable;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class EditAAASvrTable
extends EditInetAddrInCFSTable {
    public static final int RADIUS = 2;
    public static final int LDAP = 3;
    public static int _protocolSupportUpto = Discover.isSysVersionlessThan((String)"7.0(0)") ? 2 : 3;

    public EditAAASvrTable(String[] vars, String addrVar, String addrTypeVar) {
        super(vars, new String[]{addrVar}, new String[]{addrTypeVar});
    }

    protected boolean isSkip(SnmpPDU pdu) {
        VarBindList vbl = pdu.getVariables();
        int[] oid = vbl.get(0).getOid().getValue();
        return oid[oid.length - 2] > _protocolSupportUpto;
    }

    @Override
    protected void sendInsertPdu(SnmpPDU pdu) throws SnmpException {
        if (Discover.isSysVersionGreaterThanEqual((String)"2.0(0)") && pdu.getVariables().size() > 0) {
            int[][] indeces = new int[2][];
            int[] oid = pdu.getVariables().get(0).getOid().getValue();
            if (oid[oid.length - 2] == 2) {
                indeces[0] = DmSystem.CFS_RADIUS_INDEX;
            } else {
                indeces[1] = DmSystem.CFS_TACACS_INDEX;
            }
            this.setCFSFeatureView(indeces);
        }
        super.sendInsertPdu(pdu);
    }

    protected SnmpPDU getDeletePDU(int[] selected) {
        if (Discover.isSysVersionGreaterThanEqual((String)"2.0(0)")) {
            int[][] indeces = new int[2][];
            for (int i = 0; i < selected.length; ++i) {
                int[] oid = this._tableModel.getIndex(selected[i]);
                if (oid[oid.length - 2] == 2) {
                    indeces[0] = DmSystem.CFS_RADIUS_INDEX;
                    continue;
                }
                indeces[1] = DmSystem.CFS_TACACS_INDEX;
            }
            this.setCFSFeatureView(indeces);
        }
        return super.getDeletePDU(selected);
    }

    @Override
    protected void sendDeletePdu(SnmpPDU pdu) throws SnmpException {
        super.sendDeletePdu(pdu);
        if (Discover.isSysVersionGreaterThanEqual((String)"2.0(0)")) {
            this.setCFSPending(this.getPeer());
        }
    }

    protected MenuButton getCFSButton() {
        return new CFSApplyButton(null, "CFS");
    }

    class CFSApplyButton
    extends MenuButton {
        String[] _cfsActionMenu;

        public CFSApplyButton(JMenu menu, String name) {
            super(menu, name);
            this._cfsActionMenu = new String[]{"radius Commit", "radius Abort", "tacacs Commit", "tacacs Abort"};
        }

        public void actionPerformed(ActionEvent e) {
            block10: {
                if (this._menu == null) {
                    this._menu = new JMenu();
                    this.buildMenu(this._cfsActionMenu);
                }
                boolean[] isEnabled = EditAAASvrTable.this.isCFSEnabled(true);
                int i = 0;
                int j = 0;
                while (i < isEnabled.length) {
                    EditAAASvrTable.this._cfsButton.getMenu().getItem(j).setEnabled(isEnabled[i]);
                    EditAAASvrTable.this._cfsButton.getMenu().getItem(j + 1).setEnabled(isEnabled[i]);
                    ++i;
                    j += 2;
                }
                if (e.getSource() instanceof JMenuItem) {
                    try {
                        if (((JMenuItem)e.getSource()).getText().startsWith("Apply")) {
                            EditAAASvrTable.this.set();
                            break block10;
                        }
                        String cmd = ((JMenuItem)e.getSource()).getText();
                        int action = ((JMenuItem)e.getSource()).getText().endsWith("Commit") ? 4 : 5;
                        int offset = ((JMenuItem)e.getSource()).getText().startsWith("radius") ? 0 : 1;
                        EditAAASvrTable.this.cfsAction(action, EditAAASvrTable.this._cfsFeatureIndex[offset]);
                    }
                    catch (SnmpException ex) {
                        Util.errorMessage((Component)DeviceManager.getInstance(), (String)ex.getMessage());
                    }
                    catch (Exception ex) {
                        if (SnmpSession.isTrace()) {
                            ex.printStackTrace();
                        }
                        Util.errorMessage((Component)DeviceManager.getInstance(), (String)ex.getMessage());
                    }
                    catch (Error ex) {
                        Util.errorMessage((Component)EditAAASvrTable.this._parent, (String)ex.getMessage());
                    }
                } else {
                    super.actionPerformed(e);
                }
            }
        }
    }
}

