/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.CommonRoleFeatureCache;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.InsertCommonRoleRule;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.mds.CommonRoleFeature;
import com.cisco.dcbu.lib.mds.CommonRoleUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class InsertCommonRole
extends InsertForm
implements ItemListener {
    RadioButtonPanel _buttonPanel;
    static final int NAME = 0;
    static final int VSANENABLE = 3;
    static final int VSANSCOPE = 4;
    static final int RULE = 5;
    InsertCommonRoleRule _insertRuleDialog;
    public CommonRoleFeature _ruleTable;
    Array _pduList = new Array();
    Array _rollbackPduList = new Array();
    boolean _isExceedMaxRules;

    public InsertCommonRole(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    protected void build() {
        super.build();
        ((JCheckBox)this._values[3]).addItemListener(this);
        this.setEnabled(4, false);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 3) {
            return new JCheckBox("Enable");
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected String getErrMsgFieldName(String mibVar, int index) {
        if (index == 3) {
            return "Enable";
        }
        if (index == 4) {
            return "Scope";
        }
        return super.getErrMsgFieldName(mibVar, index);
    }

    protected String[] getCreateButtons() {
        String[] btns = super.getCreateButtons();
        String[] newBtns = new String[btns.length + 1];
        System.arraycopy(btns, 0, newBtns, 1, btns.length);
        newBtns[0] = "Rules...";
        return newBtns;
    }

    public void dispose() {
        if (this._insertRuleDialog != null) {
            this._insertRuleDialog.dispose();
        }
        super.dispose();
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 3) {
            return new SnmpInt(((JCheckBox)this._values[index]).isSelected() ? 2 : 1);
        }
        return super.getComponentValue(index);
    }

    protected SnmpVar[] getInsertValue() throws Exception {
        if (((JTextField)this._values[0]).getText().equals("")) {
            throw new SnmpException("RoleName cannot be blank");
        }
        return super.getInsertValue();
    }

    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        if (this._insertRuleDialog != null) {
            this._ruleTable = this._insertRuleDialog.getRuleTable();
        }
        this._isExceedMaxRules = CommonRoleUtil.getInstance().getNewRolePDU(this._pduList, this._rollbackPduList, index, ((SnmpString)values[0])._value, (SnmpString)values[1], (SnmpInt)values[3], (SnmpBitmap)values[4], this._ruleTable == null ? null : this._ruleTable.getData(), CommonRoleFeatureCache.getInstance().getMaxRulePerRole(), Discover.getSysVersionObject());
        return null;
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        this.buildInsertPDU(index, values);
        if (this._isExceedMaxRules) {
            throw new Exception("Max rules per role is " + CommonRoleFeatureCache.getInstance().getMaxRulePerRole());
        }
        if (this._pduList.size() > 0) {
            int pduP = 0;
            try {
                for (int i = 0; i < this._pduList.size(); ++i) {
                    this.getPeer().set((SnmpPDU)this._pduList.elementAt(i));
                }
            }
            catch (SnmpException ex) {
                try {
                    for (int i = pduP - 1; i >= 0; --i) {
                        SnmpFetch.set((SnmpPeer)this.getPeer(), (SnmpPDU)((SnmpPDU)this._rollbackPduList.elementAt(pduP)));
                    }
                }
                catch (SnmpException ex1) {
                    StringBuffer err = new StringBuffer(ex.getMessage());
                    err.append("\nRollback failed: ");
                    err.append(ex1.getMessage());
                    throw new SnmpException(err.toString());
                }
                throw ex;
            }
        }
        this._table.setCFSPending(this.getPeer());
    }

    protected void insert() throws Exception {
        if (this._insertRuleDialog != null) {
            this._ruleTable = this._insertRuleDialog.getRuleTable();
        }
        if (!CommonRoleUtil.getInstance().isPermitShowInterfaceRuleExist(this._ruleTable == null ? null : this._ruleTable.getData()) && JOptionPane.showConfirmDialog((Component)this.getParent(), "You must add rule 'permit show interface' to this role to make it effective.  Continue ?", this._parent.getTitle(), 0) != 0) {
            return;
        }
        super.insert();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected;
        boolean bl = isSelected = e.getStateChange() == 1;
        if (e.getSource() == this._values[3]) {
            this.setEnabled(4, isSelected);
        }
    }

    public void actionPerformed(ActionEvent e) {
        char cmd = ((AbstractButton)e.getSource()).getText().charAt(0);
        if (cmd == 'R') {
            String msg = this.getCreateStatus();
            this.setCreateStatus("Retrieving features, please wait...");
            this._parent.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new RoleRuleWorker(e, msg));
        } else {
            super.actionPerformed(e);
            if (cmd == 'C') {
                this._ruleTable = null;
                if (this._insertRuleDialog != null) {
                    this._insertRuleDialog.dispose();
                }
                this._insertRuleDialog = null;
                this._pduList = new Array();
                this._rollbackPduList = new Array();
            }
        }
    }

    class RoleRuleWorker
    implements Runnable {
        ActionEvent _event;
        String _message;

        public RoleRuleWorker(ActionEvent event, String message) {
            this._event = event;
            this._message = message;
        }

        @Override
        public void run() {
            HashMap features = CommonRoleUtil.getInstance().getFeatureHash(InsertCommonRole.this.getPeer(), CommonRoleFeatureCache.getInstance().getCommonRoleFeatures());
            CommonRoleFeatureCache.getInstance().setCommonRoleFeatures(features);
            long maxRulePerRole = CommonRoleUtil.getInstance().getMaxRulePerRole(InsertCommonRole.this.getPeer(), CommonRoleFeatureCache.getInstance().getMaxRulePerRole());
            CommonRoleFeatureCache.getInstance().setMaxRulePerRole(maxRulePerRole);
            JFrame parent = (JFrame)InsertCommonRole.this._parent.getParent();
            if (InsertCommonRole.this._insertRuleDialog != null) {
                InsertCommonRole.this._ruleTable = InsertCommonRole.this._insertRuleDialog.getRuleTable();
            } else {
                InsertCommonRole.this._insertRuleDialog = new InsertCommonRoleRule(parent, InsertCommonRole.this._table, InsertCommonRole.this.getPeer(), null, InsertCommonRole.this._ruleTable, false);
                InsertCommonRole.this._insertRuleDialog.setTitle(Discover.getDeviceName() + " - Create Role Rules");
                InsertCommonRole.this._insertRuleDialog.setLocation(DialogUtil.getPointOnScreen((Point)new Point(0, 0), (Component)((JComponent)this._event.getSource()), (Dimension)InsertCommonRole.this._insertRuleDialog.getSize()));
            }
            InsertCommonRole.this._insertRuleDialog.setVisible(true);
            InsertCommonRole.this.setCreateStatus(this._message);
            InsertCommonRole.this._parent.setCursor(Cursor.getDefaultCursor());
        }
    }
}

