/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.EditGroupTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.InsertView;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.VacmViewTree;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.CheckBoxListPanel;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class InsertGroup
extends InsertForm {
    static final String[] _Labels = new String[]{"Role:", "Level:"};
    static final String[] _Vars = new String[]{"vacmGroupName", "vacmAccessSecurityLevel", "vacmAccessReadViewName", "vacmAccessWriteViewName"};
    static final int[][] _DefNMSAccess = new int[][]{{1, 3, 6, 1, 2, 1, 1}, {1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1}, {1, 3, 6, 1, 4, 1, 9, 9, 117, 1, 2, 1, 1, 2}, {1, 3, 6, 1, 4, 1, 9, 9, 117, 1, 1, 2, 1, 2}};
    static final String[] _Choices = new String[]{"all", "none", "list:"};
    final int[] _insertVarOid = MibNode.get((String)"vacmViewTreeFamilyStatus").getOid();
    static final String[] _varVbl = new String[]{"vacmViewTreeFamilyMask", "vacmViewTreeFamilyType"};
    final int[][] _varVblOid = new int[][]{MibNode.get((String)"vacmViewTreeFamilyMask").getOid(), MibNode.get((String)"vacmViewTreeFamilyType").getOid()};
    final SnmpInt _CREATEANDGO = new SnmpInt(4);
    static final int READ = 0;
    static final int WRITE = 1;
    static final int ROLE = 0;
    static final int READACCESS = 2;
    static final int WRITEACCESS = 3;
    String[] _Views;
    Array _viewTreeList;
    Array[] _newViewList = new Array[2];
    String[] _newViewName = new String[2];
    CheckBoxListPanel[] _listPanel = new CheckBoxListPanel[2];
    RadioButtonPanel[] _buttonPanel = new RadioButtonPanel[2];
    String _Role;
    HashMap _subtreeList;

    public InsertGroup(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    protected void build() {
        int i;
        this._mibNodes = new MibNode[_Vars.length];
        for (i = 0; i < this._mibNodes.length; ++i) {
            this._mibNodes[i] = MibNode.get((String)_Vars[i]);
        }
        this._labels = new JLabel[_Labels.length];
        for (i = 0; i < this._labels.length; ++i) {
            this._labels[i] = new JLabel(_Labels[i], 4);
        }
        this._values = new JComponent[_Vars.length];
        this._values[0] = this.buildComponent(_Vars[0], this._mibNodes[0], 0);
        this._values[1] = this.buildComponent(_Vars[1], this._mibNodes[1], 1);
        if (this._Views == null) {
            this.getViews();
        }
        this._values[2] = this.createAccess("Read Access", 0);
        this._values[3] = this.createAccess("Write Access", 1);
        this.layoutForm();
        JPanel listPanel = new JPanel();
        listPanel.add(this._values[2]);
        listPanel.add(this._values[3]);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        DialogUtil.constrain((Container)this._container, (Component)listPanel, (GridBagConstraints)gbc, (int)0, (int)3, (int)2, (int)13);
        ((JPanel)this._container).setBorder(DialogUtil._Margin);
        ((GroupButtonPanel)this._values[1]).setSelected(1);
        this._buttonPanel[0].setSelected(0);
        this._listPanel[0].clearSelection();
        this._listPanel[0].setEnabled(false);
        this._buttonPanel[1].setSelected(2);
        this._listPanel[1].clearSelection();
        this.buildButtons();
    }

    JPanel createAccess(String title, int access) {
        JPanel box = new JPanel(null);
        box.setLayout(new BoxLayout(box, 1));
        box.setBorder(BorderFactory.createTitledBorder(title));
        this._buttonPanel[access] = new RadioButtonPanel((Object[])_Choices);
        for (int i = 0; i < _Choices.length; ++i) {
            this._buttonPanel[access].getButton(i).addActionListener((ActionListener)((Object)this));
        }
        box.add((Component)this._buttonPanel[access]);
        this._listPanel[access] = new CheckBoxListPanel((Object[])this._Views);
        JScrollPane sp = new JScrollPane((Component)this._listPanel[access]);
        this._listPanel[access].setUnitIncrement(sp);
        sp.setPreferredSize(new Dimension(170, 200));
        box.add(sp);
        return box;
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 2 || index == 3) {
            int panel = index == 2 ? 0 : 1;
            String access = index == 2 ? "-rd" : "-wr";
            this._Role = ((JTextField)this._values[0]).getText();
            this._newViewList[panel] = new Array();
            if (this._listPanel[panel].isEnabled()) {
                String newViewName;
                Object[] selected = this._listPanel[panel].getSelectedValues();
                if (selected.length == 0) {
                    throw new SnmpException("Please make a selection");
                }
                for (int i = 0; i < selected.length; ++i) {
                    this._newViewList[panel].addElement((Object)selected[i].toString());
                }
                this._newViewName[panel] = newViewName = this._Role.concat(access);
                return new SnmpString(newViewName);
            }
            if (this._buttonPanel[panel].getButton(1).isSelected()) {
                this._newViewName[panel] = this._Role.concat(access);
                return new SnmpString("network-operator-wr");
            }
            return new SnmpString("network-admin" + access);
        }
        return super.getComponentValue(index);
    }

    protected SnmpVar[] getInsertValue() throws Exception {
        if (((JTextField)this._values[0]).getText().equals("")) {
            throw new SnmpException("Role cannot be blank");
        }
        return super.getInsertValue();
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        for (int i = 0; i < this._newViewName.length; ++i) {
            if (this._newViewName[i] == null || this._newViewName[i].length() <= 0 || this._newViewList[i] == null || this._newViewList[i].size() == 0) continue;
            this._subtreeList = null;
            for (int j = 0; j < this._newViewList[i].size(); ++j) {
                this.createView(this._newViewName[i], (String)this._newViewList[i].elementAt(j));
            }
            if (i != 0) continue;
            this.addDefNMSReadAccess(this._newViewName[0]);
        }
        super.tableInsert(values, index);
    }

    protected int[] getInsertIndex(SnmpVar[] values) {
        byte[] b = ((SnmpString)values[0]).getValue();
        int rolelen = b.length;
        int indexSize = rolelen + 3;
        int[] index = new int[indexSize];
        indexSize = rolelen + 1;
        index[indexSize++] = 0;
        index[indexSize++] = 0;
        index[indexSize] = ((SnmpInt)values[1]).getValue();
        return index;
    }

    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        pdu.removeVarAt(1);
        return pdu;
    }

    void getViews() {
        int i;
        this._viewTreeList = ((EditGroupTable)this._table).getSubtrees();
        Array viewList = new Array(20);
        String preView = "";
        for (i = 0; i < this._viewTreeList.size(); ++i) {
            String view = ((VacmViewTree)this._viewTreeList.elementAt(i)).getViewName();
            if (view.equals(preView)) continue;
            viewList.addElement((Object)view);
            preView = view;
        }
        this._Views = new String[viewList.size()];
        for (i = 0; i < this._Views.length; ++i) {
            this._Views[i] = (String)viewList.elementAt(i);
        }
    }

    Array getSubtreeFromView(String view) {
        if (this._viewTreeList.size() == 0) {
            return null;
        }
        Array subTreeList = new Array();
        for (int i = 0; i < this._viewTreeList.size(); ++i) {
            if (!view.equals(((VacmViewTree)this._viewTreeList.elementAt(i)).getViewName())) continue;
            subTreeList.addElement(this._viewTreeList.elementAt(i));
        }
        return subTreeList;
    }

    void createView(String newView, String cloneView) {
        Array treeList = this.getSubtreeFromView(cloneView);
        if (treeList == null) {
            return;
        }
        for (int i = 0; i < treeList.size(); ++i) {
            VacmViewTree v = (VacmViewTree)treeList.elementAt(i);
            int[] subtree = v.getSubTree();
            if (this.isSubtreeDuplicated(subtree)) continue;
            int[] idx = InsertView.getViewIndex(newView, subtree);
            try {
                SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
                pdu.addVar(new SnmpOID(this._insertVarOid, idx), (SnmpVar)this._CREATEANDGO);
                pdu.addVar(new SnmpOID(this._varVblOid[0], idx), v.getMask());
                pdu.addVar(new SnmpOID(this._varVblOid[1], idx), v.getType());
                this.getPeer().set(pdu);
                continue;
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.debug((Object)ex);
            }
        }
    }

    boolean isSubtreeDuplicated(int[] subtree) {
        if (this._subtreeList == null) {
            this._subtreeList = new HashMap();
            this._subtreeList.put(SnmpOID.toString((int[])subtree), "1");
            return false;
        }
        if (this._subtreeList.get(SnmpOID.toString((int[])subtree)) != null) {
            return true;
        }
        this._subtreeList.put(SnmpOID.toString((int[])subtree), "1");
        return false;
    }

    void addDefNMSReadAccess(String newView) {
        for (int i = 0; i < _DefNMSAccess.length; ++i) {
            int[] subtree = _DefNMSAccess[i];
            if (this.isSubtreeDuplicated(subtree)) continue;
            int[] idx = InsertView.getViewIndex(newView, subtree);
            try {
                SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
                pdu.addVar(new SnmpOID(this._insertVarOid, idx), (SnmpVar)this._CREATEANDGO);
                byte[] mask = new byte[]{-1};
                pdu.addVar(new SnmpOID(this._varVblOid[0], idx), (SnmpVar)new SnmpString(mask));
                pdu.addVar(new SnmpOID(this._varVblOid[1], idx), (SnmpVar)new SnmpInt(1));
                this.getPeer().set(pdu);
                continue;
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.debug((Object)("addDefNMSReadAccess: " + ex));
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        char cmd = ((AbstractButton)e.getSource()).getText().charAt(0);
        if (cmd == 'a' || cmd == 'n' || cmd == 'l') {
            int panel = ((AbstractButton)e.getSource()).getParent() == this._buttonPanel[0] ? 0 : 1;
            this._listPanel[panel].setEnabled(cmd == 'l');
        } else {
            super.actionPerformed(e);
        }
    }
}

