/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.CheckBoxListPanel;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ServerListFieldPanel
extends FieldPanel
implements ActionListener {
    JButton _button;
    SnmpPeer _peer;
    JComponent _protocol;
    SvrLstDialog _serverListDialog;
    String[] _radiusServerList;
    String[] _tacacsServerList;

    public ServerListFieldPanel(int width, SnmpPeer peer, JComponent protocol) {
        super(width);
        this._peer = peer;
        this._protocol = protocol;
        this._button = new JButton("...");
        this._button.setMargin(Util.getNoBorder());
        this._button.addActionListener(this);
        this.addGap();
        this.add(this._button);
    }

    JButton getButton() {
        return this._button;
    }

    void setServerList(String list) {
        this.setText(list);
    }

    void refreshDialog(String protocol) {
        String[] selections;
        if (this._serverListDialog == null) {
            return;
        }
        String[] stringArray = selections = protocol.startsWith("radius") ? this._radiusServerList : this._tacacsServerList;
        if (selections == null || selections.length == 0) {
            this._serverListDialog.setVisible(false);
            this._button.setEnabled(false);
        } else {
            this._serverListDialog.setVisible(false);
            this._serverListDialog.setChoices(selections);
            this._serverListDialog.setVisible(true);
        }
    }

    void fetchServerList() throws SnmpException {
        int i;
        VarBindList vbl = new VarBindList();
        vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cAAAServerAddr").getOid())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cAAAServerAddrType").getOid())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"casAuthenPort").getOid())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"casAcctPort").getOid())));
        vbl = SnmpFetch.getBulk((SnmpPeer)this._peer, (VarBindList)vbl).getVariables();
        if (vbl.size() == 0) {
            this._tacacsServerList = null;
            this._radiusServerList = null;
            return;
        }
        Array radiusList = new Array();
        Array tacacsList = new Array();
        for (i = 0; i < vbl.size(); i += 4) {
            int[] oid = vbl.get(i).getOid().getValue();
            boolean isRadius = oid[oid.length - 2] == 2;
            int index = oid[oid.length - 1];
            StringBuffer sb = new StringBuffer();
            sb.append(index + " (");
            int addrType = ((SnmpInt)vbl.get(i + 1).getVar()).getValue();
            String addr = addrType == 16 ? ((SnmpString)vbl.get(i).getVar()).toString() : SnmpIpAddress.toString((byte[])((SnmpString)vbl.get(i).getVar()).getValue());
            sb.append(addr);
            sb.append(", " + ((SnmpInt)vbl.get(i + 2).getVar()).toString());
            sb.append(", " + ((SnmpInt)vbl.get(i + 3).getVar()).toString());
            sb.append(")");
            if (isRadius) {
                radiusList.addElement((Object)sb);
                continue;
            }
            tacacsList.addElement((Object)sb);
        }
        this._radiusServerList = new String[radiusList.size()];
        for (i = 0; i < radiusList.size(); ++i) {
            this._radiusServerList[i] = ((StringBuffer)radiusList.elementAt(i)).toString();
        }
        this._tacacsServerList = new String[tacacsList.size()];
        for (i = 0; i < tacacsList.size(); ++i) {
            this._tacacsServerList[i] = ((StringBuffer)tacacsList.elementAt(i)).toString();
        }
    }

    public void dispose() {
        if (this._serverListDialog != null) {
            this._serverListDialog.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selected;
        String[] selections;
        try {
            this.fetchServerList();
        }
        catch (SnmpException ex) {
            // empty catch block
        }
        if (this._serverListDialog == null) {
            this._serverListDialog = new SvrLstDialog(Util.getFrameAncestor((Component)((Object)this)), this);
        }
        String[] stringArray = selections = (selected = ((RadioButtonPanel)this._protocol).getSelected()) == 1 ? this._radiusServerList : this._tacacsServerList;
        if (selections == null || selections.length == 0) {
            this._button.setEnabled(false);
            JOptionPane.showMessageDialog((Component)((Object)this), "No match", "Warning", 2);
            return;
        }
        this._serverListDialog.setChoices(selections);
        JComponent c = (JComponent)e.getSource();
        this._serverListDialog.setLocation(DialogUtil.getPointOnScreen((Point)new Point(((Component)c).getWidth(), 0), (Component)c, (Dimension)this._serverListDialog.getSize()));
        this._serverListDialog.setVisible(true);
        this._serverListDialog.toFront();
    }

    class SvrLstDialog
    extends JDialog
    implements ActionListener {
        String[] _BtnLabel;
        ServerListFieldPanel _field;
        CheckBoxListPanel _listPanel;

        public SvrLstDialog(JFrame parent, ServerListFieldPanel field) {
            super(parent);
            this._BtnLabel = new String[]{"OK", "Close"};
            this._field = field;
            JPanel main = new JPanel(new BorderLayout());
            main.setBorder(DialogUtil._Margin);
            Object[] list = new String[]{};
            this._listPanel = new CheckBoxListPanel(list);
            JScrollPane sp = new JScrollPane((Component)this._listPanel);
            this._listPanel.setUnitIncrement(sp);
            sp.setPreferredSize(new Dimension(170, 100));
            JPanel buttons = new JPanel(new FlowLayout(2, 6, 3));
            for (int i = 0; i < this._BtnLabel.length; ++i) {
                JButton b = new JButton(this._BtnLabel[i]);
                b.addActionListener(this);
                buttons.add(b);
            }
            main.add("Center", sp);
            main.add("South", buttons);
            this.getContentPane().add(main);
            this.setTitle(parent.getTitle());
            this.pack();
        }

        void setChoices(String[] choices) {
            this._listPanel.clearChoices();
            this._listPanel.setChoices((Object[])choices);
            this._listPanel.clearSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            char ch = ((JButton)e.getSource()).getText().charAt(0);
            if (ch == 'O') {
                Object[] selections = this._listPanel.getSelectedValues();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < selections.length; ++i) {
                    String selection = (String)selections[i];
                    int offset = selection.indexOf(32);
                    if (offset == -1) continue;
                    String id = selection.substring(0, offset);
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(id);
                }
                this._field.setServerList(sb.toString());
            }
            super.setVisible(false);
        }
    }
}

