/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.span;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.CheckBoxPanel;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.util.Array;
import javax.swing.JComponent;

public class InsertSPANFCSource
extends InsertForm {
    protected int SESSIONID = 0;
    protected int IFINDEX = 1;
    int DIRECTION = 2;
    MdsPortChooser _ports;
    boolean _isMultipleInterfaces;
    String _ifName;
    int _direction;
    SnmpPDU _insertPDU;
    CheckBoxPanel _directionPanel;

    public InsertSPANFCSource(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == this.IFINDEX) {
            this._ports = new MdsPortChooser(Discover.getDeviceName(), 3, false, (IfIndexIf)Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{22, 27, 39, 41}, new int[]{1, 153, 152}, 1, new int[]{2}), this.getPeer(), 8);
            return this._ports;
        }
        if (index == this.DIRECTION) {
            this._directionPanel = new CheckBoxPanel((Object[])mibNode.getEnums(), 3);
            return this._directionPanel;
        }
        if (DmId.isN5K(Discover.getSysObjectID()) && !Discover.isSysVersionlessThan((String)"4.0(1a)") && index == this.SESSIONID) {
            int width = this.getWidth(mibVar, mibNode, mibNode.getTCLabel());
            return new FieldPanel(width, mibNode.getLo(), this.getMaxSessionId(), (String)SnmpTableModel._Units.get(mibVar));
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected int getMaxSessionId() {
        if (DmId.isN5K(Discover.getSysObjectID()) && !Discover.isSysVersionlessThan((String)"4.0(1a)")) {
            return 18;
        }
        return this._mibNodes[0].getHi() == 0 ? -1 : this._mibNodes[0].getHi();
    }

    protected void setGroupButtonPanel(GroupButtonPanel rbp, MibEnum[] enums, SnmpVar val) {
        super.setGroupButtonPanel(rbp, enums, val);
        if (rbp == this._directionPanel) {
            for (int i = 0; i < rbp.getComponentCount(); ++i) {
                ((CheckBoxPanel)rbp).setSelected(i);
            }
        }
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this.IFINDEX) {
            int inRangeSignPos;
            super.getComponentValue(index);
            this._ifName = ((MdsPortChooser)this._values[index]).getText();
            if (DmId.isN5K(Discover.getSysObjectID())) {
                int[] ifIndeces;
                for (int ifIndex : ifIndeces = SnmpIntList.parse((String)this._ifName, (IfIndexIf)MibVariableFormat._IfIndexIf)) {
                    int type = Discover.getRoot().getType(ifIndex);
                    if (type != 2 && type != 26 && type != 31 && type != 28) continue;
                    throw new Exception("Invalid value : <" + Discover.getRoot().ifIndexToName(ifIndex) + ">");
                }
            }
            if ((inRangeSignPos = this._ifName.indexOf(44)) == -1) {
                inRangeSignPos = this._ifName.indexOf(45);
            }
            this._isMultipleInterfaces = inRangeSignPos != -1;
            return new SnmpInt(Discover.getRoot().nameToIfIndex(inRangeSignPos != -1 ? this._ifName.substring(0, inRangeSignPos) : this._ifName));
        }
        if (index == this.DIRECTION) {
            Object[] selected = ((CheckBoxPanel)this._values[index]).getSelectedValues();
            if (selected.length == 0) {
                throw new Exception(this._labels[index].getText() + " please make a selection");
            }
            this._direction = selected.length == 1 ? -1 : ((MibEnum)selected[1]).getValue();
            return new SnmpInt(((MibEnum)selected[0]).getValue());
        }
        return super.getComponentValue(index);
    }

    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        this._insertPDU = super.buildInsertPDU(index, values);
        return this._insertPDU;
    }

    protected void insert() throws Exception {
        super.insert();
        Array pduList = new Array();
        SnmpVarBind vb = this._insertPDU.getVariables().get(0);
        int[] oid = vb.getOid().getValue();
        int[] newOid = new int[oid.length];
        if (this._direction != -1) {
            System.arraycopy(oid, 0, newOid, 0, newOid.length);
            newOid[oid.length - 1] = this._direction;
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(newOid), vb.getVar());
            pduList.addElement((Object)pdu);
        }
        if (this._isMultipleInterfaces) {
            int[] ifIndeces = SnmpIntList.parse((String)this._ifName, (IfIndexIf)MibVariableFormat._IfIndexIf);
            for (int i = 1; i < ifIndeces.length; ++i) {
                newOid = new int[oid.length];
                System.arraycopy(oid, 0, newOid, 0, newOid.length);
                newOid[oid.length - 2] = ifIndeces[i];
                SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
                pdu.addVar(new SnmpOID(newOid), vb.getVar());
                pduList.addElement((Object)pdu);
                if (this._direction == -1) continue;
                oid = vb.getOid().getValue();
                newOid = new int[oid.length];
                System.arraycopy(oid, 0, newOid, 0, newOid.length);
                newOid[oid.length - 2] = ifIndeces[i];
                newOid[oid.length - 1] = this._direction;
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.addVar(new SnmpOID(newOid), vb.getVar());
                pduList.addElement((Object)pdu);
            }
        }
        for (int i = 0; i < pduList.size(); ++i) {
            this.getPeer().set((SnmpPDU)pduList.elementAt(i));
        }
        this.tableGet();
    }

    protected void build() {
        super.build();
        if (this.IFINDEX == 1) {
            ((FieldPanel)this._values[this.SESSIONID]).setText(Integer.toString(this.getIndex()[0]));
            this.setComponentVisibleAt(this.SESSIONID, false);
        }
    }

    public void dispose() {
        if (this._ports != null) {
            this._ports.dismiss();
        }
        super.dispose();
    }
}

