/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.span;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dmdb.andiamo.dialogs.span.InsertSPANFCSource;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;

public class InsertSPANSource
extends InsertSPANFCSource {
    static final int SESSIONID = 0;
    static final int SOURCE = 1;
    static final int VSAN = 3;
    static final int DIRECTION = 6;
    static final int[] _srcVsanCfg2kOid = MibNode.get((String)"cspanSourcesVsanCfgVsans2k").getOid();

    public InsertSPANSource(InsertDialog parent, EditTable table) {
        super(parent, table);
        this.IFINDEX = 5;
    }

    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 1) {
            return new JLabel("Source:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            RadioButtonPanel src = new RadioButtonPanel((Object[])new String[]{"Vsan", "Interface"});
            JToggleButton vsanBtn = src.getButton(0);
            vsanBtn.setSelected(true);
            ToggleListenerSource sourceListener = new ToggleListenerSource();
            for (int i = 0; i < src.getComponentCount(); ++i) {
                src.getButton(i).addActionListener(sourceListener);
            }
            return src;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void build() {
        super.build();
        int[] index = this.getLastIndex();
        ((FieldPanel)this._values[0]).setText(Integer.toString(index == null ? 1 : index[0] + 1));
        this.enableFCSource(false);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this.IFINDEX && this._values[index].isEnabled() && ((MdsPortChooser)this._values[index]).getText().equals("")) {
            throw new Exception("Interface cannot be blank");
        }
        return super.getComponentValue(index);
    }

    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        if (((SnmpInt)values[1]).getValue() == 3) {
            int[] newIndex = new int[]{index[0]};
            return newIndex;
        }
        int[] newIndex = new int[]{index[0], ((SnmpInt)values[this.IFINDEX]).getValue(), index[1]};
        return newIndex;
    }

    @Override
    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        Array pduList = new Array();
        pduList.addElement((Object)pdu);
        int pduSize = pdu.getVariables().size();
        for (int i = pduSize - 1; i >= 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            int[] oid = vb.getOid().getValue();
            if (!SnmpOID.startsWith((int[])oid, (int[])_srcVsanCfg2kOid)) continue;
            try {
                SnmpBitmap oldVsan2k = new SnmpBitmap(new byte[512]);
                SnmpBitmap newVsan2k = new SnmpBitmap(((SnmpString)vb.getVar()).toString());
                pdu.removeVarAt(i);
                PortInterfaceUtil.getInstance((int)5).addSpanVsanCfg2Pdu(pduList, oldVsan2k, newVsan2k, index);
                pdu.getVariables().remove(0);
                continue;
            }
            catch (Exception ex) {
                if (!SnmpSession.isTrace()) continue;
                ex.printStackTrace();
            }
        }
        if (pduList.size() > 1) {
            SnmpPDU sourcePdu = (SnmpPDU)pduList.elementAt(1);
            for (int i = 0; i < sourcePdu.getVariables().size(); ++i) {
                pdu.addVar(sourcePdu.getVariables().get(i));
            }
        }
        return pdu;
    }

    void enableFCSource(boolean isEnable) {
        this._labels[this.IFINDEX].setEnabled(isEnable);
        this._values[this.IFINDEX].setEnabled(isEnable);
        this._labels[6].setEnabled(isEnable);
        this._values[6].setEnabled(isEnable);
    }

    void enableVSAN(boolean isEnable) {
        this._labels[3].setEnabled(isEnable);
        this._values[3].setEnabled(isEnable);
    }

    class ToggleListenerSource
    implements ActionListener {
        ToggleListenerSource() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isVsan = e.getActionCommand().startsWith("Vsan");
            InsertSPANSource.this.enableVSAN(isVsan);
            InsertSPANSource.this.enableFCSource(!isVsan);
        }
    }
}

