/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.syslog;

import com.cisco.dcbu.lib.jnm.VshLog;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import java.awt.Color;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.table.TableCellRenderer;

public class SysLog
extends VshLog {
    static final String[] COLS = new String[]{"Switch Time", "Facility", "Severity", "Event", "VSAN Id", "Host Time", "Description"};
    static final String[] SEVERITY_LABELS = new String[]{"Emergency", "Alert", "Critical", "Error", "Warning", "Notice", "Info", "Debug"};
    static final int TIMESTAMP = 1;
    static final int FACILITY = 2;
    static final int SEVERITY = 3;
    static final int EVENT = 4;
    static final int VSAN = 5;
    static final int DESCRIPTION1 = 6;
    static final int DESCRIPTION2 = 5;
    static final int DESCRIPTION3 = 2;
    static final String SYSLOG_REGEX1 = "(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2}.?\\d*) +\\S+ +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+): +%\\$VSAN (.*)%\\$ (.*)";
    static final String SYSLOG_REGEX2 = "(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2}.?\\d*) +\\S+ +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+): (.*)";
    static final String SYSLOG_REGEX3 = "(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2}.?\\d*) +\\S+ +(.*)";
    static Pattern _Pattern1 = Pattern.compile("(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2}.?\\d*) +\\S+ +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+): +%\\$VSAN (.*)%\\$ (.*)");
    static Pattern _Pattern2 = Pattern.compile("(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2}.?\\d*) +\\S+ +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+): (.*)");
    static Pattern _Pattern3 = Pattern.compile("(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2}.?\\d*) +\\S+ +(.*)");

    public SysLog(JFrame parent, String cmd, SnmpPeer peer) throws IOException {
        this(parent, cmd, peer, peer + " - SysLog (Since Reboot)");
    }

    public SysLog(JFrame parent, String cmd, SnmpPeer peer, String title) throws IOException {
        super(parent, cmd, peer);
        this.setTitle(title);
    }

    public SysLog(JFrame parent, String title, String filename) {
        super(parent, title, filename);
    }

    protected int getTableWidth() {
        return 800;
    }

    protected void init() {
        super.init();
        this._table.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)((Object)new SeverityRenderer()));
    }

    protected String[] getHeaders() {
        return COLS;
    }

    protected String[] tokenize(String line) {
        String[] tokens = new String[COLS.length];
        if ((line = line.trim()).indexOf("%$VSAN") != -1) {
            Matcher m = _Pattern1.matcher(line);
            if (m.matches()) {
                tokens[0] = m.group(1);
                tokens[1] = m.group(2);
                tokens[2] = m.group(3);
                tokens[3] = m.group(4);
                String vsan = m.group(5);
                int pos = vsan.indexOf(58);
                if (pos > 0) {
                    tokens[4] = vsan.substring(0, pos);
                    tokens[5] = vsan.substring(pos + 1);
                } else {
                    tokens[4] = vsan;
                }
                tokens[6] = m.group(6);
            }
        } else {
            Matcher m = _Pattern2.matcher(line);
            if (m.matches()) {
                tokens[0] = m.group(1);
                tokens[1] = m.group(2);
                tokens[2] = m.group(3);
                tokens[3] = m.group(4);
                tokens[6] = m.group(5);
            } else {
                m = _Pattern3.matcher(line);
                if (m.matches()) {
                    tokens[0] = m.group(1);
                    tokens[6] = m.group(2);
                } else {
                    tokens[6] = line;
                }
            }
        }
        return tokens;
    }

    class SeverityRenderer
    extends BorderCellRenderer {
        SeverityRenderer() {
        }

        protected void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                try {
                    int severityLevel = Integer.parseInt(value.toString());
                    if (severityLevel <= 3) {
                        this.setBackground(Color.pink);
                    } else if (severityLevel == 4) {
                        this.setBackground(Color.yellow);
                    } else {
                        this.setBackground(SysLog.this._table.getBackground());
                    }
                    this.setText(SEVERITY_LABELS[severityLevel]);
                }
                catch (Exception ex) {
                    this.setText(value.toString());
                }
            }
        }
    }
}

