/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.syslog;

import com.cisco.dcbu.lib.jnm.VshLog;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class SysLogQuail
extends VshLog {
    static final String[] COLS = new String[]{"Id", "Switch Time", "Component", "Description"};
    static final int ID = 0;
    static final int TIMESTAMP = 1;
    static final int COMPONENT = 2;
    static final int DESCRIPTION = 3;
    static final int ID_FIELD = 0;
    static final int TIMESTAMP_FIELD = 1;
    static final int TYPE_FIELD = 2;
    static final int TYPEID_FIELD = 3;
    static final int COMPONENT_FIELD = 4;
    static final int DESCRIPTION_FIELD = 5;

    public SysLogQuail(JFrame parent, String cmd, SnmpPeer peer) throws IOException {
        this(parent, cmd, peer, peer + " - SysLog");
    }

    public SysLogQuail(JFrame parent, String cmd, SnmpPeer peer, String title) throws IOException {
        super(parent, cmd, peer);
        if (title == null) {
            title = "SysLog";
        }
        this.setTitle(peer + " - " + title);
    }

    public SysLogQuail(JFrame parent, String title, String filename) {
        super(parent, title, filename);
    }

    protected int getTableWidth() {
        return 700;
    }

    protected String[] getHeaders() {
        return COLS;
    }

    protected String[] tokenize(String line) {
        if (!(line = line.trim()).startsWith("[")) {
            return null;
        }
        String[] tokens = new String[COLS.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = null;
        }
        StringTokenizer st = new StringTokenizer(line, "][", false);
        int offset = 0;
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if (offset == 0) {
                tokens[0] = t;
            } else if (offset == 1) {
                tokens[1] = t;
            } else if (offset == 4) {
                tokens[2] = t;
                if (!st.hasMoreTokens()) {
                    tokens[2] = "";
                    tokens[3] = t;
                }
            } else if (offset == 5) {
                tokens[3] = t;
                if (t.startsWith("Port:") && st.hasMoreTokens()) {
                    String ifInterface = t.substring(5);
                    tokens[2] = tokens[2].concat(ifInterface);
                    tokens[3] = st.nextToken();
                    --offset;
                }
            }
            ++offset;
        }
        return tokens;
    }
}

