/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.elements.Card;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis_Sat_Abstract;
import com.cisco.dcbu.dmdb.andiamo.elements.Fan;
import com.cisco.dcbu.dmdb.andiamo.elements.Power;
import com.cisco.dcbu.dmdb.andiamo.elements.PowerSupply;
import com.cisco.dcbu.dmdb.andiamo.elements.PowerSupply_1;
import com.cisco.dcbu.dmdb.andiamo.elements.PowerSupply_XBOW;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPopupMenu;

public class Chassis
extends PhysicalElement
implements ActionListener {
    JPopupMenu _Menu;
    final Class[] _Children = new Class[]{Fan.class, PowerSupply.class, Card.class};
    static final int[][] _StatusVar = new int[][]{MibNode.get((String)"sysName").getOid()};
    static final int[] _entPhysicalVendorTypeOid = MibNode.get((String)"entPhysicalVendorType").getOid();
    static final int[] _CardLEDStatusOid = MibNode.get((String)"cefcModuleOperStatus").getOid();
    static final int[] _PowerLEDStatusOid = MibNode.get((String)"cefcFRUPowerOperStatus").getOid();
    protected int[][] _CardIndex;
    protected int[][] _UnSupportCardIndex;
    final int[][] _FanPos = new int[][]{{12, 65}};
    public int _CardOffset;
    public int _PowerSupplyOffset;
    public int _FanOffset;
    protected int[][] _PSIndex;
    protected Class[] _PSClass;
    protected Class[] _CardClass;
    protected int[] _CardType;
    public SnmpVar[] _cardStatus;
    public SnmpVar[] _psStatus;
    boolean _isFiconTotalChangeSupport = Discover.isSysVersionGreaterThanEqual((String)"4.2(0)");
    static final String SUP_LOCAL = "sup-local";
    static final String SUB_REMOTE = "sup-remote";
    static final int FLASH_DEVICE_NUMBER = 6;
    static final int FLASH_PARTITION_NUMBER = 2;
    static final int[][] _flashDevVar4G = new int[][]{MibNode.get((String)"ciscoFlashDeviceName").getOid()};
    static final int[][] _flashPartitionVar4G = new int[][]{MibNode.get((String)"ciscoFlashPartitionName").getOid(), MibNode.get((String)"ciscoFlashPartitionSizeExtended").getOid()};
    protected boolean _isFlashDeviceHotSwapNeed = false;
    protected HashMap<Integer, String> _DevicekeyHash = new HashMap();
    protected HashMap<String, HashMap<String, Long[]>> _FlashDevHash = new HashMap();
    ArrayList<SnmpVarBind> _FlashDevHotSwapVarBindList = new ArrayList();

    public Class[] getChildren() {
        return this._Children;
    }

    public Class[] getChildSubclass(Class child) throws Exception {
        if (child == PowerSupply.class || child == PowerSupply_XBOW.class) {
            return this._PSClass;
        }
        if (child == Fan.class) {
            return this.discoverCards();
        }
        if (child == Power.class) {
            return null;
        }
        return this._CardClass;
    }

    public int getNumberOfSlot() {
        return -1;
    }

    public int getNumberOfPowerSupplies() {
        return 2;
    }

    protected Class getPowerSupplyClass() {
        return PowerSupply_1.class;
    }

    protected String getCardClassPrefix() {
        return Card.class.getName();
    }

    protected Class getUnSupportedCardClass(int slotNum) {
        return Card.class;
    }

    protected Class[] discoverCards() throws Exception {
        return null;
    }

    protected Class[] discoverCards(int numCards) throws Exception {
        this._PSIndex = new int[this.getNumberOfPowerSupplies()][1];
        this._PSClass = new Class[this.getNumberOfPowerSupplies()];
        this._CardIndex = new int[numCards][1];
        this._UnSupportCardIndex = new int[numCards][1];
        this._CardClass = new Class[numCards];
        this._CardType = new int[numCards];
        int cardOffset = this.getCardOffset();
        int powerSupplyOffset = this.getPowerSupplyOffset();
        String className = this.getCardClassPrefix() + "_";
        SnmpPDU pdu = new SnmpPDU(-91, new VarBindList());
        pdu.setMaxRptr(this._CardClass.length);
        int[] vendorType = MibNode.get((String)"entPhysicalVendorType").getOid();
        pdu.addNull(new SnmpOID(vendorType, cardOffset));
        boolean foundCard = false;
        StringBuffer supervisor_not_found_msg = new StringBuffer("Unable to find any supported supervisor/modules, Please check:");
        supervisor_not_found_msg.append("\n1. That the supervisor model is supported.");
        supervisor_not_found_msg.append("\n2. Or that your user role permits hardware visibility.");
        supervisor_not_found_msg.append("\n3. Or that the switch has finished rebooting.");
        try {
            SnmpPDU resp = Discover.getPeer().send(pdu);
            if (resp.getVariables().size() == 0) {
                throw new SnmpException(supervisor_not_found_msg.toString());
            }
            for (int i = 0; i < resp.getVariables().size(); ++i) {
                SnmpVarBind vb = resp.getVariables().get(i);
                if (!vb.getOid().startsWith(vendorType) || vb.getVar().getType() != 6) continue;
                int[] oid = vb.getOid().getValue();
                int index = oid[oid.length - 1];
                int slot = index - (cardOffset + 1);
                if (slot >= this._CardClass.length) break;
                int[] vendorId = ((SnmpOID)vb.getVar()).getValue();
                int type = this.getCardType(vendorId);
                if (type != 0) {
                    foundCard = true;
                }
                try {
                    this._CardType[slot] = type;
                    this._CardClass[slot] = Class.forName(className + type);
                }
                catch (ClassNotFoundException ex) {
                    this._CardClass[slot] = this.getUnSupportedCardClass(slot);
                    this._UnSupportCardIndex[slot][0] = cardOffset + slot + 1;
                }
                this._CardIndex[slot][0] = cardOffset + slot + 1;
            }
        }
        catch (SnmpException ex) {
            if (this instanceof Chassis_Sat_Abstract) {
                Util.errorMessage((Component)DeviceManager.getInstance(), (String)(this.toString() + " " + FRUConstants.getMDSModelName((int)((Chassis_Sat_Abstract)this).getSatSwitchType()) + ": " + ex.getMessage()));
            }
            throw new Exception("discoverCards: " + (Object)((Object)ex));
        }
        if (!foundCard) {
            if (this instanceof Chassis_Sat_Abstract) {
                Util.errorMessage((Component)DeviceManager.getInstance(), (String)(this.toString() + " " + FRUConstants.getMDSModelName((int)((Chassis_Sat_Abstract)this).getSatSwitchType()) + ": " + supervisor_not_found_msg.toString()));
            }
            throw new SnmpException(supervisor_not_found_msg.toString());
        }
        pdu = new SnmpPDU(-91, new VarBindList());
        int powerSupplyRange = this.getNumberOfPowerSupplies();
        pdu.setMaxRptr(powerSupplyRange);
        pdu.addNull(new SnmpOID(vendorType, powerSupplyOffset - 1));
        try {
            SnmpPDU resp = Discover.getPeer().send(pdu);
            for (int i = 0; i < resp.getVariables().size(); ++i) {
                SnmpVarBind vb = resp.getVariables().get(i);
                if (!vb.getOid().startsWith(vendorType) || vb.getVar().getType() != 6) continue;
                int[] oid = vb.getOid().getValue();
                int index = oid[oid.length - 1];
                if (index <= powerSupplyOffset + powerSupplyRange - 1) {
                    this._PSIndex[index - powerSupplyOffset][0] = index;
                    this._PSClass[index - powerSupplyOffset] = this.getPowerSupplyClass();
                    continue;
                }
                break;
            }
        }
        catch (SnmpException ex) {
            DefaultLogger._DefLogger.debug((Object)("discoverPowerSupply: " + (Object)((Object)ex)));
        }
        this._CardOffset = cardOffset;
        this._PowerSupplyOffset = powerSupplyOffset;
        this._FanOffset = this.getFanOffset();
        this.discoverFlashDevices();
        return null;
    }

    protected void discoverFlashDevices() throws Exception {
        int i;
        SnmpPDU resp;
        this._FlashDevHash = new HashMap();
        this._DevicekeyHash = new HashMap();
        this._FlashDevHotSwapVarBindList = new ArrayList();
        VarBindList partitionVbl = new VarBindList();
        SnmpPDU pdu = new SnmpPDU(-91, new VarBindList());
        pdu.setMaxRptr(6);
        for (int i2 = 0; i2 < _flashDevVar4G.length; ++i2) {
            pdu.addNull(new SnmpOID(_flashDevVar4G[i2], 0));
        }
        try {
            resp = Discover.getPeer().send(pdu);
            for (i = 0; i < resp.getVariables().size(); i += _flashDevVar4G.length) {
                SnmpVarBind vb = resp.getVariables().get(i);
                String deviceName = resp.getVariables().stringValue(i);
                if (!deviceName.startsWith("slot0") && !deviceName.startsWith("usb")) continue;
                int[] oid = vb.getOid().getValue();
                int flashDevIndex = oid[oid.length - 1];
                this._DevicekeyHash.put(new Integer(flashDevIndex), deviceName);
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.debug((Object)("_DevicekeyHash + " + flashDevIndex + ',' + deviceName));
                }
                for (int k = 0; k < 2; ++k) {
                    for (int j = 0; j < _flashPartitionVar4G.length; ++j) {
                        partitionVbl.add(_flashPartitionVar4G[j], new int[]{flashDevIndex, k + 1});
                    }
                }
            }
        }
        catch (SnmpException ex) {
            // empty catch block
        }
        if (partitionVbl.size() > 0) {
            pdu = new SnmpPDU(-96, new VarBindList());
            pdu.setVariables(partitionVbl);
            try {
                resp = Discover.getPeer().send(pdu);
                for (i = 0; i < resp.getVariables().size(); i += _flashPartitionVar4G.length) {
                    int[] oid;
                    String deviceName;
                    SnmpVarBind vbl = resp.getVariables().get(i);
                    if (vbl.getVar().getType() == 5 || (deviceName = this._DevicekeyHash.get(new Integer((oid = vbl.getOid().getValue())[oid.length - 2]))) == null) continue;
                    String partitionName = resp.getVariables().stringValue(i);
                    long partitionSize = resp.getVariables().longValue(i + 1);
                    HashMap<String, Object> flashdevices = this._FlashDevHash.get(deviceName);
                    if (flashdevices == null) {
                        flashdevices = new HashMap();
                        this._FlashDevHash.put(deviceName, flashdevices);
                    }
                    int[] flashDevIndex = new int[]{oid[oid.length - 2], oid[oid.length - 1]};
                    flashdevices.put(partitionName, new Long[]{new Long(flashDevIndex[0]), new Long(flashDevIndex[1]), new Long(partitionSize)});
                    if (SnmpSession.isTrace()) {
                        DefaultLogger._DefLogger.debug((Object)("_FlashDevHash + " + deviceName + ",<" + partitionName + ",<" + flashDevIndex[0] + ',' + flashDevIndex[1] + ',' + partitionSize + ">>"));
                    }
                    this._FlashDevHotSwapVarBindList.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"ciscoFlashPartitionName").getOid(), flashDevIndex)));
                    if (!SnmpSession.isTrace()) continue;
                    DefaultLogger._DefLogger.debug((Object)("_FlashDevHotSwapVarBindList + ciscoFlashPartitionName." + flashDevIndex[0] + '.' + flashDevIndex[1]));
                }
            }
            catch (SnmpException snmpException) {
                // empty catch block
            }
        }
    }

    public int getCardOffset() {
        return FRUConstants.getCardOffset();
    }

    public int getPowerSupplyOffset() {
        return FRUConstants.getPowerSupplyOffset((boolean)Discover.isSysVersionGreaterThanEqual((String)"3.0(0)"));
    }

    public int getFanOffset() {
        return FRUConstants.getFanOffset((boolean)Discover.isSysVersionGreaterThanEqual((String)"3.0(0)"));
    }

    public int[] getChildIndex(Class child, int index) {
        if (child == PowerSupply.class || child == Power.class || child == PowerSupply_XBOW.class) {
            return this._PSIndex[index];
        }
        if (child == Fan.class) {
            return new int[]{this._FanOffset};
        }
        return this._CardIndex[index];
    }

    public void disable() {
    }

    public SnmpVarBind[] getStatusVar() {
        SnmpVarBind[] hotSwapVbs = this.buildStatusVar(null);
        if (hotSwapVbs == null) {
            return null;
        }
        SnmpVarBind[] vbs = new SnmpVarBind[hotSwapVbs.length + 1];
        vbs[0] = new SnmpVarBind(new SnmpOID(_StatusVar[0], 0));
        System.arraycopy(hotSwapVbs, 0, vbs, 1, hotSwapVbs.length);
        return vbs;
    }

    public SnmpVarBind[] buildStatusVar(int[][] oids) {
        if (oids != null) {
            return super.buildStatusVar(oids);
        }
        return this.buildHotSwapStatusVar();
    }

    protected SnmpVarBind[] buildHotSwapStatusVar() {
        return null;
    }

    protected SnmpVarBind[] buildHotSwapStatusVar(int numCards, int numPowerSupply) {
        int i;
        int ficonVars = this._isFiconTotalChangeSupport ? 2 : 1;
        int flashVars = this._isFlashDeviceHotSwapNeed ? 6 + this._FlashDevHotSwapVarBindList.size() : 0;
        SnmpVarBind[] vb = new SnmpVarBind[numCards * 2 + numPowerSupply + flashVars + ficonVars];
        int[] index = new int[1];
        index[0] = this._CardOffset + 1;
        for (i = 0; i < numCards * 2; i += 2) {
            vb[i] = new SnmpVarBind(new SnmpOID(_entPhysicalVendorTypeOid, index));
            vb[i + 1] = new SnmpVarBind(new SnmpOID(_CardLEDStatusOid, index));
            index[0] = index[0] + 1;
        }
        index[0] = this._PowerSupplyOffset;
        int j = 0;
        while (j < numPowerSupply) {
            vb[i] = new SnmpVarBind(new SnmpOID(_PowerLEDStatusOid, index));
            ++j;
            ++i;
            index[0] = index[0] + 1;
        }
        if (this._isFlashDeviceHotSwapNeed) {
            j = 0;
            while (j < 6) {
                vb[i] = new SnmpVarBind(new SnmpOID(MibNode.get((String)"ciscoFlashDeviceName").getOid(), j + 1));
                ++j;
                ++i;
            }
            j = 0;
            while (j < this._FlashDevHotSwapVarBindList.size()) {
                vb[i] = this._FlashDevHotSwapVarBindList.get(j);
                ++j;
                ++i;
            }
        }
        vb[vb.length - ficonVars] = new SnmpVarBind(new SnmpOID(MibNode.get((String)"cficonAutoSaveState").getOid(), 0));
        if (this._isFiconTotalChangeSupport) {
            vb[vb.length - 1] = new SnmpVarBind(new SnmpOID(MibNode.get((String)"cficonPortMapTotalChanges").getOid(), 0));
        }
        return vb;
    }

    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        Discover.getInstance();
        Discover.setSystemName((String)varBindList.get(offset++).getVar().toString());
        this.hotSwap(varBindList, offset, view);
    }

    protected void hotSwap(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
    }

    protected void hotSwap(VarBindList varBindList, int offset, PhysicalView view, int numCards, int numPowerSupply) throws RediscoverException {
        SnmpVar ficonTotalChangeV;
        SnmpVar autoSaveVar;
        SnmpVar v;
        int i;
        this._cardStatus = new SnmpVar[numCards];
        this._psStatus = new SnmpVar[numPowerSupply];
        for (i = 0; i < numCards; ++i) {
            v = varBindList.get(offset++).getVar();
            this._cardStatus[i] = varBindList.get(offset++).getVar();
            if (v.getType() == 6) {
                if (this._CardIndex[i][0] == 0) {
                    throw new RediscoverException(" Card inserted.");
                }
                int[] vendorId = ((SnmpOID)v).getValue();
                int type = this.getCardType(vendorId);
                if (type == this._CardType[i]) continue;
                throw new RediscoverException(" Card inserted.");
            }
            if (v.getType() != 5 || this._UnSupportCardIndex[i][0] == 0) continue;
            throw new RediscoverException(" Card removed.");
        }
        for (i = 0; i < numPowerSupply; ++i) {
            this._psStatus[i] = v = varBindList.get(offset++).getVar();
            if (v.getType() != 2 || this._PSIndex[i][0] != 0) continue;
            throw new RediscoverException(" PowerSupply inserted.");
        }
        if (this._isFlashDeviceHotSwapNeed) {
            int i2;
            String[] flashList = new String[7];
            Iterator<Integer> indeces = this._DevicekeyHash.keySet().iterator();
            for (String name : this._DevicekeyHash.values()) {
                int index = indeces.next();
                flashList[index] = name;
                if (!SnmpSession.isTrace()) continue;
                DefaultLogger._DefLogger.debug((Object)("hotswap flash, from _DevicekeyHash, flashList[" + index + "]=" + name));
            }
            for (i2 = 0; i2 < 6; ++i2) {
                SnmpVarBind vb;
                String v2;
                if (this.isSkipCheckingFlash(v2 = (vb = varBindList.get(offset++)).stringValue(), flashList[i2 + 1]) || !(flashList[i2 + 1] == null && vb.getVar().getType() != 5 || flashList[i2 + 1] != null && vb.getVar().getType() == 5) && (flashList[i2 + 1] == null || vb.getVar().getType() == 5 || v2.equals(flashList[i2 + 1]))) continue;
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.debug((Object)"Flash inserted/removed: mismatch for flash info in ciscoFlashDeviceTable");
                }
                throw new RediscoverException(" Flash inserted/removed.");
            }
            for (i2 = 0; i2 < this._FlashDevHotSwapVarBindList.size(); ++i2) {
                SnmpVarBind vb = varBindList.get(offset++);
                String partitionName = vb.stringValue();
                int[] oid = vb.getOid().getValue();
                int[] flashIndex = new int[]{oid[oid.length - 2], oid[oid.length - 1]};
                String deviceName = this._DevicekeyHash.get(new Integer(flashIndex[0]));
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.debug((Object)("hotswap flash, _DevicekeyHash get " + flashIndex[0] + '=' + deviceName));
                }
                if (deviceName == null) {
                    if (SnmpSession.isTrace()) {
                        DefaultLogger._DefLogger.debug((Object)("Flash inserted/removed: " + partitionName + '/' + flashIndex[0] + '/' + flashIndex[1] + " not found in DeviceKeyHash by index " + flashIndex[0]));
                    }
                    throw new RediscoverException(" Flash inserted/removed.");
                }
                HashMap<String, Long[]> flashPartitions = this._FlashDevHash.get(deviceName);
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.debug((Object)("hotswap flash, _FlashDevHash get " + deviceName + '=' + flashPartitions));
                }
                if (flashPartitions == null) {
                    DefaultLogger._DefLogger.info((Object)("Flash inserted/removed: " + partitionName + '/' + flashIndex[0] + '/' + flashIndex[1] + " not found in _FlashDevHash by " + deviceName));
                    throw new RediscoverException(" Flash inserted/removed.");
                }
                Long[] slotInfo = flashPartitions.get(partitionName);
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.debug((Object)("hotswap flash, _FlashDevHash get " + partitionName + '=' + slotInfo));
                }
                if (slotInfo == null) {
                    if (SnmpSession.isTrace()) {
                        DefaultLogger._DefLogger.debug((Object)("Flash inserted/removed: " + partitionName + '/' + flashIndex[0] + '/' + flashIndex[1] + " not found in _FlashDevHash by " + partitionName));
                    }
                    throw new RediscoverException(" Flash inserted/removed.");
                }
                if ((long)flashIndex[0] == slotInfo[0] && (long)flashIndex[1] == slotInfo[1]) continue;
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.debug((Object)("Flash inserted/removed: " + partitionName + '/' + flashIndex[0] + '/' + flashIndex[1] + " found in _FlashDevHash with " + slotInfo[0] + '/' + slotInfo[1]));
                }
                throw new RediscoverException(" Flash inserted/removed.");
            }
        }
        boolean isFiconEnable = (autoSaveVar = varBindList.get(offset).getVar()).getType() == 2;
        FiconPortByIfIndexCache.getInstance((SnmpPeer)Discover.getPeer()).setIsFiconEnabled(isFiconEnable, Discover.isSysVersionGreaterThanEqual((String)"3.0(0)"));
        DmSystem._AutoSave.enable(varBindList.intValue(offset) == 1);
        if (this._isFiconTotalChangeSupport && isFiconEnable && (ficonTotalChangeV = varBindList.get(++offset).getVar()) instanceof SnmpUnsignedInt) {
            long ficonTotalChange = ((SnmpUnsignedInt)ficonTotalChangeV).getValue();
            if (SnmpSession.isTrace()) {
                DefaultLogger._DefLogger.debug((Object)("new/old " + ficonTotalChange + "/" + DmSystem._AutoSave.getFiconPortMapChange()));
            }
            if (ficonTotalChange != DmSystem._AutoSave.getFiconPortMapChange() && DmSystem._AutoSave.getFiconPortMapChange() != 0L) {
                FiconPortByIfIndexCache.getInstance((SnmpPeer)Discover.getPeer()).init(Discover.isSysVersionGreaterThanEqual((String)"3.0(0)"));
            }
            DmSystem._AutoSave.setFiconPortMapChange(ficonTotalChange);
        }
    }

    public int[] getCardTypes() {
        return this._CardType;
    }

    public int[][] getPowerSupplyIndeces() {
        return this._PSIndex;
    }

    protected int getCardType(int[] vendorId) {
        int type = FRUConstants.getModuleType((int[])vendorId);
        if (type == 255) {
            return 0;
        }
        if (type == 2) {
            return 1;
        }
        return type;
    }

    public JPopupMenu getMenu() {
        if (this._Menu == null) {
            this._Menu = this.buildMenu(this);
            this._Menu.addSeparator();
            this._Menu.add(Util.createMenuItem((String)"Reset", (String)"deviceAction resetSwitch", (ActionListener)DeviceManager.getInstance()._listener));
        }
        return this._Menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getView().dialogAction(this.getEditDialog(), (PhysicalElement)this);
    }

    public String getEditDialog() {
        return "System";
    }

    public String toString() {
        return "System";
    }

    private boolean isSkipCheckingFlash(String newValue, String oldValue) {
        return !(newValue.startsWith("slot0") || newValue.startsWith("usb") || oldValue != null && oldValue.startsWith("slot0") || oldValue != null && oldValue.startsWith("usb"));
    }
}

