/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.elements.Card;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis;
import com.cisco.dcbu.dmdb.andiamo.elements.MgmtPort;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.dmdb.andiamo.elements.Port_Inagua;
import com.cisco.dcbu.dmdb.andiamo.elements.SystemStatusLED;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;

public class Chassis_1_Inagua
extends Chassis
implements ActionListener {
    final Class[] _Children = new Class[]{Card.class, SystemStatusLED.class, MgmtPort.class, Port_Inagua.class};
    private static final int[][] STATUS_VAR = new int[][]{MibNode.get((String)"entPhysicalSoftwareRev").getOid()};
    private static final int[][] STATUS_VAR_PORT = new int[][]{MibNode.get((String)"cieInterfacesIndex").getOid(), MibNode.get((String)"cieInterfacesOperMode").getOid(), MibNode.get((String)"cieInterfacesOperCause").getOid()};
    private final int[][] _systemLEDPos = new int[][]{{9, 30}};
    private final int[][] _mgmtPortPos = new int[][]{{7, 39}};
    private final int[][] _cardPos = new int[][]{{3, 3}};
    private final int LO_X = 16;
    private final int LO_Y = 160;
    private final int[][] PORT_POS = new int[][]{{16, 58}, {71, 160}, {102, 160}, {132, 160}, {160, 160}, {193, 160}, {220, 160}, {252, 160}, {281, 160}, {310, 160}, {343, 160}, {374, 160}, {406, 160}, {434, 160}, {465, 160}, {16, 76}, {16, 95}, {16, 114}, {16, 133}, {16, 152}};
    int _numCardVars;
    private String _version;

    public boolean isTChassis() {
        return false;
    }

    public int[][] getChildPos(Class child) {
        if (child == SystemStatusLED.class) {
            return this._systemLEDPos;
        }
        if (child == MgmtPort.class) {
            return this._mgmtPortPos;
        }
        if (child == Card.class) {
            return this._cardPos;
        }
        return this.PORT_POS;
    }

    @Override
    public Class[] getChildren() {
        return this._Children;
    }

    @Override
    public Class[] getChildSubclass(Class child) throws Exception {
        if (child == Card.class) {
            this.discoverCards(1);
            return this._CardClass;
        }
        return null;
    }

    @Override
    public int[] getChildIndex(Class child, int index) {
        if (child == SystemStatusLED.class) {
            if (Discover.isSysVersionGreaterThanEqual((String)"2.1(2b)")) {
                return new int[]{22, 2};
            }
            return new int[]{0};
        }
        if (child == Port_Inagua.class) {
            int[] ifIndex = new int[]{IfIndexUtil.getInaguaPortIfIndex((int)index)};
            return ifIndex;
        }
        if (child == MgmtPort.class) {
            int[] ifIndex = new int[1];
            try {
                ifIndex[0] = Discover.getRoot().nameToIfIndex("mgmt" + Integer.toString(index));
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            return ifIndex;
        }
        return super.getChildIndex(child, index);
    }

    @Override
    public SnmpVarBind[] getStatusVar() {
        if (Card._isSupportPortStatusPerModuleFeature) {
            SnmpVarBind[] supVar = this.buildStatusVar(STATUS_VAR);
            SnmpVarBind[] cardVars = this.getPortStatusVar(STATUS_VAR_PORT);
            SnmpVarBind[] vb = new SnmpVarBind[supVar.length + cardVars.length];
            System.arraycopy(cardVars, 0, vb, 0, cardVars.length);
            System.arraycopy(supVar, 0, vb, cardVars.length, supVar.length);
            this._numCardVars = cardVars.length;
            return vb;
        }
        return this.buildStatusVar(STATUS_VAR);
    }

    private SnmpVarBind[] getPortStatusVar(int[][] oids) {
        SnmpVarBind[] vb = new SnmpVarBind[oids.length];
        for (int i = 0; i < vb.length; ++i) {
            vb[i] = new SnmpVarBind(new SnmpOID(oids[i], new int[]{22, 1}));
        }
        return vb;
    }

    public int[] getStatusVarIndex(int[] index) {
        int[] cardIndex = new int[]{22};
        return cardIndex;
    }

    @Override
    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        int verStringoffset;
        String version;
        if (Card._isSupportPortStatusPerModuleFeature) {
            this.setPortStatus(varBindList, offset, view);
        }
        if (Discover.setSysVersionFrmSup((String)(version = varBindList.get(offset += this._numCardVars).getVar().toString()))) {
            return;
        }
        if (this._version != null && version.equals(this._version)) {
            return;
        }
        Graphics g = view.getOffscreenImage().getGraphics();
        g.setFont(Port._ModeFont);
        Rectangle r = this.getRect();
        int n = verStringoffset = this.isTChassis() ? 7 : 0;
        if (this._version != null) {
            g.setColor(new Color(66, 66, 66));
            g.drawString(this._version, r.x + r.width - 23, r.y + r.height - 42);
        }
        g.setColor(Color.white);
        g.drawString(version, r.x + r.width - 4 * version.length() - 10 + verStringoffset, r.y + r.height - 24 + verStringoffset);
        g.dispose();
        this._version = version;
    }

    public void setPortStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        byte[] b = varBindList.byteValue(offset);
        byte[] operModeList = varBindList.byteValue(offset + 1);
        byte[] operCauseList = varBindList.byteValue(offset + 2);
        int i = 0;
        int j = 0;
        if (b.length == 0 || operModeList.length == 0 || operCauseList.length == 0) {
            this.disable();
            return;
        }
        boolean port = false;
        for (int k = 0; (i < b.length || j < operModeList.length || k < operCauseList.length) && i <= b.length - 4 && j <= operModeList.length - 1 && k <= operCauseList.length - 2; i += 4, ++j, k += 2) {
            int ifIndex = ((b[i + 3] & 0xFF) << 24) + ((b[i + 2] & 0xFF) << 16) + ((b[i + 1] & 0xFF) << 8) + (b[i] & 0xFF);
            PhysicalElement e = view.find(Port.class, ifIndex);
            if (e != null && e instanceof Port_Inagua) {
                int operMode = operModeList[j] & 0xFF;
                int operCause = ((operCauseList[k + 1] & 0xFF) << 8) + (operCauseList[k] & 0xFF);
                ((Port_Inagua)e).resetStatus();
                ((Port_Inagua)e).setStatus(operMode, operCause, view);
                continue;
            }
            e = view.find(AbstractPort.class, ifIndex);
            if (e != null) continue;
            DefaultLogger._DefLogger.debug((Object)("setStatus port not found : " + ifIndex));
        }
    }

    @Override
    public int getNumberOfSlot() {
        return 1;
    }

    public String getBitmap() {
        return "inagua.gif";
    }
}

