/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.elements.AbstractEthPort;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class IPSEthPort
extends AbstractEthPort {
    private static final int[][] STATUS_VAR = new int[][]{MibNode.get((String)"ifOperStatus").getOid(), MibNode.get((String)"ifOperStatus").getOid(), MibNode.get((String)"ifConnectorPresent").getOid()};
    public static final int ISCSI_UP = 1;

    @Override
    public SnmpVarBind[] getStatusVar() {
        SnmpVarBind[] vbList = super.buildStatusVar(STATUS_VAR);
        SnmpVarBind iscsiVb = vbList[1];
        int[] iscsiIfIndex = new int[]{this.getStatusVarIndex(this._index)[0] & 0x1FFFFFF};
        iscsiIfIndex[0] = iscsiIfIndex[0] + 0xB000000;
        iscsiVb.setOid(new SnmpOID(STATUS_VAR[1], iscsiIfIndex));
        return vbList;
    }

    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        if (!(varBindList.get(offset).getVar() instanceof SnmpInt)) {
            this.setPortNotPresent(view);
            return;
        }
        this._status = varBindList.intValue(offset);
        this._connectorPresent = varBindList.get(offset + 2).getVar();
        this._iscsiOper = varBindList.intValue(offset + 1);
        this.setStatus(this._status, this._connectorPresent, this._iscsiOper, view);
    }

    @Override
    public void redrawStatus(PhysicalView view) {
        this.setStatus(this._status, this._connectorPresent, this._iscsiOper, view);
    }

    public void setStatus(int oper, SnmpVar connectorPresent, int iscsiOper, PhysicalView view) {
        this._status = oper;
        this._connectorPresent = connectorPresent;
        this._iscsiOper = iscsiOper;
        try {
            boolean isConnectorPresent = true;
            if (connectorPresent instanceof SnmpInt) {
                boolean bl = isConnectorPresent = ((SnmpInt)connectorPresent).getValue() == 1;
            }
            if (!isConnectorPresent) {
                this.setPortNotPresent(view);
            } else {
                this.setStatus(oper, view);
            }
            Graphics g = view.getOffscreenImage().getGraphics();
            boolean bl = this._isIscsi = iscsiOper == 1;
            if (!this._hide && iscsiOper != -1) {
                if (this._isIscsi) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(new Color(66, 66, 66));
                }
                g.setFont(Port._ModeFont);
                Rectangle r = this.getRect();
                g.drawString("I", r.x + ("I".length() > 1 ? 2 : 7), r.y + 11);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this._hide) {
            view.updateImage(this._image, this._rect.x, this._rect.y, DmSystem._bg);
        }
    }

    @Override
    public int[] getStatusIndex(int[] index) {
        int[] ifIndex = new int[1];
        int card = index[0] - 21;
        ifIndex[0] = 0x2000000 + (card - 1 << 19) + (index[1] - 1 << 12);
        return ifIndex;
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
        this._toolTipText = null;
    }

    @Override
    public String getEditDialog() {
        return "Ethernet_Interfaces_and_iSCSI";
    }

    @Override
    public String getGraphDialog() {
        return "Ethernet_Interface_Monitor";
    }

    @Override
    public JPopupMenu getMenu() {
        if (_Menu == null) {
            _Menu = super.buildMenu();
            if (Discover.isSysVersionGreaterThanEqual((String)"3.0(0)") && !DmId.isN5K(Discover.getSysObjectID())) {
                _Menu.addSeparator();
                JMenu beacon = new JMenu("Beacon");
                _Menu.add(beacon);
                this.addMenu(beacon, new String[][]{{"On", "beaconOnAction"}, {"Off", "beaconOffAction"}});
            }
        }
        return _Menu;
    }

    @Override
    public String toString() {
        return Discover.getRoot().ifIndexToName(this.getIndex()[0]);
    }
}

