/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.CallbackRejectHandler;
import com.cisco.dcbu.lib.snmp.CallbackRunnable;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class CallbackHandler {
    private LinkedBlockingQueue<Runnable> _handoffQ = new LinkedBlockingQueue();
    private ThreadPoolExecutor _pool = new ThreadPoolExecutor(3, 20, 30L, TimeUnit.SECONDS, this._handoffQ, new CallbackRejectHandler());
    private int _maxQsize;
    private static CallbackHandler me;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CallbackHandler getInstance() {
        Class<CallbackHandler> clazz = CallbackHandler.class;
        synchronized (CallbackHandler.class) {
            if (me == null) {
                me = new CallbackHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return me;
        }
    }

    private CallbackHandler() {
    }

    public void add(SnmpPDU pdu) {
        this._pool.execute(new CallbackRunnable(pdu));
        if (this._handoffQ.size() > this._maxQsize) {
            this._maxQsize = this._handoffQ.size();
        }
    }

    public void finish() {
        this._pool.shutdownNow();
    }

    public String toString() {
        return "CallbackHandler\n\tNo. of completed callbacks: " + this._pool.getCompletedTaskCount() + "\n\tMax threads: " + this._pool.getLargestPoolSize() + "\n\tMax queue size: " + this._maxQsize;
    }
}

