/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.SnmpException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;

public final class SnmpCrypto {
    public static final int NOT_SET = -1;
    public static final int MD5_PROTOCOL = 0;
    public static final int SHA1_PROTOCOL = 1;
    public static final int DES_PROTOCOL = 0;
    public static final int AES_PROTOCOL = 1;
    private static final int ONEMEG = 0x100000;
    private static final int DES_SALT_LENGTH = 8;
    private static final int AES_SALT_LENGTH = 16;
    static final int AUTH_PARAMS_LENGTH = 12;
    private static int _SaltCount = -1;
    private static long _AesSaltCount = -1L;
    static final byte[] _EmptyAuth = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private SnmpCrypto() {
    }

    private static MessageDigest getDigest(int protocol) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(SnmpCrypto.getDigestName(protocol));
        }
        catch (NoSuchAlgorithmException ex) {
            LogManager.getLogger((String)"snmp").log((Priority)Level.ERROR, (Object)"SnmpCrypto::getDigest() error", (Throwable)ex);
        }
        return md;
    }

    public static String getDigestName(int protocol) {
        return protocol == 0 ? "MD5" : "SHA-1";
    }

    public static String getEmcryptName(int protocol) {
        return protocol == 0 ? "DES" : "AES";
    }

    public static byte[] getKeyChange(byte[] oldPasswd, byte[] newPasswd, byte[] engineId, int protocol) {
        byte[] oldKey = SnmpCrypto.getLocalizedKey(oldPasswd, engineId, protocol);
        byte[] newKey = SnmpCrypto.getLocalizedKey(newPasswd, engineId, protocol);
        MessageDigest md = SnmpCrypto.getDigest(protocol);
        byte[] random = new byte[md.getDigestLength()];
        md.update(oldKey);
        md.update(random);
        byte[] digest = md.digest();
        byte[] keyChange = new byte[random.length + newKey.length];
        System.arraycopy(random, 0, keyChange, 0, random.length);
        System.arraycopy(newKey, 0, keyChange, random.length, newKey.length);
        for (int i = oldKey.length; i < keyChange.length; ++i) {
            int n = i;
            keyChange[n] = (byte)(keyChange[n] ^ digest[i - oldKey.length]);
        }
        return keyChange;
    }

    public static byte[] getKeyChange(String oldPasswd, String newPasswd, byte[] engineId, int protocol) {
        return SnmpCrypto.getKeyChange(SnmpCrypto.passwordToKey(oldPasswd, protocol), SnmpCrypto.passwordToKey(newPasswd, protocol), engineId, protocol);
    }

    public static byte[] getLocalizedKey(byte[] passwKey, byte[] engineId, int protocol) {
        MessageDigest md = SnmpCrypto.getDigest(protocol);
        md.update(passwKey);
        md.update(engineId);
        md.update(passwKey);
        return md.digest();
    }

    public static byte[] passwordToKey(String passwordString, int protocol) {
        int i;
        MessageDigest md = SnmpCrypto.getDigest(protocol);
        byte[] buf = new byte[64];
        int password_index = 0;
        int count = 0;
        int len = passwordString.length();
        if (len < 8) {
            len = 8;
        }
        byte[] password = new byte[len];
        for (i = 0; i < passwordString.length(); ++i) {
            password[i] = (byte)(0xFF & passwordString.charAt(i));
        }
        if (passwordString.length() < len) {
            for (i = passwordString.length(); i < len; ++i) {
                password[i] = 32;
            }
        }
        while (count < 0x100000) {
            for (i = 0; i < 64; ++i) {
                buf[i] = password[password_index++ % password.length];
            }
            md.update(buf);
            count += 64;
        }
        return md.digest();
    }

    public static void calcLocalizedKeys(byte[] key, byte[] k1, byte[] k2) {
        int i;
        int z1 = 54;
        int z2 = 92;
        int kl = key.length;
        for (i = 0; i < kl; ++i) {
            k1[i] = (byte)(SnmpCrypto.ifb(key[i]) ^ 0x36);
            k2[i] = (byte)(SnmpCrypto.ifb(key[i]) ^ 0x5C);
        }
        while (i < 64) {
            k1[i] = z1;
            k2[i] = z2;
            ++i;
        }
    }

    private static int ifb(byte b) {
        int ret = 0x7F & b;
        if (b < 0) {
            ret += 128;
        }
        return ret;
    }

    static byte[] getFingerPrint(byte[] k1, byte[] k2, byte[] message, int msgLen, int protocol) {
        MessageDigest mdc = SnmpCrypto.getDigest(protocol);
        mdc.update(k1);
        mdc.update(message, 0, msgLen);
        byte[] interm = mdc.digest();
        mdc.update(k2);
        mdc.update(interm);
        return mdc.digest();
    }

    static byte[] getDesSalt(int snmpEngineBoots) {
        if (_SaltCount == -1) {
            Random rand = new Random();
            _SaltCount = rand.nextInt();
        }
        byte[] salt = new byte[8];
        SnmpCrypto.setBytesFromInt(salt, snmpEngineBoots, 0);
        SnmpCrypto.setBytesFromInt(salt, _SaltCount, 4);
        ++_SaltCount;
        return salt;
    }

    static byte[] getAesSalt(int snmpEngineBoots, int snmpEngineTime) {
        if (_AesSaltCount == -1L) {
            Random rand = new Random();
            _AesSaltCount = rand.nextLong();
        }
        byte[] salt = new byte[16];
        SnmpCrypto.setBytesFromInt(salt, snmpEngineBoots, 0);
        SnmpCrypto.setBytesFromInt(salt, snmpEngineTime, 4);
        int i = 8;
        int bits = 56;
        while (i < 16) {
            salt[i++] = (byte)(_AesSaltCount >>> bits & 0xFFL);
            ++i;
            bits -= 8;
        }
        ++_AesSaltCount;
        return salt;
    }

    private static byte[] getInitialValue(byte[] secretPrivacyKey, byte[] salt) throws SnmpException {
        if (secretPrivacyKey.length < 16) {
            throw new SnmpException("getInitialValue(): secretPrivacyKey < 16");
        }
        byte[] initV = new byte[8];
        int spk = 8;
        for (int i = 0; i < initV.length; ++i) {
            initV[i] = (byte)(secretPrivacyKey[spk] ^ salt[i]);
            ++spk;
        }
        return initV;
    }

    static byte[] encrypt(byte[] plain, int offset, int len, byte[] secretPrivacyKey, byte[] salt, int protocol) throws SnmpException {
        try {
            if (protocol == 1) {
                Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding");
                SecretKeySpec keySpec = new SecretKeySpec(secretPrivacyKey, 0, 16, "AES");
                cipher.init(1, (Key)keySpec, new IvParameterSpec(salt));
                return cipher.doFinal(plain, offset, len);
            }
            SecretKeySpec keySpec = new SecretKeySpec(secretPrivacyKey, 0, 8, "DES");
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            cipher.init(1, (Key)keySpec, new IvParameterSpec(SnmpCrypto.getInitialValue(secretPrivacyKey, salt)));
            return cipher.doFinal(plain, offset, len);
        }
        catch (Exception ex) {
            throw new SnmpException(ex.getMessage());
        }
    }

    static byte[] decrypt(byte[] encryptedText, int offset, int len, int engineBoots, int engineTime, byte[] salt, byte[] secretPrivacyKey, int protocol) throws SnmpException {
        try {
            if (protocol == 1) {
                Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding");
                SecretKeySpec keySpec = new SecretKeySpec(secretPrivacyKey, 0, 16, "AES");
                byte[] aesSalt = new byte[16];
                SnmpCrypto.setBytesFromInt(aesSalt, engineBoots, 0);
                SnmpCrypto.setBytesFromInt(aesSalt, engineTime, 4);
                System.arraycopy(salt, 0, aesSalt, 8, 8);
                cipher.init(2, (Key)keySpec, new IvParameterSpec(aesSalt));
                return cipher.doFinal(encryptedText, offset, len);
            }
            SecretKeySpec keySpec = new SecretKeySpec(secretPrivacyKey, 0, 8, "DES");
            Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
            cipher.init(2, (Key)keySpec, new IvParameterSpec(SnmpCrypto.getInitialValue(secretPrivacyKey, salt)));
            return cipher.doFinal(encryptedText, offset, len);
        }
        catch (Exception ex) {
            throw new SnmpException(ex.getMessage());
        }
    }

    private static void setBytesFromInt(byte[] ret, int value, int offs) {
        int v = value;
        int j = offs;
        ret[j++] = (byte)(v >>> 24 & 0xFF);
        ret[j++] = (byte)(v >>> 16 & 0xFF);
        ret[j++] = (byte)(v >>> 8 & 0xFF);
        ret[j++] = (byte)(v >>> 0 & 0xFF);
    }
}

