/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.CallbackHandler;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SessionListener;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpReportException;
import com.cisco.dcbu.lib.snmp.SnmpTimeout;
import com.cisco.dcbu.lib.snmp.SnmpVarBindException;
import com.cisco.dcbu.lib.snmp.VshManager;
import com.cisco.dcbu.lib.snmp.transport.AbstractIpTransportOptions;
import com.cisco.dcbu.lib.snmp.transport.SnmpTransportProviderIf;
import com.cisco.dcbu.lib.snmp.transport.TcpTransportOptions;
import com.cisco.dcbu.lib.snmp.transport.TcpTransportProvider;
import com.cisco.dcbu.lib.snmp.transport.TransportCallbackIf;
import com.cisco.dcbu.lib.snmp.transport.TransportOptionsIf;
import com.cisco.dcbu.lib.snmp.transport.UdpTransportOptions;
import com.cisco.dcbu.lib.snmp.transport.UdpTransportProvider;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.NetUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SnmpSession
extends Thread
implements TransportCallbackIf {
    public static final int PORT = 161;
    public static final int MAX_LEN = 484;
    public static final int _MaxQueueSize = Integer.getInteger("snmp.qsize", 128);
    public static final int[] _SysObjectIDOid = new int[]{1, 3, 6, 1, 2, 1, 1, 1};
    public static boolean _TcpSessionOpened = false;
    public int _receiver_pri_inc;
    public int _sender_pri_inc;
    private boolean _initd = false;
    private static final int BUF_SIZE = 6192;
    static final int RESP_BUF_SIZE = 6000;
    private static int _SessionNo;
    private static int _ReqId;
    public static byte[] _MyEngineId;
    public static boolean _PreferTcp;
    static final String PROP_SNMP_LOCALPORT = "snmp.localport";
    Integer _Localport = null;
    private static volatile SnmpSession _TcpSession;
    private static volatile SnmpSession _UdpSession;
    private boolean _closeSession;
    private String _transportName;
    private TransportOptionsIf _transOptions;
    private SnmpTransportProviderIf _transProvider;
    private Object _lockForTransport = new Object();
    private int _remotePort = 161;
    private transient String _localVPNAddr;
    private transient InetAddress _localHost;
    private Properties _configuration;
    private int _nRequests;
    private int _nResponses;
    private int _nResends;
    private int _nTimeouts;
    private long _responseLen;
    private int _nMaxResponseLen;
    private long _requestLen;
    private int _nMaxOutstanding;
    private int _nMaxHandoff;
    private long _nMaxQueueTime;
    Logger _log = LogManager.getLogger((String)"snmp");
    public static final int Reset_Never = 0;
    public static final int Reset_Once = 1;
    public static final int Reset_Daily = 2;
    public static final int Reset_Weekly = 3;
    public static final long DailyPeriod = 86400000L;
    public static final long WeeklyPeriod = 604800000L;
    public static final int _ResetExecuteHour;
    public static final int _ResetPeriod;
    private final int ResetMaxWaitTime = 1000;
    private final ReentrantLock _resetLock = new ReentrantLock();
    private final AtomicLong _lastResetTime = new AtomicLong();
    private final CopyOnWriteArrayList<SessionListener> _sessionListeners = new CopyOnWriteArrayList();
    private volatile boolean _demandReset = false;
    private ResetTimer _resetTimer = null;

    private SnmpSession(String name, String t) {
        super(name + "_" + t);
        this._log = LogManager.getLogger((String)("snmp." + t));
        this._transportName = t;
        this._receiver_pri_inc = Integer.getInteger("snmp.rcvThreadPriInc", 1);
        this._sender_pri_inc = Integer.getInteger("snmp.sndThreadPriInc", 1);
        this._Localport = Integer.getInteger(PROP_SNMP_LOCALPORT);
        this.setPriority(this.getPriority() + this._receiver_pri_inc);
        ++_SessionNo;
        this._configuration = new Properties();
        try {
            String propFile;
            File handle;
            String tranProp = "com/cisco/dcbu/lib/snmp/SnmpTransport.properties";
            InputStream is = this.getContextClassLoader().getResourceAsStream(tranProp);
            if (is == null && (handle = new File(propFile = ClientCache.getDir() + File.separator + "SnmpTransport.properties")).exists()) {
                is = new FileInputStream(handle);
            }
            this._configuration.load(is);
        }
        catch (IOException ioe) {
            this._log.error((Object)("loading transport properties error: " + ioe));
        }
        if (_ResetPeriod != 0) {
            String standAlone = System.getProperty("fm.standalone");
            if (standAlone != null && Boolean.parseBoolean(standAlone)) {
                this._log.info((Object)(this + " skip reset session scheduler for standalone"));
            } else {
                this._resetTimer = new ResetTimer(_ResetExecuteHour, _ResetPeriod);
                this._log.info((Object)(this + " reset session scheduler started, execute time at hour of day:" + this._resetTimer.getExecuteHour() + ", reset peroid(ms):" + this._resetTimer.getPeriod()));
            }
        }
        this._lastResetTime.set(System.currentTimeMillis());
    }

    public static SnmpSession getInstance() {
        return SnmpSession.getInstance(_PreferTcp ? "tcp" : "udp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SnmpSession getInstance(String t) {
        if ("tcp".equals(t)) {
            if (_TcpSession != null) return _TcpSession;
            Class<SnmpSession> clazz = SnmpSession.class;
            synchronized (SnmpSession.class) {
                if (_TcpSession != null) return _TcpSession;
                _TcpSession = new SnmpSession("SnmpSession_" + _SessionNo, "tcp");
                _TcpSession.start();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return _TcpSession;
            }
        }
        if (_UdpSession != null) return _UdpSession;
        Class<SnmpSession> clazz = SnmpSession.class;
        synchronized (SnmpSession.class) {
            if (_UdpSession != null) return _UdpSession;
            _UdpSession = new SnmpSession("SnmpSession_" + _SessionNo, "udp");
            _UdpSession.start();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return _UdpSession;
        }
    }

    public static boolean supportIPv6() {
        if (_UdpSession != null && SnmpSession._UdpSession._transProvider != null) {
            return ((UdpTransportProvider)SnmpSession._UdpSession._transProvider).supportIPv6();
        }
        return false;
    }

    public final String getTransportProvider() {
        return this._transportName;
    }

    public final SnmpTransportProviderIf getTransportProviderObject() {
        return this._transProvider;
    }

    public final TransportOptionsIf getTransportOptions() {
        return this._transOptions;
    }

    public final InetAddress getLocalInetAddress() {
        return this._transProvider != null ? this._transProvider.getLocalAddress() : null;
    }

    public final String getLocalHostAddress() {
        return this._transProvider != null ? NetUtil.getHostAddress(this._transProvider.getLocalAddress()) : null;
    }

    public final int getLocalPort() {
        return this._transOptions instanceof AbstractIpTransportOptions ? ((AbstractIpTransportOptions)this._transOptions).getLocalPort() : 0;
    }

    public final int getRemotePort() {
        return this._remotePort;
    }

    public final void setRemotePort(int remotePort) {
        this._remotePort = remotePort;
    }

    public final InetAddress getSnmpSourceAddress() {
        return this._transProvider.getSnmpSourceAddress();
    }

    public final String getSnmpSourceAddress(InetAddress host) {
        return this._transProvider.getSnmpSourceAddress(host);
    }

    public void setLocalVPNAddress(String vpnAddr) {
        this._localVPNAddr = vpnAddr;
    }

    public String getLocalVPNAddress() {
        return this._localVPNAddr;
    }

    public void setLocalHost(String host) {
        try {
            this._localHost = InetAddress.getByName(host);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public InetAddress getLocalHost() {
        return this._localHost;
    }

    public Logger getLogger() {
        return this._log;
    }

    public void setLogger(Logger log) {
        this._log = log;
    }

    public void setPduUserName(String username) {
        if (this._transProvider != null) {
            this._transProvider.setPduUserName(username);
        }
    }

    public final synchronized int genReqId() {
        int next;
        if ((next = ++_ReqId) <= 0) {
            _ReqId = 100;
        }
        return _ReqId;
    }

    @Override
    public String toString() {
        return this.getName() + ": " + this._transProvider;
    }

    public void open(String transportName, TransportOptionsIf opt) throws IOException {
        if (!this._initd) {
            this.initTransportProvider(transportName, opt);
            this._initd = true;
        }
        if (!this.isAlive() && !this._initd) {
            this.start();
        }
    }

    public void open(InetAddress localAddr, int localPort) throws IOException {
        if (_PreferTcp) {
            this.open("tcp", new TcpTransportOptions(null, 161, this._Localport == null ? 0 : this._Localport));
        } else {
            UdpTransportOptions opt = new UdpTransportOptions(localAddr != null ? NetUtil.getHostAddress(localAddr) : null, localPort);
            this.open("udp", opt);
        }
    }

    public void open(InetAddress localAddr, int localPort, String tranportProtocol) throws IOException {
        if (tranportProtocol.equalsIgnoreCase("tcp")) {
            this.open("tcp", new TcpTransportOptions(null, 161, this._Localport == null ? 0 : this._Localport));
        } else {
            UdpTransportOptions opt = new UdpTransportOptions(localAddr != null ? NetUtil.getHostAddress(localAddr) : null, localPort);
            this.open("udp", opt);
        }
    }

    public void open() throws IOException {
        this.open(null, 0);
    }

    public void open(InetAddress localAddr) throws IOException {
        this.open(localAddr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTransportProvider(String transportName, TransportOptionsIf options) throws IOException {
        InetAddress localAddr;
        if (transportName.equals(this._transportName) && this._transProvider != null) {
            if (options == null) {
                options = this.createTransportOptions(transportName);
            }
            if (this._transProvider.open(options)) {
                this._transOptions = options;
            }
        } else {
            try {
                SnmpTransportProviderIf newProvider = this.createTransportProvider(transportName);
                if (options == null) {
                    options = this.createTransportOptions(transportName);
                }
                newProvider.open(options);
                SnmpTransportProviderIf oldProvider = this._transProvider;
                Object object = this._lockForTransport;
                synchronized (object) {
                    this._transportName = transportName;
                    this._transOptions = options;
                    this._transProvider = newProvider;
                    this._transProvider.setCallback(this);
                    this._lockForTransport.notifyAll();
                }
                this._log.debug((Object)("New transport provider reinitialized: " + this._transportName));
                try {
                    if (oldProvider != null) {
                        oldProvider.close();
                    }
                }
                catch (Exception ex) {
                    this._log.warn((Object)("Closing previous transport error: " + ex));
                }
            }
            catch (Exception ex) {
                this._log.log((Priority)Level.ERROR, (Object)"initTransportProvider() error", (Throwable)ex);
                throw new IOException(ex.getMessage());
            }
        }
        if (this._transportName.equals("tcp")) {
            _TcpSessionOpened = true;
        }
        if ((localAddr = this.getLocalInetAddress()) != null) {
            _MyEngineId = SnmpSession.formEngineId(localAddr.getAddress());
        }
    }

    TransportOptionsIf createTransportOptions(String transportName) throws IOException {
        try {
            Class<?> optionClass = Class.forName(this._configuration.getProperty(transportName + ".options"));
            return (TransportOptionsIf)optionClass.newInstance();
        }
        catch (Exception ex) {
            throw new IOException("TransportOptions cannot be loaded: " + transportName);
        }
    }

    SnmpTransportProviderIf createTransportProvider(String transportName) throws IOException {
        try {
            Class<?> providerClass = Class.forName(this._configuration.getProperty(transportName + ".provider"));
            return (SnmpTransportProviderIf)providerClass.newInstance();
        }
        catch (Exception ex) {
            throw new IOException("TransportProvider cannot be loaded: " + transportName);
        }
    }

    public void rebind(InetAddress bindAddr) throws IOException {
        if (!NetUtil.isLocalHost(NetUtil.getHostAddress(bindAddr))) {
            throw new SocketException("Invalid local address: " + NetUtil.getHostAddress(bindAddr));
        }
        if (this._transOptions instanceof AbstractIpTransportOptions) {
            ((AbstractIpTransportOptions)this._transOptions).setLocalHostname(NetUtil.getHostAddress(bindAddr));
            this._transProvider.open(this._transOptions);
        }
    }

    @Override
    public void run() {
        SnmpTimeout.getInstance().add(this);
    }

    public void close() {
        SnmpTimeout.getInstance().remove(this);
        if (this._resetTimer != null) {
            this._resetTimer.cancel();
            this._resetTimer = null;
        }
        this.removeAllListeners();
        this._closeSession = true;
        try {
            if (this._transProvider != null) {
                this._transProvider.close();
                this._transProvider = null;
            }
        }
        catch (IOException ex) {
            this._log.log((Priority)Level.DEBUG, (Object)("closing " + this.getName() + " error"), (Throwable)ex);
        }
        this._log.debug((Object)(this.getName() + " closed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPDU send(SnmpPDU pdu) throws SnmpException {
        this.waitingReset();
        SnmpPDU snmpPDU = pdu;
        synchronized (snmpPDU) {
            this.processSend(pdu, null);
            try {
                pdu.wait((long)pdu._timeout * ((long)pdu.getRetries() * 2L + 1L));
            }
            catch (InterruptedException ex) {
                pdu.getLogger().warn((Object)"caller thread interrupted while waiting PDU response");
            }
        }
        if (pdu._sendException != null) {
            SnmpException ex = pdu._sendException;
            pdu._sendException = null;
            throw ex;
        }
        SnmpPDU rPdu = pdu._response;
        if (rPdu != null) {
            if (rPdu.getCommand() == -88) {
                if (pdu.getVariables() != null && pdu.getVariables().size() > 0) {
                    throw new SnmpReportException(SnmpReportException.toError(rPdu._error));
                }
            } else if (rPdu.getError() != 0) {
                if (rPdu._errorIndex > 0) {
                    if (pdu._response.getVariables().size() > rPdu._errorIndex - 1) {
                        throw new SnmpVarBindException(MibNode.oidToName(pdu._response.getVariables().getVb(rPdu._errorIndex - 1).getOid().getValue()) + ": " + SnmpException.toError(rPdu.getError()));
                    }
                    throw new SnmpVarBindException(SnmpException.toError(rPdu.getError()));
                }
                throw new SnmpException(SnmpException.toError(rPdu.getError()));
            }
        } else {
            if (pdu._aaaAuthenticated) {
                throw new SnmpException("Invalid Credentials");
            }
            throw new SnmpException("timeout");
        }
        pdu._response = null;
        return rPdu;
    }

    public int send(SnmpPDU pdu, SnmpCallbackIf target) throws SnmpException {
        this.waitingReset();
        return this.processSend(pdu, target);
    }

    private int processSend(SnmpPDU pdu, SnmpCallbackIf target) throws SnmpException {
        pdu._target = target;
        pdu._session = this;
        if (pdu._reqid == 0) {
            pdu._reqid = this.genReqId();
        }
        if (pdu._timeout < 0) {
            pdu._timeout = SnmpPeer._Timeout;
        }
        if (pdu.getRetries() < 0) {
            pdu.setRetries(SnmpPeer._Retries);
        }
        if (pdu.getResourceUnavailableRetries() < 0) {
            pdu.setResourceUnavailableRetries(SnmpPeer._RuaRetries);
        }
        pdu._sendException = null;
        pdu._remainingRetries = pdu._command == -93 ? (short)0 : pdu._retries;
        pdu._remainingRuaRetries = pdu._command == -93 ? (short)0 : pdu._ruaRetries;
        pdu._timeQueued = System.currentTimeMillis();
        if (this._transProvider != null) {
            this._transProvider.write(pdu);
        }
        return pdu._reqid;
    }

    public void forwardTrapPDU(SnmpPDU pdu) throws SnmpException {
        if (pdu.getLogger().isDebugEnabled()) {
            pdu.getLogger().debug((Object)pdu);
        }
        this._transProvider.write(pdu);
    }

    void monitorRequests() {
        this.waitingReset();
        if (this._transProvider != null) {
            this._transProvider.monitorRequests();
        }
    }

    void disconnectPeer(SnmpPeer peer) {
        if (this._transportName.equals("tcp") && peer.getAddress() != null) {
            ((TcpTransportProvider)this._transProvider).closeSession(peer.getAddress(), peer.getPort());
        }
    }

    @Override
    public void transportLinkdown(SnmpTransportProviderIf provider, InetAddress targetAddr) {
    }

    public boolean needReset() {
        long curTime = System.currentTimeMillis();
        return this._demandReset || this._resetTimer != null && curTime - this._lastResetTime.get() > this._resetTimer.getPeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitingReset() {
        if (this._resetLock.isLocked()) {
            ReentrantLock reentrantLock = this._resetLock;
            synchronized (reentrantLock) {
                try {
                    if (this._resetLock.isLocked()) {
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)(this + " enter waitingReset"), (Throwable)new Exception("TraceLogger"));
                        }
                        this._resetLock.wait(1000L);
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)(this + " out waitingReset"), (Throwable)new Exception("TraceLogger"));
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryResetSession() {
        try {
            this._resetLock.lock();
            if (!this.needReset()) {
                return;
            }
            this._log.info((Object)(this + " reset session"));
            this.notifyStatus(4100);
            this._lastResetTime.set(System.currentTimeMillis());
            this._demandReset = false;
            this.resetTransportProvider();
            this.resetQueues();
            this.notifyStatus(4099);
        }
        finally {
            this._resetLock.unlock();
            ReentrantLock reentrantLock = this._resetLock;
            synchronized (reentrantLock) {
                this._resetLock.notifyAll();
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)(this + " done reset session"));
            }
        }
    }

    public void resetQueues() {
    }

    public void resetTransportProvider() {
        block3: {
            try {
                if (this._transProvider instanceof TcpTransportProvider) {
                    ((TcpTransportProvider)this._transProvider).stopSession();
                }
            }
            catch (Exception ex) {
                if (!this._log.isDebugEnabled()) break block3;
                this._log.debug((Object)(this._transProvider + " caught exception from stopping tcp sessions"), (Throwable)ex);
            }
        }
    }

    private void timeoutPdu(SnmpPDU pdu) {
    }

    public void addListener(SessionListener listener) {
        if (listener != null) {
            this._sessionListeners.add(listener);
        }
    }

    public void removeListener(SessionListener listener) {
        if (listener != null) {
            listener.cleanup();
            this._sessionListeners.remove(listener);
        }
    }

    public void removeAllListeners() {
        for (SessionListener l : this._sessionListeners) {
            try {
                l.cleanup();
            }
            catch (Throwable throwable) {}
        }
        this._sessionListeners.clear();
    }

    private void notifyStatus(int status) {
        for (SessionListener l : this._sessionListeners) {
            try {
                switch (status) {
                    case 4099: {
                        l.connected();
                        break;
                    }
                    case 4100: {
                        l.disconnected();
                        break;
                    }
                    default: {
                        l.notify(status);
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                if (!this._log.isDebugEnabled()) continue;
                this._log.debug((Object)(this + " caught exception during notifyStatus to listener:" + l), ex);
            }
        }
    }

    public static void resetSession(String option) {
        if (option == null) {
            return;
        }
        if ((option.startsWith("tcp") || option.startsWith("both")) && _TcpSession != null) {
            SnmpSession._TcpSession._demandReset = true;
            _TcpSession.tryResetSession();
        }
        if ((option.startsWith("udp") || option.startsWith("both")) && _UdpSession != null) {
            SnmpSession._UdpSession._demandReset = true;
            _UdpSession.tryResetSession();
        }
    }

    public static byte[] formEngineId(byte[] ipAddress) {
        System.arraycopy(ipAddress, 0, _MyEngineId, 5, 4);
        return _MyEngineId;
    }

    public static String getStatsInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(Runtime.getRuntime().totalMemory() / 1000L).append("K Heap Memory (").append(Runtime.getRuntime().freeMemory() / 1000L).append("K free)").append("\nAverage Round Trip Delay, etc:");
        SnmpPeer peer = null;
        Iterator<Map.Entry<Object, SnmpPeer>> it = SnmpPeer.getPeersIterator();
        while (it.hasNext()) {
            peer = it.next().getValue();
            int delay = peer.getAverageRoundTripDelay();
            sb.append("\n\t").append(NetUtil.getHostAddress(peer.getAddress())).append("(").append(peer._session._transportName).append("/").append(peer.getVersionString()).append("/").append(peer.isV3() ? peer.getUserName() : peer.getReadCommunity()).append("):\t").append(delay).append(" ms, Rx: ").append(peer._responseLen).append(" / ").append(peer._nResponses).append(" = (").append(peer._nResponses == 0 ? "n/a" : "" + peer._responseLen / peer._nResponses + " bytes avg").append("), ").append(peer._nDelays).append(" discards, ").append(peer._numSets).append(" SETs");
        }
        it = SnmpPeer.getServerPeersIterator();
        while (it.hasNext()) {
            peer = it.next().getValue();
            SnmpPeer cPeer = SnmpPeer.findPeer(peer._addr);
            if (cPeer != null && GenUtil.equals((Object)peer.getSession(), (Object)cPeer.getSession()) && GenUtil.equals((Object)peer.getUserName(), (Object)cPeer.getUserName()) && GenUtil.equals((Object)peer.getReadCommunity(), (Object)cPeer.getReadCommunity())) continue;
            int delay = peer.getAverageRoundTripDelay();
            sb.append("\n\t").append(NetUtil.getHostAddress(peer.getAddress())).append("(").append(peer._session._transportName).append("/").append(peer.getVersionString()).append("/").append(peer.isV3() ? peer.getUserName() : peer.getReadCommunity()).append("):\t").append(delay).append(" ms, Rx: ").append(peer._responseLen).append(" / ").append(peer._nResponses).append(" = (").append(peer._nResponses == 0 ? "n/a" : "" + peer._responseLen / peer._nResponses + " bytes avg").append("), ").append(peer._nDelays).append(" discards, ").append(peer._numSets).append(" SETs");
        }
        if (_UdpSession != null && SnmpSession._UdpSession._transProvider != null) {
            sb.append("\nUDP Provider");
            sb.append(((UdpTransportProvider)SnmpSession._UdpSession._transProvider).getStatsInfo());
        }
        if (_TcpSession != null && SnmpSession._TcpSession._transProvider != null) {
            sb.append("\nTCP Provider");
            sb.append(((TcpTransportProvider)SnmpSession._TcpSession._transProvider).getStatsInfo());
        }
        sb.append("\n").append(CallbackHandler.getInstance());
        sb.append("\n").append(VshManager.getInstance().info());
        if (_TcpSession != null && SnmpSession._TcpSession._resetTimer != null) {
            sb.append("\n").append("Last reset tcp session time:" + new Date(SnmpSession._TcpSession._lastResetTime.get()));
        }
        if (_UdpSession != null && SnmpSession._UdpSession._resetTimer != null) {
            sb.append("\n").append("Last reset udp session time:" + new Date(SnmpSession._UdpSession._lastResetTime.get()));
        }
        return sb.toString();
    }

    public static void clearStats() {
        if (_UdpSession != null) {
            SnmpSession._UdpSession._nResponses = 0;
            SnmpSession._UdpSession._nRequests = 0;
            SnmpSession._UdpSession._responseLen = 0L;
            SnmpSession._UdpSession._requestLen = 0L;
        }
        if (_TcpSession != null) {
            SnmpSession._TcpSession._nResponses = 0;
            SnmpSession._TcpSession._nRequests = 0;
            SnmpSession._TcpSession._responseLen = 0L;
            SnmpSession._TcpSession._requestLen = 0L;
        }
        Iterator<Map.Entry<InetAddress, SnmpPeer>> it = SnmpPeer.getPeersIterator();
        while (it.hasNext()) {
            it.next().getValue().resetRoundTripDelay();
        }
    }

    public static final byte[] getMyEngineId() {
        return _MyEngineId;
    }

    public static boolean isTrace() {
        return LogManager.getLogger((String)"snmp").isTraceEnabled();
    }

    public static void setTrace(boolean b) {
        Level l = b ? Level.ALL : Level.WARN;
        Enumeration en = LogManager.getCurrentLoggers();
        while (en.hasMoreElements()) {
            Logger log = (Logger)en.nextElement();
            if (!log.getName().startsWith("snmp") || log.getName().equals("snmp.trap")) continue;
            log.setLevel(l);
        }
    }

    static {
        _ReqId = new Random().nextInt(0x7FFFFFF8) + 1;
        _MyEngineId = new byte[]{-119, 5, 2, 4, 1, 0, 0, 0, 0};
        _PreferTcp = Boolean.getBoolean("snmp.preferTCP");
        _ResetExecuteHour = Integer.getInteger("snmp.resetTime", 0);
        _ResetPeriod = Integer.getInteger("snmp.resetPeriod", 0);
    }

    class ResetTask
    extends TimerTask {
        ResetTask() {
        }

        @Override
        public void run() {
            SnmpSession.this.tryResetSession();
        }
    }

    class ResetTimer
    extends Timer {
        private TimerTask resetTask;
        private long period;
        private int executeHour;

        public ResetTimer(int executeAtHour, int scheduleOption) {
            super("SessionResetTimer");
            this.resetTask = new ResetTask();
            this.period = 0L;
            this.executeHour = 0;
            GregorianCalendar time = new GregorianCalendar();
            ((Calendar)time).add(5, 1);
            Date executeTime = new GregorianCalendar(time.get(1), time.get(2), time.get(5), executeAtHour > 23 ? 0 : executeAtHour, 0).getTime();
            this.executeHour = executeTime.getHours();
            switch (scheduleOption) {
                case 2: {
                    this.period = 86400000L;
                    this.scheduleAtFixedRate(this.resetTask, executeTime, this.period);
                    break;
                }
                case 3: {
                    this.period = 604800000L;
                    this.scheduleAtFixedRate(this.resetTask, executeTime, this.period);
                    break;
                }
                default: {
                    this.schedule(this.resetTask, executeTime);
                }
            }
        }

        public long getPeriod() {
            return this.period;
        }

        public int getExecuteHour() {
            return this.executeHour;
        }
    }
}

