/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.PacketFilterIf;
import com.cisco.dcbu.lib.snmp.SnmpASN1;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TrapFilter
implements PacketFilterIf {
    static byte[] _UpTimeBytes = new byte[]{6, 8, 43, 6, 1, 2, 1, 1, 3, 0};
    static byte[] _TrapOidBytes = new byte[]{6, 10, 43, 6, 1, 6, 3, 1, 1, 4, 1, 0};
    static Logger _Log = LogManager.getLogger((String)"snmp.trap");
    int[] _ipAddrs;
    int[] _snmpVersions;
    byte _trapVersion = (byte)-1;
    byte[][] _subIds;
    byte _typeFlag;

    public TrapFilter(byte typeFlag, int[] snmpVersion, byte trapVersion, byte[][] subIds) {
        this._typeFlag = typeFlag;
        this._snmpVersions = snmpVersion;
        this._trapVersion = trapVersion;
        this._subIds = subIds;
    }

    public synchronized void setIpAddresses(int[] ipAddrs) {
        this._ipAddrs = ipAddrs;
    }

    public synchronized void setFilteredOids(byte[][] subIds) {
        this._subIds = subIds;
    }

    public synchronized void addIpAddress(InetAddress inetAddr) {
        if (this._ipAddrs == null) {
            this._ipAddrs = new int[]{inetAddr.hashCode()};
            return;
        }
        int[] newList = new int[this._ipAddrs.length + 1];
        for (int i = 0; i < this._ipAddrs.length; ++i) {
            if (this._ipAddrs[i] == inetAddr.hashCode()) {
                return;
            }
            newList[i] = this._ipAddrs[i];
        }
        newList[i] = inetAddr.hashCode();
        this._ipAddrs = newList;
    }

    public synchronized void removeIpAddress(InetAddress inetAddr) {
        if (this._ipAddrs == null) {
            return;
        }
        int[] newList = new int[this._ipAddrs.length - 1];
        for (int i = 0; i < this._ipAddrs.length; ++i) {
            if (this._ipAddrs[i] == inetAddr.hashCode()) {
                while (i < newList.length) {
                    newList[i] = this._ipAddrs[i + 1];
                    ++i;
                }
                this._ipAddrs = (int[])(newList.length == 0 ? null : newList);
                return;
            }
            if (i >= newList.length) break;
            newList[i] = this._ipAddrs[i];
        }
    }

    @Override
    public boolean validate(DatagramPacket packet) {
        if (!this.validateAddress(packet.getAddress())) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)("toss trap from " + packet.getAddress().getHostAddress()));
            }
            return false;
        }
        try {
            SnmpInputStream is = new SnmpInputStream(packet.getData(), packet.getLength());
            ++is._pos;
            TrapFilter.skipTLVLength(is);
            is._pos += 2;
            byte b = is.read();
            if (!this.validateSnmpVersion(b)) {
                if (_Log.isDebugEnabled()) {
                    _Log.debug((Object)("toss trap from " + packet.getAddress().getHostAddress() + " with SNMP version: " + b));
                }
                return false;
            }
            ++is._pos;
            is._pos += TrapFilter.parseTLVLength(is) + 1;
            b = (byte)SnmpASN1.parseHeader(is);
            if (!this.validateTrapVersion(b)) {
                if (_Log.isDebugEnabled()) {
                    _Log.debug((Object)("toss trap from " + packet.getAddress().getHostAddress() + " with trap version: " + b));
                }
                return false;
            }
            ++is._pos;
            is._pos += TrapFilter.parseTLVLength(is) + 1;
            is._pos += 6;
            ++is._pos;
            TrapFilter.skipTLVLength(is);
            ++is._pos;
            TrapFilter.skipTLVLength(is);
            is._pos += 10;
            ++is._pos;
            is._pos += TrapFilter.parseTLVLength(is) + 1;
            is._pos += 2;
            if (!TrapFilter.match(_TrapOidBytes, 12, is._buf, is._pos)) {
                if (_Log.isDebugEnabled()) {
                    _Log.debug((Object)("toss trap from " + packet.getAddress().getHostAddress() + " without snmpTrapOID"));
                }
                return false;
            }
            is._pos += 12;
            int oidLen = TrapFilter.parseTLVLength(is);
            ++is._pos;
            if (!this.validateTrapOID(is)) {
                if (_Log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder("toss trap from " + packet.getAddress().getHostAddress() + " with OID: ");
                    for (int i = 0; i < oidLen; ++i) {
                        sb.append(is._buf[is._pos + i] + ".");
                    }
                    _Log.debug((Object)sb.toString());
                }
                return false;
            }
        }
        catch (Exception ex) {
            _Log.log((Priority)Level.ERROR, (Object)"TrapFiler::validate() error", (Throwable)ex);
            return false;
        }
        return true;
    }

    boolean validateAddress(InetAddress inetAddr) {
        if (this._ipAddrs != null) {
            for (int i = 0; i < this._ipAddrs.length; ++i) {
                if (inetAddr.hashCode() != this._ipAddrs[i]) continue;
                return (this._typeFlag & 1) != 0;
            }
        }
        return (this._typeFlag & 1) == 0;
    }

    boolean validateSnmpVersion(byte version) {
        if (this._snmpVersions != null) {
            for (int i = 0; i < this._snmpVersions.length; ++i) {
                if (version != this._snmpVersions[i]) continue;
                return (this._typeFlag & 2) != 0;
            }
        }
        return (this._typeFlag & 2) == 0;
    }

    boolean validateTrapVersion(int ver) {
        return (this._typeFlag & 4) != 0 == (ver == this._trapVersion);
    }

    boolean validateTrapOID(SnmpInputStream is) {
        if (this._subIds != null) {
            for (int i = 0; i < this._subIds.length; ++i) {
                if (!TrapFilter.match(this._subIds[i], this._subIds[i].length, is._buf, is._pos)) continue;
                return (this._typeFlag & 8) != 0;
            }
        }
        return (this._typeFlag & 8) == 0;
    }

    public static boolean match(byte[] pattern, int pLen, byte[] buffer, int bOffset) {
        for (int i = 0; i < pLen; ++i) {
            if (pattern[i] == buffer[bOffset + i]) continue;
            return false;
        }
        return true;
    }

    static int parseTLVType(SnmpInputStream is) throws SnmpException {
        int i = is.read() & 0xFF;
        if ((i & 0x1F) == 31) {
            throw new SnmpException("can't decode TLV type >= 30");
        }
        return i;
    }

    static int parseTLVLength(SnmpInputStream is) throws SnmpException {
        int len = SnmpASN1.parseLength(is);
        if (len == -1) {
            throw new SnmpException("can't decode TLV length == -1");
        }
        return len;
    }

    static void skipTLVLength(SnmpInputStream is) throws SnmpException {
        byte val = is.read();
        if ((val & 0xFFFFFF80) == 0) {
            return;
        }
        if ((val = (byte)(val & 0x7F)) == 0 || val > 4) {
            throw new SnmpException("decode: datalength not supported: " + val);
        }
        is._pos += val;
    }
}

