/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.proxy;

import com.cisco.dcbu.lib.snmp.transport.AbstractIpTransportOptions;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class ProxyTransportOptions
extends AbstractIpTransportOptions {
    private static final long serialVersionUID = 1L;
    protected InetAddress _proxyAddress;
    protected int _proxyPort;

    public ProxyTransportOptions() {
    }

    public ProxyTransportOptions(InetAddress proxyAddr, int proxyPort) {
        this.setProxyAddress(proxyAddr);
        this.setProxyPort(proxyPort);
    }

    public ProxyTransportOptions(InetSocketAddress proxySockAddr) {
        this.setProxySocketAddress(proxySockAddr);
    }

    public ProxyTransportOptions(InetAddress proxyAddr, int proxyPort, String localAddr, int localPort) {
        super(localAddr, localPort);
        this.setProxyAddress(proxyAddr);
        this.setProxyPort(proxyPort);
    }

    public InetAddress getProxyAddress() {
        return this._proxyAddress;
    }

    public void setProxyAddress(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Invalid port: " + address);
        }
        this._proxyAddress = address;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this._proxyPort = port;
    }

    public InetSocketAddress getProxySocketAddress() {
        return new InetSocketAddress(this._proxyAddress, this._proxyPort);
    }

    public void setProxySocketAddress(InetSocketAddress sockaddr) {
        this.setProxyAddress(sockaddr.getAddress());
        this.setProxyPort(sockaddr.getPort());
    }
}

