/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.Bits;
import com.cisco.dcbu.lib.snmp.MibEnum;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;

public class BitsCellEditor
extends DefaultCellEditor
implements ActionListener {
    JPopupMenu _menu;
    JTable _table;
    int _row;
    int _column;
    Bits _bits;
    MibEnum[] _enums;

    public BitsCellEditor(MibEnum[] enums) {
        super(new JTextField());
        this.clickCountToStart = 1;
        this._enums = enums;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._bits = (Bits)value;
        this._table = table;
        this._row = row;
        this._column = column;
        if (this._menu == null) {
            this._menu = new JPopupMenu();
            for (int j = 0; j < this._enums.length; ++j) {
                JCheckBoxMenuItem mi = new JCheckBoxMenuItem(this._enums[j].getLabel());
                this._menu.add(mi);
                mi.addActionListener(this);
            }
        }
        for (int i = 0; i < this._enums.length; ++i) {
            int toSel = this._enums[i].getValue();
            boolean selected = Bits.getBitBase0(this._bits.getValue(), toSel);
            ((JCheckBoxMenuItem)this._menu.getComponent(i)).setSelected(selected);
        }
        Rectangle rect = table.getCellRect(row, column, false);
        this._menu.show(this._table, rect.x, rect.y);
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBoxMenuItem mi = (JCheckBoxMenuItem)e.getSource();
        int index = this._menu.getComponentIndex(mi);
        byte[] curVal = this._bits.getValue();
        byte[] newVal = new byte[curVal.length];
        System.arraycopy(curVal, 0, newVal, 0, curVal.length);
        Bits newbits = new Bits(this._bits._enums, newVal);
        int pos = this._bits.getEnums()[index].getValue();
        if (mi.isSelected()) {
            Bits.setBitBase0(newVal, pos);
        } else {
            Bits.clearBitBase0(newVal, pos);
        }
        int modelcol = this._table.convertColumnIndexToModel(this._column);
        this._table.getModel().setValueAt(newbits, this._row, modelcol);
    }
}

