/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;

public class InterfaceIndex
extends SnmpInt {
    IfIndexIf _ifIndexIf;

    public InterfaceIndex(SnmpInt s, IfIndexIf ifIndexIf) throws SnmpException {
        super(InterfaceIndex.parse(s.getValue()));
        this._ifIndexIf = ifIndexIf;
    }

    public InterfaceIndex(SnmpInt s, IfIndexIf ifIndexIf, boolean allowZero) throws SnmpException {
        super(InterfaceIndex.parse(s.getValue(), ifIndexIf, allowZero));
        this._ifIndexIf = ifIndexIf;
    }

    public InterfaceIndex(String s, IfIndexIf ifIndexIf) throws SnmpException {
        super(InterfaceIndex.parse(s, ifIndexIf, false));
        this._ifIndexIf = ifIndexIf;
    }

    public InterfaceIndex(String s, IfIndexIf ifIndexIf, boolean allowZero) throws SnmpException {
        super(InterfaceIndex.parse(s, ifIndexIf, allowZero));
        this._ifIndexIf = ifIndexIf;
    }

    public static int parse(int s) throws SnmpException {
        if (s <= 0) {
            throw new SnmpException("bad interface");
        }
        return s;
    }

    public static int parse(String s, IfIndexIf ifIndexIf) throws SnmpException {
        return InterfaceIndex.parse(s, ifIndexIf, false);
    }

    public static int parse(String s, IfIndexIf ifIndexIf, boolean allowZero) throws SnmpException {
        if ((s.equals("") || s.equals("0")) && allowZero) {
            return 0;
        }
        try {
            int ifIndex = ifIndexIf.nameToIfIndex(s);
            return ifIndex;
        }
        catch (Error ex) {
            throw new SnmpException(ex.getMessage());
        }
    }

    public static int parse(String s, boolean allowZero, IfIndexIf ifIndexIf) throws SnmpException {
        if ((s.equals("") || s.equals("0")) && allowZero) {
            return 0;
        }
        try {
            int ifIndex = ifIndexIf.nameToIfIndex(s);
            return ifIndex;
        }
        catch (Error ex) {
            throw new SnmpException(ex.getMessage());
        }
    }

    public static int parse(int s, IfIndexIf ifIndexIf, boolean allowZero) throws SnmpException {
        if (s <= 0 && !allowZero) {
            throw new SnmpException("bad interface");
        }
        return s;
    }

    @Override
    public String toString() {
        if (this._ifIndexIf == null) {
            return IfIndexUtil.ifIndexToName(this.getValue());
        }
        return this._ifIndexIf.ifIndexToName(this.getValue());
    }
}

