/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.Bits;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;

class NlmVariableReq {
    static final String[] _VarVals = new String[]{"nlmLogVariableCounter32Val", "nlmLogVariableUnsigned32Val", "nlmLogVariableTimeTicksVal", "nlmLogVariableInteger32Val", "nlmLogVariableIpAddressVal", "nlmLogVariableOctetStringVal", "nlmLogVariableOidVal", "nlmLogVariableCounter64Val", "nlmLogVariableOpaqueVal"};
    int _logIndex;
    int _logVariableIndex;
    int[] _varId;
    int _type;
    String _valueText;

    public NlmVariableReq(int logIndex, int logVariableIndex, int[] varId, int type) {
        this._logIndex = logIndex;
        this._logVariableIndex = logVariableIndex;
        this._varId = varId;
        this._type = type;
    }

    public int getLogIndex() {
        return this._logIndex;
    }

    public int getLogVariableIndex() {
        return this._logVariableIndex;
    }

    public int[] getVarId() {
        return this._varId;
    }

    public int getType() {
        return this._type;
    }

    public int[] getTypeVar() {
        if (this._type < 1 || this._type > 9) {
            System.err.println("Notification Log " + this._logIndex + "  " + this._logVariableIndex + " : wrong type " + this._type);
            return null;
        }
        return MibNode.get(_VarVals[this._type - 1]).getOid();
    }

    public String getValueText() {
        return this._valueText;
    }

    public void setValueText(String varText) {
        this._valueText = varText;
    }

    public void setValueText(SnmpVar var) {
        MibNode n = MibNode.oidToNode(this._varId);
        if (n != null) {
            MibEnum[] enums = n.getEnums();
            if (enums != null) {
                if (var.getType() == 2) {
                    this._valueText = MibEnum.getLabel(enums, ((SnmpInt)var).getValue());
                } else if (var.getType() == 4) {
                    this._valueText = Bits.bitsToStringBase0(((SnmpString)var).getValue(), enums);
                }
            } else {
                this._valueText = var.getType() == 6 ? MibNode.oidToName(((SnmpOID)var).getValue()) : var.toString();
            }
        } else {
            this._valueText = SnmpOID.toString(this._varId);
        }
    }
}

