/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.BitSetCellEditor;
import com.cisco.dcbu.lib.jnm.BitsCellEditor;
import com.cisco.dcbu.lib.jnm.IndexCellRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCounter64;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.ui.table.ChangedBooleanCellRenderer;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.ColumnGroup;
import com.cisco.dcbu.lib.ui.table.GroupableTableHeader;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.table.MultiLineHeaderRenderer;
import com.cisco.dcbu.lib.ui.table.PasswordCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SnmpKTable
extends KTable {
    public static String REFRESH = "***REFRESH***";
    private static int INSETS = 6;
    Component[] _changeListeners;
    public int[] _fixedWidths;
    BoldEditor _defaultCellEditor;
    private static PasswordCellRenderer _PasswordCellRenderer = new PasswordCellRenderer();
    private static JPasswordField _PasswordField = null;
    private static BoldEditor _PasswordCellEditor = null;

    public SnmpKTable(KTableModel model) {
        this(model, false);
    }

    public SnmpKTable(KTableModel model, boolean multiRow) {
        super((TableModel)model, multiRow);
        this.setAutoResizeMode(3);
        this.setCellSelectionEnabled(true);
        ChangedCellRenderer leftRenderer = new ChangedCellRenderer();
        ChangedCellRenderer rightRenderer = new ChangedCellRenderer();
        ChangedBooleanCellRenderer booleanRenderer = new ChangedBooleanCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        this.setDefaultRenderer(Object.class, leftRenderer);
        this.setDefaultRenderer(SnmpInt.class, rightRenderer);
        this.setDefaultRenderer(SnmpUnsignedInt.class, rightRenderer);
        this.setDefaultRenderer(SnmpCounter64.class, rightRenderer);
        this.setDefaultRenderer(Number.class, rightRenderer);
        this.setDefaultRenderer(Boolean.class, booleanRenderer);
        booleanRenderer.setHorizontalAlignment(0);
        this._defaultCellEditor = new BoldEditor(new JTextField());
        this.setDefaultEditor(Object.class, this._defaultCellEditor);
    }

    public BoldEditor getDefaultCellEditor() {
        return this._defaultCellEditor;
    }

    protected int getColFrmMibNode(int col) {
        return col;
    }

    public void addCellEditor(MibNode[] mibNodes) {
        for (int i = 0; i < mibNodes.length; ++i) {
            String tcLabel;
            if (mibNodes[i] == null || (tcLabel = mibNodes[i].getTCLabel()) == null || !tcLabel.startsWith("KeyChange") && !tcLabel.startsWith("Password") && !tcLabel.startsWith("CiscoRadiusAuthKey")) continue;
            if (_PasswordCellEditor != null) {
                _PasswordCellEditor = null;
                _PasswordField = null;
            }
            _PasswordField = new JPasswordField();
            _PasswordField.getInputMap().remove(KeyStroke.getKeyStroke(67, 2));
            _PasswordCellEditor = new BoldEditor(_PasswordField);
            if (this.getColumnModel().getColumn(this.getColFrmMibNode(i)).getCellEditor() != null) continue;
            this.getColumnModel().getColumn(this.getColFrmMibNode(i)).setCellEditor(_PasswordCellEditor);
            this.getColumnModel().getColumn(this.getColFrmMibNode(i)).setCellRenderer(_PasswordCellRenderer);
        }
    }

    public void addEnumCellEditor(MibNode[] mibNodes) {
        boolean hasEnums = false;
        FontMetrics fontMetrics = this.getFontMetrics(ChangedCellRenderer.getNormalFont());
        FontMetrics changeFontMetrics = this.getFontMetrics(ChangedCellRenderer.getChangeFont());
        for (int i = 0; i < mibNodes.length; ++i) {
            if (mibNodes[i] == null || mibNodes[i].getEnums() == null) continue;
            MibEnum[] enums = this.getApplicableEnums(mibNodes[i]);
            if (!mibNodes[i].isEditable()) continue;
            String tcLabel = mibNodes[i].getTCLabel();
            if (tcLabel != null) {
                if (tcLabel.startsWith("BitSet")) {
                    if (this.getColumnModel().getColumn(this.getColFrmMibNode(i)).getCellEditor() == null) {
                        this.getColumnModel().getColumn(this.getColFrmMibNode(i)).setCellEditor(new BitSetCellEditor());
                        continue;
                    }
                } else if (tcLabel.startsWith("KeyChange")) {
                    if (_PasswordCellEditor != null) {
                        _PasswordCellEditor = null;
                        _PasswordField = null;
                    }
                    _PasswordField = new JPasswordField();
                    _PasswordField.getInputMap().remove(KeyStroke.getKeyStroke(67, 2));
                    _PasswordCellEditor = new BoldEditor(_PasswordField);
                    if (this.getColumnModel().getColumn(this.getColFrmMibNode(i)).getCellEditor() == null) {
                        this.getColumnModel().getColumn(this.getColFrmMibNode(i)).setCellEditor(_PasswordCellEditor);
                        this.getColumnModel().getColumn(this.getColFrmMibNode(i)).setCellRenderer(_PasswordCellRenderer);
                        continue;
                    }
                } else if (tcLabel.startsWith("TruthValue") || tcLabel.startsWith("Action")) {
                    this.setEnumWidth(i, null, fontMetrics);
                    continue;
                }
            } else if (mibNodes[i].isBITS() && this.getColumnModel().getColumn(this.getColFrmMibNode(i)).getCellEditor() == null) {
                this.getColumnModel().getColumn(this.getColFrmMibNode(i)).setCellEditor(new BitsCellEditor(enums));
                continue;
            }
            if (this.getColumnModel().getColumn(this.getColFrmMibNode(i)).getCellEditor() != null) continue;
            JComboBox<MibEnum> combo = new JComboBox<MibEnum>(new DefaultComboBoxModel<MibEnum>(enums));
            combo.setEditable(false);
            this.getColumnModel().getColumn(this.getColFrmMibNode(i)).setCellEditor(new BoldEditor(combo));
            this.setEnumWidth(i, enums, changeFontMetrics);
            hasEnums = true;
        }
    }

    protected MibEnum[] getApplicableEnums(MibNode mibNode) {
        return mibNode.getEnums();
    }

    public void setEnumWidth(int col, MibEnum[] enums, FontMetrics fm) {
        KTableModel model = (KTableModel)this.getModel();
        int widest = this.getHeaderColumnWidth(fm, col);
        if (enums != null) {
            for (int j = 0; j < enums.length; ++j) {
                int width = fm.stringWidth(enums[j].getLabel());
                if (width <= widest) continue;
                widest = width;
            }
        }
        this.setFixedWidth(col, widest + 4);
    }

    public void setFixedWidth(int col, int width) {
        if (this._fixedWidths == null) {
            this._fixedWidths = new int[this.getColumnCount()];
        }
        this._fixedWidths[col] = width;
        this.getColumnModel().getColumn(col).setPreferredWidth(width);
    }

    public void setMultiLineColumn(int col, String[] header) {
        FontMetrics fm = this.getFontMetrics(ChangedCellRenderer.getChangeFont());
        int widest = 0;
        for (int i = 0; i < header.length; ++i) {
            int width = fm.stringWidth(header[i]);
            if (width <= widest) continue;
            widest = width;
        }
        this.getColumnModel().getColumn(col).setHeaderRenderer(new MultiLineHeaderRenderer(header));
        this.setFixedWidth(col, widest + INSETS);
    }

    public void resetFixedWidths() {
        this._fixedWidths = null;
    }

    @Override
    public int colWidthToWidest(int viewColumn) {
        int col = this.convertColumnIndexToModel(viewColumn);
        if (this._fixedWidths != null && col < this._fixedWidths.length && this._fixedWidths[col] > 0) {
            return this._fixedWidths[col];
        }
        return super.colWidthToWidest(viewColumn);
    }

    public String getIndexCellString(TableModel model, int row, int col) {
        return this.getCellString(model, row, col);
    }

    @Override
    protected String getCellString(TableModel model, int row, int col) {
        int viewCol = this.convertColumnIndexToView(col);
        TableCellRenderer r = this.getColumnModel().getColumn(viewCol).getCellRenderer();
        if (r != null) {
            if (r instanceof IndexCellRenderer) {
                if (viewCol >= 0 && viewCol <= 1) {
                    Component labelComp;
                    IndexCellRenderer icr = (IndexCellRenderer)r;
                    int[] index = ((SnmpOID)model.getValueAt(row, col)).getValue();
                    String label = icr.getLabel(index);
                    if (label == null && (labelComp = icr.getTableCellRendererComponent(this, (SnmpOID)model.getValueAt(row, col), false, false, row, viewCol)) instanceof JLabel) {
                        return ((JLabel)labelComp).getText();
                    }
                    return label;
                }
            } else {
                if (r instanceof PasswordCellRenderer) {
                    return "";
                }
                Component labelComp = ((DefaultTableCellRenderer)r).getTableCellRendererComponent(this, model.getValueAt(row, col), false, false, row, viewCol);
                if (labelComp instanceof JLabel) {
                    return ((JLabel)labelComp).getText();
                }
            }
        }
        return super.getCellString(model, row, col);
    }

    public void setChangeListener(Component changeListener) {
        Component[] components = new Component[]{changeListener};
        this.setChangeListener(components);
    }

    public void setChangeListener(Component[] changeListeners) {
        this._changeListeners = changeListeners;
    }

    public Component[] getChangeListener() {
        return this._changeListeners;
    }

    public void buildColHeaders(int offset, String[] headers) {
        KTableModel model = (KTableModel)this.getModel();
        for (int i = 0; i < headers.length; ++i) {
            if (headers[i] == null) continue;
            model.setHeader(i + offset, headers[i]);
        }
    }

    private GroupableTableHeader getGroupableTableHeader() {
        JTableHeader header = this.getTableHeader();
        if (!(header instanceof GroupableTableHeader)) {
            GroupableTableHeader gth = new GroupableTableHeader(this.columnModel);
            this.setTableHeader(gth);
            if (this._isSortable) {
                gth.addMouseListener(new HeaderListener());
            }
            return gth;
        }
        return (GroupableTableHeader)header;
    }

    public void buildColGroups(String[] group, int[][] ranges) {
        TableColumnModel cm = this.getColumnModel();
        GroupableTableHeader header = this.getGroupableTableHeader();
        header.clearColumnGroups();
        for (int i = 0; i < group.length; ++i) {
            ColumnGroup cg1 = new ColumnGroup(this.getTableHeader().getDefaultRenderer(), group[i]);
            for (int j = ranges[i][0]; j <= ranges[i][1]; ++j) {
                cg1.add(cm.getColumn(j));
            }
            header.addColumnGroup(cg1);
        }
    }

    public void buildColGroups(String[] superGroup, int[][] superRange, String[] group, int[][] ranges) {
        int i;
        TableColumnModel cm = this.getColumnModel();
        GroupableTableHeader header = this.getGroupableTableHeader();
        header.clearColumnGroups();
        Array<ColumnGroup> superColGrps = new Array<ColumnGroup>();
        for (i = 0; i < superGroup.length; ++i) {
            ColumnGroup cg0 = new ColumnGroup(this.getTableHeader().getDefaultRenderer(), superGroup[i]);
            header.addColumnGroup(cg0);
            superColGrps.addElement(cg0);
        }
        for (i = 0; i < group.length; ++i) {
            ColumnGroup cg1 = new ColumnGroup(this.getTableHeader().getDefaultRenderer(), group[i]);
            if (ranges[i][0] != ranges[i][1]) {
                for (int j = ranges[i][0]; j <= ranges[i][1]; ++j) {
                    cg1.add(cm.getColumn(j));
                }
            }
            boolean added2SuperGrp = false;
            for (int k = 0; k < superGroup.length; ++k) {
                if (ranges[i][0] < superRange[k][0] || ranges[i][1] > superRange[k][1]) continue;
                ColumnGroup cg0 = (ColumnGroup)superColGrps.elementAt(k);
                if (ranges[i][0] != ranges[i][1]) {
                    cg0.add(cg1);
                } else {
                    cg0.add(cm.getColumn(ranges[i][0]));
                }
                added2SuperGrp = true;
                break;
            }
            if (added2SuperGrp) continue;
            header.addColumnGroup(cg1);
        }
    }

    public String getFullColumnHeader(int column) {
        Array groups;
        JTableHeader header = this.getTableHeader();
        String columnHeader = this.getModel().getColumnName(column);
        if (header instanceof GroupableTableHeader && (groups = ((GroupableTableHeader)header).getColumnGroups(this.columnModel.getColumn(this.convertColumnIndexToView(column)))) != null && !((ColumnGroup)groups.elementAt(0)).getHeaderValue().equals("")) {
            return ((ColumnGroup)groups.elementAt(0)).getHeaderValue() + " " + columnHeader;
        }
        return columnHeader;
    }

    public static interface Refresher {
        public void refresh(Object var1, JTable var2, int var3, int var4);
    }

    class EnumRenderer
    extends ChangedCellRenderer {
        EnumRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            c.setIcon(HeaderListener.getDownImage());
            c.setHorizontalTextPosition(2);
            return c;
        }
    }

    public class BoldEditor
    extends DefaultCellEditor {
        public BoldEditor(JTextField f) {
            super(f);
            f.setBorder(BorderFactory.createLineBorder(Color.black));
            f.setFont(ChangedCellRenderer.getChangeFont());
        }

        public BoldEditor(JComboBox f) {
            super(f);
        }

        public BoldEditor(JPasswordField f) {
            super(f);
            f.setBorder(BorderFactory.createLineBorder(Color.black));
            f.setFont(ChangedCellRenderer.getChangeFont());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Object refresher;
            if (SnmpKTable.this._changeListeners != null) {
                for (int i = 0; i < SnmpKTable.this._changeListeners.length; ++i) {
                    SnmpKTable.this._changeListeners[i].setEnabled(true);
                }
            }
            if ((refresher = this.getClientProperty(REFRESH)) != null && refresher instanceof Refresher) {
                ((Refresher)refresher).refresh(this.editorComponent, table, row, column);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public Object getClientProperty(Object key) {
            Object value = null;
            if (this.editorComponent != null) {
                value = this.editorComponent.getClientProperty(key);
            }
            return value;
        }

        public void putClientProperty(Object key, Object value) {
            if (this.editorComponent != null) {
                this.editorComponent.putClientProperty(key, value);
            }
        }
    }
}

