/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.IfVshStatus;
import com.cisco.dcbu.lib.jnm.JschConnectionException;
import com.cisco.dcbu.lib.jnm.SshUserInfo;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshBase;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import org.apache.commons.net.telnet.TelnetClient;

public class VshLanSwitch
extends Vsh {
    public VshLanSwitch(String host, String user, String pass, boolean useSsh, IfVshStatus statusListener) {
        super(host, user, pass, useSsh, statusListener);
    }

    public static VshBase getVshInConfigMode(String ipAddress, String userName, String pwd, String enablePwd, boolean useSsh, IfVshStatus statusListener) throws Exception {
        VshBase vs = null;
        boolean exceptionThrown = false;
        try {
            vs = VshLanSwitch.getVshForLanSwitch(ipAddress, userName, pwd, enablePwd, useSsh, statusListener, false);
            StringBuffer output = new StringBuffer();
            String currentPrompt = vs.getPrompt();
            output.setLength(0);
            vs.send("configure terminal\n");
            vs.expect(new String[]{"config)#", currentPrompt}, output);
            VshLanSwitch.logTrace(output);
            vs.learn();
        }
        catch (Exception exx) {
            exceptionThrown = true;
            throw exx;
        }
        finally {
            if (vs != null && exceptionThrown) {
                vs.disconnect();
                vs = null;
            }
        }
        return vs;
    }

    public static VshBase getVshForLanSwitch(String ipAddress, String userName, String pwd, String enablePwd, boolean useSsh, IfVshStatus statusListener, boolean isUCS) throws Exception {
        VshBase vs = VshLanSwitch.getNew(null, ipAddress, userName, pwd, useSsh, "com.cisco.dcbu.lib.jnm.VshLanSwitch", statusListener);
        if (vs == null) {
            throw new Exception("Switch " + ipAddress + " is inaccessible.");
        }
        if (isUCS) {
            return vs;
        }
        boolean exceptionThrown = false;
        try {
            StringBuffer output = new StringBuffer();
            String currentPrompt = vs.getPrompt();
            vs.send("show privilege\n");
            vs.expect(new String[]{currentPrompt}, output);
            VshLanSwitch.logTrace(output);
            String privLev = output.substring(0, output.indexOf(currentPrompt));
            output.setLength(0);
            if (privLev.indexOf("-1") == -1 && privLev.indexOf("15") == -1) {
                if (enablePwd == null || enablePwd.trim().length() == 0) {
                    throw new Exception("Please provide 'enable'password");
                }
                vs.send("enable\n");
                vs.expect(new String[]{"password:", "Password:", "(yes/no)?", currentPrompt}, output);
                VshLanSwitch.logTrace(output);
                if (output.toString().toLowerCase().indexOf("password:") != -1) {
                    output.setLength(0);
                    vs.send(enablePwd + "\n");
                    vs.expect(new String[]{"password:", "Password:", currentPrompt, "#"}, output);
                    if (output.toString().toLowerCase().indexOf("password:") != -1) {
                        VshLanSwitch.logTrace(output);
                        throw new Exception("Incorrect Password");
                    }
                    VshLanSwitch.logTrace(output);
                }
                vs.learn();
                currentPrompt = vs.getPrompt();
            }
        }
        catch (Exception exx) {
            exceptionThrown = true;
            throw exx;
        }
        finally {
            if (vs != null && exceptionThrown) {
                vs.disconnect();
                vs = null;
            }
        }
        return vs;
    }

    @Override
    boolean connectTelnet() throws IOException {
        if (SnmpSession.isTrace()) {
            String encryptedPass = "";
            try {
                encryptedPass = StringEncrypter.encryptString("DES", this._pass);
            }
            catch (Exception ex) {
                System.out.println("Invalid password Encryption failed.");
            }
            this.trace("connect [Ssh]: Authenticating User <" + this._user + "> Password <" + encryptedPass + "> on <" + this._host + ">");
        }
        this._tc = new TelnetClient();
        this._tc.setDefaultTimeout(this._tcpTimeout);
        try {
            this._tc.connect(this._host, 23);
        }
        catch (IOException e) {
            this.trace("connect [Telnet ]: connect Exception : " + e.getMessage());
            throw e;
        }
        try {
            this._tc.setSoTimeout(this._tcpTimeout);
            this._in = this._tc.getInputStream();
            this._out = this._tc.getOutputStream();
            this.expectUpperLowerComparison(new String[]{"Username:", "Login:"}, true);
            this.send(this._user + "\n");
            this.expectUpperLowerComparison("Password:", true);
            this.send(this._pass + "\n");
            this.wait(800);
            String[] options = new String[]{">", "#", "login:", "Username:"};
            int delim = this.expectLoginUpperLowerComparison(options, true);
            switch (delim) {
                case 0: 
                case 1: {
                    this.learn();
                    return true;
                }
                case 2: {
                    this.disconnect();
                    return false;
                }
            }
            this.disconnect();
            return false;
        }
        catch (IOException e1) {
            this.trace("connect [Telnet ] : Exception " + e1.getMessage());
            return false;
        }
    }

    @Override
    boolean connectSsh() throws JSchException, IOException {
        JSch jsch = new JSch();
        if (SnmpSession.isTrace()) {
            String encryptedPass = "";
            try {
                encryptedPass = StringEncrypter.encryptString("DES", this._pass);
            }
            catch (Exception ex) {
                System.out.println("Invalid password Encryption failed.");
            }
            this.trace("connect [Ssh]: Authenticating User <" + this._user + "> Password <" + encryptedPass + "> on <" + this._host + ">");
        }
        this._session = jsch.getSession(this._user, this._host, 22);
        this._session.setUserInfo(new SshUserInfo(this._pass));
        try {
            this._session.connect();
        }
        catch (JSchException e) {
            if (e.getMessage().indexOf("Auth fail") != -1) {
                throw e;
            }
            throw new JschConnectionException(e.getMessage());
        }
        try {
            this._channel = this._session.openChannel("shell");
            try {
                this._in = this._channel.getInputStream();
                this._out = this._channel.getOutputStream();
            }
            catch (IOException ee) {
                this.trace("connect [Ssh]: in/out stream get exception : " + ee.getMessage());
                if (this._session != null) {
                    this._session.disconnect();
                }
                throw ee;
            }
            this._channel.connect();
        }
        catch (IOException e1) {
            this.trace("connect [Ssh]: Channel connect exception : " + e1.getMessage());
            if (this._session != null) {
                this._session.disconnect();
            }
            if (this._channel != null) {
                this._channel.disconnect();
            }
            throw e1;
        }
        try {
            String[] options = new String[]{">", "#", "password:"};
            this._prompt = "NO_PROMPT_SET";
            switch (this.expect(options)) {
                case 0: 
                case 1: {
                    this.learn();
                    return true;
                }
                case 2: {
                    this.disconnect();
                    return false;
                }
            }
            this.disconnect();
            return false;
        }
        catch (IOException ex) {
            this.trace("connect [Ssh] failed." + ex.getMessage());
            if (this._session != null) {
                this._session.disconnect();
            }
            throw new IOException("connect [Ssh] failed : " + ex.getMessage());
        }
    }

    @Override
    public void learn() throws IOException {
        try {
            String[] options = new String[]{">", "#"};
            this.send("\n");
            int delimiter = this.expect(options);
            String tmp = this.getReply();
            switch (delimiter) {
                case 0: {
                    this._prompt = ">";
                    break;
                }
                case 1: {
                    this._prompt = "#";
                }
            }
            this.send("\n");
            tmp = this.readPrompt();
            this._prompt = this.extract(tmp);
        }
        catch (IOException ex) {
            this.disconnect();
            throw ex;
        }
    }

    private static void logTrace(StringBuffer output) {
        if (DefaultLogger._DefLogger != null) {
            DefaultLogger._DefLogger.info((Object)output);
        } else {
            System.out.println(output);
        }
    }

    public static void main(String[] args) {
        String tagStr = "abc,";
        tagStr = tagStr.substring(0, tagStr.lastIndexOf(44));
        System.out.println(tagStr);
    }
}

