/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.logging;

import com.cisco.dcbu.lib.logging.LocalLogManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ConsoleFormatter
extends Formatter {
    SimpleDateFormat _DateFormat = new SimpleDateFormat("yyyy.MM.dd kk:mm:ss");
    int maxLen;

    @Override
    public String format(LogRecord record) {
        Throwable t;
        StringBuilder sb = new StringBuilder();
        sb.append(this._DateFormat.format(new Date(record.getMillis()))).append("  ").append(record.getLevel()).append("  [").append(record.getLoggerName()).append("]");
        this.maxLen = Math.max(record.getLoggerName().length(), this.maxLen);
        int max = this.maxLen - record.getLoggerName().length();
        for (int i = 0; i < max; ++i) {
            sb.append(" ");
        }
        if (record.getMessage() != null && record.getMessage().length() != 0) {
            sb.append(" ").append(record.getMessage());
        }
        if (LocalLogManager._StackTrace && (t = record.getThrown()) != null) {
            sb.append("\nsource: ").append(record.getSourceClassName()).append('.').append(record.getSourceMethodName()).append('\n').append(t.getMessage()).append('\n').append(ConsoleFormatter.getStackTrace(record.getThrown()));
        }
        return sb.append('\n').toString();
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

