/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.client;

import com.cisco.dcbu.lib.map.common.MultipleLinkHandler;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.nm.esper.model.DragHelper;
import com.cisco.nm.esper.model.Graph;
import java.util.Iterator;

public class TopologyDragHelper
extends DragHelper {
    private static TopologyDragHelper _Instance = null;

    public TopologyDragHelper(Graph graph) {
        super(graph);
        _Instance = this;
    }

    @Override
    public void onDropAt(double x, double y) {
        super.onDropAt(x, y);
        Iterator nodeItr = this.nodes();
        while (nodeItr.hasNext()) {
            TopologyLink l;
            TopologyNode n = (TopologyNode)nodeItr.next();
            Iterator itr1 = n.inedges();
            while (itr1.hasNext()) {
                l = (TopologyLink)itr1.next();
                if (l.isDummyLink() && !l.isVisible()) {
                    l.setTooltip(null);
                    MultipleLinkHandler.getInstance().handle(l.getSourceNode(), l.getTargetNode());
                    continue;
                }
                if (l.isDummyLink()) {
                    l.setTooltip(null);
                    continue;
                }
                if (!l.hasDummyLink()) {
                    l.setFormattedTooltip(null);
                    continue;
                }
                l.setTooltip(null);
                MultipleLinkHandler.getInstance().handle(l.getSourceNode(), l.getTargetNode());
            }
            Iterator itr2 = n.outedges();
            while (itr2.hasNext()) {
                l = (TopologyLink)itr2.next();
                if (l.isDummyLink() && !l.isVisible()) {
                    l.setTooltip(null);
                    MultipleLinkHandler.getInstance().handle(l.getSourceNode(), l.getTargetNode());
                    continue;
                }
                if (l.isDummyLink()) {
                    l.setTooltip(null);
                    continue;
                }
                if (!l.hasDummyLink()) {
                    l.setFormattedTooltip(null);
                    continue;
                }
                MultipleLinkHandler.getInstance().handle(l.getSourceNode(), l.getTargetNode());
            }
        }
    }

    public void reset() {
        this.onCancel();
        this.clear();
    }

    public static TopologyDragHelper getLastInstance() {
        return _Instance;
    }
}

