/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.map.common.MapProperties;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.map.layout.TopologyLayoutServer;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.DefaultGraphPainter;
import com.cisco.nm.esper.model.ui.GraphBorder;
import com.cisco.nm.esper.shape.Bounds;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;

public class ImageMaker {
    static TopologyLayoutServer _layoutServer = new TopologyLayoutServer();
    static FileOutputStream jsFile = null;
    static double shiftX = 0.0;
    static double shiftY = 0.0;

    private ImageMaker() {
    }

    protected static BufferedImage createImage(TopologyGraph graph, Color background, MapProperties mapProperties) {
        if (graph == null) {
            throw new IllegalArgumentException("Null graph");
        }
        Rectangle bounds = graph.getPaintBounds(new Transform(), null);
        if (mapProperties != null) {
            Dimension d = mapProperties.getSize();
            if (d.width != 0) {
                bounds.width = d.width;
            }
            if (d.height != 0) {
                bounds.height = d.height;
            }
            graph.setNodeLabelDisplayed(mapProperties.isNodeLabelDisplayed());
        }
        return ImageMaker.createImage(graph, new Dimension(bounds.width, bounds.height), background, mapProperties);
    }

    protected static BufferedImage createImage(TopologyGraph graph, Dimension size, Color background, MapProperties mapProperties) {
        if (mapProperties == null) {
            mapProperties = new MapProperties();
        }
        if (size == null) {
            throw new IllegalArgumentException("Null size");
        }
        if (size.width <= 0) {
            throw new IllegalArgumentException("Negative or zero width " + size.width);
        }
        if (size.height <= 0) {
            throw new IllegalArgumentException("Negative or zero height " + size.height);
        }
        if (graph == null) {
            throw new IllegalArgumentException("Null graph");
        }
        BufferedImage img = new BufferedImage(size.width, size.height, 1);
        Graphics graphics = img.getGraphics();
        graphics.setClip(0, 0, size.width, size.height);
        graphics.setColor(background);
        graphics.fillRect(0, 0, size.width, size.height);
        Transform transform = new Transform();
        Rectangle bounds = graph.getPaintBounds(transform, null);
        double graphWidth = bounds.width;
        double graphHeight = bounds.height;
        double vScale = (double)size.height / graphHeight;
        double hScale = (double)size.width / graphWidth;
        double scale = mapProperties.getZoomFactor() * (vScale < hScale ? vScale : hScale);
        transform.setScaleX(scale);
        transform.setScaleY(-scale);
        shiftX = -scale * graph.getLeft() + ((double)size.width - Math.abs(scale) * graphWidth) / 2.0;
        shiftY = scale * graph.getTop() + ((double)size.height - Math.abs(scale) * graphHeight) / 2.0;
        transform.setOffsetX(shiftX + 1.0 - (double)bounds.width * mapProperties.getOffsetX());
        transform.setOffsetY(shiftY + 1.0 - (double)bounds.height * mapProperties.getOffsetY());
        GraphBorder border = ((DefaultGraphPainter)graph.getPainter()).getExpandedPainter().getBorder();
        ((DefaultGraphPainter)graph.getPainter()).getExpandedPainter().setBorder(null);
        graph.paint(graphics, transform);
        ((DefaultGraphPainter)graph.getPainter()).getExpandedPainter().setBorder(border);
        return img;
    }

    protected static void createJPeg(TopologyGraph graph, Dimension size, Color background, OutputStream stream, MapProperties mapProperties) throws IOException {
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)stream);
        encoder.encode(ImageMaker.createImage(graph, size, background, mapProperties));
    }

    private static void createJPeg(TopologyGraph graph, Color background, OutputStream stream, MapProperties mapProperties) throws IOException {
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)stream);
        encoder.encode(ImageMaker.createImage(graph, background, mapProperties));
    }

    protected static void clearHighlight(TopologyGraph graph) {
        TopologyNode n = null;
        Iterator itr = graph.nodes().iterator();
        while (itr.hasNext()) {
            n = (TopologyNode)itr.next();
            if (n == null) continue;
            n.setHighlighted(false);
        }
        TopologyLink l = null;
        Iterator itr2 = graph.edges().iterator();
        while (itr2.hasNext()) {
            l = (TopologyLink)itr2.next();
            if (l == null) continue;
            l.setHighlighted(false);
        }
    }

    public static void createImage(String fileName, Writer jsFileStream, TopologyGraph graph) {
        File file = new File(fileName);
        file.deleteOnExit();
        MapProperties mapProperties = graph.getMapProperties();
        ImageMaker.createImage(file, jsFileStream, graph, mapProperties);
    }

    public static void createImage(File file, Writer jsFileStream, TopologyGraph graph) {
        MapProperties mapProperties = graph.getMapProperties();
        ImageMaker.createImage(file, jsFileStream, graph, mapProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createImage(File file, Writer jsFileStream, TopologyGraph graph, MapProperties mapProperties) {
        if (mapProperties == null) {
            mapProperties = new MapProperties();
        }
        if (graph == null) {
            System.err.println("ImageMaker:createImage:: NULL graph...");
            return;
        }
        ImageMaker.clearHighlight(graph);
        if (mapProperties.isLayoutRequired()) {
            try {
                Dimension d = mapProperties.getSize();
                if (d.width <= 50) {
                    d.width = 500;
                }
                if (d.height <= 50) {
                    d.height = 500;
                }
                _layoutServer.setSize(d.width, d.height);
                _layoutServer.layout(graph);
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        ImageMaker.computeGraphBounds(graph);
        mapProperties.applyFilters(graph);
        mapProperties.applyHighlighters(graph);
        if (mapProperties.isLayoutRequired()) {
            try {
                _layoutServer.layout(graph);
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        FilterOutputStream fStream = null;
        try {
            fStream = new BufferedOutputStream(new FileOutputStream(file));
            ImageMaker.createJPeg(graph, fStream, mapProperties);
            if (jsFileStream != null) {
                ImageMaker.writeImageMap(graph, jsFileStream, mapProperties);
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (fStream != null) {
                    fStream.close();
                }
            }
            catch (IOException e) {
                DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void writeImageMap(TopologyGraph graph, Writer jsFile, MapProperties mapProperties) {
        TopologyNode n = null;
        Bounds b = null;
        if (mapProperties == null) {
            mapProperties = graph.getMapProperties();
        }
        try {
            jsFile.write("<Map NAME=\"graph-map\">\n");
            Iterator itr = graph.nodes().iterator();
            while (itr.hasNext()) {
                n = (TopologyNode)itr.next();
                b = n.getIconBounds();
                jsFile.write("<AREA SHAPE=\"RECT\" COORDS=\"");
                jsFile.write("" + (int)(b.getLeft() + shiftX) + "," + (int)(shiftY - b.getTop()) + "," + (int)(b.getLeft() + shiftX + b.getWidth()) + "," + (int)(shiftY - b.getBottom()));
                jsFile.write("\" onMouseOver=\"return toolTip(event,'");
                jsFile.write(n.toString());
                jsFile.write("',1)\" onMouseOut=\"return toolTip()\" HREF=\"javascript:window.showMenu(window.devMenu);\">\n");
            }
            jsFile.write("</Map>\n");
            jsFile.flush();
        }
        catch (IOException ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void computeGraphBounds(TopologyGraph graph) {
        TopologyNode n = null;
        Iterator itr = graph.nodes().iterator();
        while (itr.hasNext()) {
            n = (TopologyNode)itr.next();
            Iterator labelIter = n.labels().iterator();
            while (labelIter.hasNext()) {
                ((NodeLabel)labelIter.next()).updateBounds();
            }
            n.updateBounds();
        }
        graph.updateBounds();
        graph.compactBounds();
    }

    public static void createJPeg(TopologyGraph graph, OutputStream stream, MapProperties mapProperties) throws IOException {
        ImageMaker.createJPeg(graph, graph.getGraphPalette().getPlainFillColor(), stream, mapProperties);
    }

    public static TopologyGraph createTestGraph() {
        TopologyGraph graph = new TopologyGraph();
        return graph;
    }
}

