/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.nm.esper.lib.FontRepository;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.model.TextDecoration;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.ExpandedGraphPainter;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class TopologyGraphPainter
extends ExpandedGraphPainter {
    public static Logger _Logger = Logger.getLogger(TopologyGraphPainter.class);
    public static final TopologyGraphPainter _Instance = new TopologyGraphPainter();
    private static final FontRepository FONT_REPOSITORY = FontRepository.INSTANCE;

    public TopologyGraphPainter() {
        super("TopologyGraphPainter");
        this.setGraphMemberFilter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintDetail(Graphics2D graphics, Graph graph, Transform transform) {
        Rectangle clip = RectPool.INSTANCE.checkRectOut();
        if (clip == null) {
            return;
        }
        graphics.getClipBounds(clip);
        if (clip != null && !clip.isEmpty()) {
            Rectangle rect = RectPool.INSTANCE.checkRectOut();
            rect = this.getBounds(graph, transform, rect);
            Object object = graph.getGraphLock();
            synchronized (object) {
                Font font;
                TextDecoration label;
                Iterator labelIter;
                Edge edge;
                if (this.getBorder() != null) {
                    this.getBorder().paint(graph, graphics, rect);
                }
                double scale = transform.getScaleX();
                Iterator edgeIter = graph.edges(1).iterator();
                while (edgeIter.hasNext()) {
                    try {
                        edge = (Edge)edgeIter.next();
                        if (!this.getGraphMemberFilter().accept(edge)) continue;
                        if (edge.intersects(clip, transform)) {
                            edge.paint(graphics, transform);
                        }
                        labelIter = edge.labels().iterator();
                        while (labelIter.hasNext()) {
                            label = (EdgeLabel)labelIter.next();
                            font = ((EdgeLabel)label).getFont();
                            if (transform.isForegroundScaled()) {
                                font = FONT_REPOSITORY.getScaleFont(font, scale);
                            }
                            label.updateTextMetrics(font == null ? null : graphics.getFontMetrics(font), scale);
                            if (!this.getGraphMemberFilter().accept(label) || !label.intersects(clip, transform)) continue;
                            label.paint(graphics, transform);
                        }
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) continue;
                        _Logger.trace((Object)"logEmptyCatch - inner-graph edges", (Throwable)ex);
                    }
                }
                Iterator nodeIter = graph.nodes().iterator();
                while (nodeIter.hasNext()) {
                    try {
                        Node node = (Node)nodeIter.next();
                        if (this.getGraphMemberFilter().accept(node) && node.intersects(clip, transform)) {
                            node.paint(graphics, transform);
                        }
                        labelIter = node.labels().iterator();
                        while (labelIter.hasNext()) {
                            label = (NodeLabel)labelIter.next();
                            font = ((NodeLabel)label).getFont();
                            if (transform.isForegroundScaled()) {
                                font = FONT_REPOSITORY.getScaleFont(font, scale);
                            }
                            label.updateTextMetrics(font == null ? null : graphics.getFontMetrics(font), scale);
                            if (!this.getGraphMemberFilter().accept(label) || !label.intersects(clip, transform)) continue;
                            label.paint(graphics, transform);
                        }
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) continue;
                        _Logger.trace((Object)"logEmptyCatch - draw nodes & labels", (Throwable)ex);
                    }
                }
                Iterator graphIter = graph.graphs().iterator();
                while (graphIter.hasNext()) {
                    try {
                        Graph subnet = (Graph)graphIter.next();
                        if (!subnet.isExpanded()) {
                            Iterator edgeIter2 = subnet.edges().iterator();
                            while (edgeIter2.hasNext()) {
                                Edge edge2 = (Edge)edgeIter2.next();
                                if (!edge2.isIntergraph() || !this.getGraphMemberFilter().accept(edge2)) continue;
                                edge2.paint(graphics, transform);
                            }
                        }
                        if (!this.getGraphMemberFilter().accept(subnet)) continue;
                        subnet.paint(graphics, transform);
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) continue;
                        _Logger.trace((Object)"logEmptyCatch - collapsed graphs", (Throwable)ex);
                    }
                }
                edgeIter = graph.edges(2).iterator();
                while (edgeIter.hasNext()) {
                    try {
                        edge = (Edge)edgeIter.next();
                        if (!this.getGraphMemberFilter().accept(edge)) continue;
                        if (edge.intersects(clip, transform)) {
                            edge.paint(graphics, transform);
                        }
                        labelIter = edge.labels().iterator();
                        while (labelIter.hasNext()) {
                            label = (EdgeLabel)labelIter.next();
                            font = ((EdgeLabel)label).getFont();
                            if (transform.isForegroundScaled()) {
                                font = FONT_REPOSITORY.getScaleFont(font, scale);
                            }
                            label.updateTextMetrics(font == null ? null : graphics.getFontMetrics(font), scale);
                            if (!this.getGraphMemberFilter().accept(label) || !label.intersects(clip, transform)) continue;
                            label.paint(graphics, transform);
                        }
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) continue;
                        _Logger.trace((Object)"logEmptyCatch - inter-graph edges", (Throwable)ex);
                    }
                }
            }
            RectPool.INSTANCE.checkRectIn(rect);
        }
        RectPool.INSTANCE.checkRectIn(clip);
    }
}

