/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.IconNodePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import org.apache.log4j.Logger;

public class TopologyNodePainter
extends IconNodePainter {
    static Color _warningColor = new Color(220, 180, 0);
    public static Logger _Logger = Logger.getLogger(TopologyNodePainter.class);

    public TopologyNodePainter() {
    }

    public TopologyNodePainter(String filename) {
        super(filename);
    }

    public TopologyNodePainter(URL url) {
        super(url);
    }

    public TopologyNodePainter(Image image) {
        super(image);
    }

    @Override
    public void init(Node n) {
        if (this.getImageWidth() == 0 || this.getImageHeight() == 0) {
            super.init(n);
        }
    }

    @Override
    public void paintLabels(Graphics graphics, Node node, Transform transform) {
        if (node == null || !node.isVisible()) {
            return;
        }
        if (((TopologyNode)node).getNodeLabel() == null) {
            return;
        }
        super.paintLabels(graphics, node, transform);
    }

    @Override
    protected void paintDetail(Graphics2D graphics, Node n, Transform transform) {
        if (n == null || !n.isVisible()) {
            return;
        }
        TopologyNode node = (TopologyNode)n;
        Rectangle rect = this.getBounds(node, transform, RectPool.INSTANCE.checkRectOut());
        if (rect.width < 4) {
            rect.width = 4;
        }
        if (rect.height < 4) {
            rect.height = 4;
        }
        if (!node.isExpanded() || node.hasAnyHiddenEndNodes()) {
            Color backgroundColor = TopologyGraph.getBackgroundColor();
            if (backgroundColor != null && backgroundColor.equals(Color.BLACK)) {
                graphics.setColor(Color.WHITE);
            } else {
                graphics.setColor(Color.BLACK);
            }
            BasicStroke bs = new BasicStroke(1.0f);
            graphics.setStroke(bs);
            graphics.drawRect(rect.x + 1, rect.y + 1, rect.width - 3, rect.height - 3);
            rect.x += 3;
            rect.y += 3;
            rect.width -= 6;
            rect.height -= 6;
        }
        if (node.isFilled()) {
            graphics.setColor(node.getFillColor());
            graphics.fillRect(rect.x, rect.y, rect.width + 1, rect.height + 1);
        }
        Image img = this.getImage(node);
        int thickness = 1;
        Rectangle rc = new Rectangle(rect);
        if (img != null) {
            int imgWdth = (int)n.getIconWidth();
            int imgHght = (int)n.getIconHeight();
            if (((TopologyGraph)node.getOwner()).supportAutoScaling()) {
                imgWdth = transform.widthToDevice(imgWdth);
                imgHght = transform.heightToDevice(imgHght);
                imgHght = imgHght * this.getImageHeight() / this.getImageWidth();
            } else {
                imgHght = transform.heightToDevice(imgHght);
                Image newImage = null;
                if (imgHght >= 64) {
                    imgWdth = 64;
                    imgHght = 64;
                    newImage = node.getKubricIconImage("64");
                    this.setImage(newImage);
                    img = this.getImage(node);
                    img = newImage;
                } else if (imgHght >= 24) {
                    imgWdth = 24;
                    imgHght = 24;
                    newImage = node.getKubricIconImage("24");
                    this.setImage(newImage);
                    img = this.getImage(node);
                    img = newImage;
                } else if (imgHght >= 16) {
                    imgWdth = 16;
                    imgHght = 16;
                    newImage = node.getKubricIconImage("16");
                    this.setImage(newImage);
                    img = this.getImage(node);
                    img = newImage;
                } else {
                    imgWdth = transform.widthToDevice(imgWdth);
                    imgHght = imgHght * this.getImageHeight() / this.getImageWidth();
                }
            }
            if (node.isHighlighted()) {
                graphics.setColor(node.getHighlightColor());
                graphics.fillRect(rc.x, rc.y, rc.width + 1, rc.height + 1);
                rc.x += 2;
                rc.y += 2;
                rc.width -= 4;
                rc.height -= 4;
            }
            graphics.drawImage(img, rect.x + (rect.width - imgWdth) / 2, rect.y + (rect.height - imgHght) / 2, imgWdth, imgHght, this);
        }
        if (!node.isPresent()) {
            BasicStroke bs = new BasicStroke(2.0f);
            graphics.setStroke(bs);
            if (node.isDimmed()) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.red);
            }
            graphics.drawLine(rect.x + 2, rect.y + 2, rect.x + rect.width - 5, rect.y + rect.height - 5);
            graphics.drawLine(rect.x + rect.width - 5, rect.y + 2, rect.x + 2, rect.y + rect.height - 5);
            bs = new BasicStroke(1.0f);
            graphics.setStroke(bs);
        } else if (!node.isManageable()) {
            BasicStroke bs = new BasicStroke(2.0f);
            graphics.setStroke(bs);
            if (node.isDimmed()) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.red);
            }
            graphics.drawLine(rect.x + 1, rect.y + 1, rect.x + rect.width - 2, rect.y + rect.height - 2);
            bs = new BasicStroke(1.0f);
            graphics.setStroke(bs);
        } else if (node.hasMinorFault() && node.markMinorFault()) {
            try {
                thickness = transform.isForegroundScaled() ? Math.min(6, Math.max(2, transform.widthToDevice(3.0))) : 3;
                float[] pattern = new float[]{(float)thickness * 1.5f, thickness};
                BasicStroke bs = new BasicStroke(2.0f, 0, 0, 1.0f, pattern, 0.0f);
                graphics.setStroke(bs);
                if (node.isDimmed()) {
                    graphics.setColor(Color.lightGray);
                } else {
                    graphics.setColor(TopologyLink._MinorFaultColor);
                }
                graphics.drawLine(rect.x + 2, rect.y + 2, rect.x + rect.width - 5, rect.y + rect.height - 5);
                graphics.drawLine(rect.x + rect.width - 5, rect.y + 2, rect.x + 2, rect.y + rect.height - 5);
                bs = new BasicStroke(1.0f);
                graphics.setStroke(bs);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        int n2 = thickness = transform.isForegroundScaled() ? Math.max(1, transform.widthToDevice(node.getStrokeWidth())) : node.getStrokeWidth();
        if (node.isSelected()) {
            int vs = Math.min(rect.height / 2, Math.max(thickness + thickness / 3, rect.height / 5));
            int hs = Math.min(rect.width / 2, Math.max(thickness + thickness / 3, rect.width / 5));
            graphics.setColor(node.getCornerColor());
            rect.width = rect.x + rect.width;
            rect.height = rect.y + rect.height;
            graphics.fillRect(rect.x, rect.y, hs, thickness);
            graphics.fillRect(rect.x, rect.y + thickness, thickness, vs - thickness);
            graphics.fillRect(rect.width - hs + 1, rect.y, hs, thickness);
            graphics.fillRect(rect.width - thickness + 1, rect.y + thickness, thickness, vs - thickness);
            graphics.fillRect(rect.x, rect.height - thickness + 1, hs, thickness);
            graphics.fillRect(rect.x, rect.height - vs + 1, thickness, vs - thickness);
            graphics.fillRect(rect.width - hs + 1, rect.height - thickness + 1, hs, thickness);
            graphics.fillRect(rect.width - thickness + 1, rect.height - vs + 1, thickness, vs - thickness);
        }
        RectPool.INSTANCE.checkRectIn(rect);
    }

    @Override
    public boolean intersects(Node node, Rectangle rect, Transform transform) {
        boolean isects = false;
        if (rect != null && rect.width > 0 && rect.height > 0) {
            Rectangle bounds = this.getBounds(node, transform, null);
            isects = bounds.x > -bounds.width && bounds.y > -bounds.height && bounds.x <= rect.x + rect.width && bounds.x + bounds.width >= rect.x && bounds.y <= rect.y + rect.height && bounds.y + bounds.height >= rect.y;
        }
        return isects;
    }

    @Override
    public Rectangle getBounds(Node n, Transform transform, Rectangle rect) {
        TopologyNode node = (TopologyNode)n;
        if (rect == null) {
            rect = new Rectangle();
        }
        if (n == null || node._destroyed || !n.isVisible()) {
            rect.height = 0;
            rect.width = 0;
            rect.y = 0;
            rect.x = 0;
            return rect;
        }
        int nHL = 1;
        if (this.getImage(node) == null) {
            super.getBounds(node, transform, rect);
        } else {
            rect.width = (int)n.getIconWidth();
            rect.height = this.getImageWidth() != 0 ? (int)n.getIconHeight() * this.getImageHeight() / this.getImageWidth() : (int)n.getIconHeight();
            if (transform.getScaleID() != 0 && transform.isForegroundScaled()) {
                rect.width = transform.widthToDevice(rect.width);
                rect.height = transform.heightToDevice(rect.height);
            }
            rect.x = transform.xToDevice(node.getIconCenterX()) - rect.width / 2;
            rect.y = transform.yToDevice(node.getIconCenterY()) - rect.height / 2;
        }
        rect.x -= 2 * nHL;
        rect.y -= 2 * nHL;
        rect.width += 4 * nHL;
        rect.height += 4 * nHL;
        if (!node.isExpanded() || node.hasAnyHiddenEndNodes()) {
            rect.x -= 3;
            rect.y -= 3;
            rect.width += 6;
            rect.height += 6;
        }
        return rect;
    }
}

