/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.layout;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.layout.TopologyLayoutServer;
import com.cisco.nm.esper.action.GraphComponentAction;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.shape.Bounds;
import com.cisco.nm.esper.shape.BoundsDouble;
import java.awt.event.ActionEvent;

public class LxTopoLayoutAction
extends GraphComponentAction {
    public static final String REPEAT_LAYOUT_ACTION = "relayout";
    private TopologyLayoutServer _layoutServer = null;
    private String style = "Spring";

    @Override
    public boolean isAbleToHandle(ActionEvent event) {
        return event != null;
    }

    @Override
    protected void execute(ActionEvent event) throws Exception {
        this.doLayout(REPEAT_LAYOUT_ACTION);
    }

    public void doLayout() throws Exception {
        this.doLayout(REPEAT_LAYOUT_ACTION);
    }

    public void doLayout(String styleName) throws Exception {
        TopologyGraph graph;
        if (this.getGraphComponent() != null && this.getLayoutServer() != null && (graph = (TopologyGraph)this.getActiveGraph()) != null) {
            graph.setGraphNodesAtZero();
            BoundsDouble viewBounds = new BoundsDouble(this.getGraphComponent().getViewBounds());
            this._layoutServer.setSize(this.getGraphComponent().getWidth(), this.getGraphComponent().getHeight());
            Graph g = null;
            this._layoutServer.layout(graph);
            if (g != null && g != graph) {
                this.getGraphComponent().setGraph(g, true);
                graph = g;
            }
            this.style = this.style;
            this.getGraphComponent().clearCommandStack();
            Bounds graphBounds = graph.getBounds();
            if (viewBounds.contains(graphBounds) && (graphBounds.getWidth() > 0.9 * viewBounds.getWidth() || graphBounds.getHeight() > 0.9 * viewBounds.getHeight())) {
                this.getGraphComponent().centerInWindow(true);
            } else {
                this.getGraphComponent().fitInWindow(true);
            }
            this.getGraphComponent().asContainer().repaint();
        }
    }

    public void setLayoutServer(TopologyLayoutServer layoutServer) {
        this._layoutServer = layoutServer;
    }

    public TopologyLayoutServer getLayoutServer() {
        return this._layoutServer;
    }

    public String getRecentLayoutStyle() {
        return this.style;
    }
}

