/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.CommonRoleFeature;
import com.cisco.dcbu.lib.mds.CommonRoleFeatureRule;
import com.cisco.dcbu.lib.mds.CommonRoleFeatureRuleRaw;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.mds.commonRoleHash;
import com.cisco.dcbu.lib.mds.enableAll;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class CommonRoleUtil {
    static CommonRoleUtil _instance;
    public static final int FEATURE_COL = 0;
    public static final int CLEAR = 1;
    public static final int CONFIG = 2;
    public static final int DEBUG = 3;
    public static final int SHOW = 4;
    public static final int EXEC = 5;
    public static final int OPERATION_ALLOWED_COL = 7;
    public static final int OPERATION_PERMIT_COL = 8;
    public static final int RULE_INDEX_COL = 9;
    public static final int TOTAL_COLUMNS = 10;
    public static final int OPERATION_START_COL = 1;
    public static final int OPERATION_END_COL = 5;
    public static final int TOTAL_OPERATIONS = 6;
    public static final int OPERATION_COLUMN_OFFSET = 1;
    static final int OPERATION_CONFIG = 2;
    static final int OPERATION_SHOW = 4;
    static final int OPERATION_EXEC = 5;
    static final int GRAND = 1;
    static final int DENY = 2;
    static final String[] OPER_STRING;
    static final String[] _defaultNMSFeatures;
    final int[] _insertRoleVarOid = MibNode.get("commonRoleRowStatus").getOid();
    final int[][] _roleVarVblOid = new int[][]{MibNode.get("commonRoleDescription").getOid(), MibNode.get("commonRoleScopeRestriction").getOid(), MibNode.get("commonRoleScope1").getOid()};
    final int[] _insertVarOid = MibNode.get("commonRoleRuleRowStatus").getOid();
    final int[][] _varVblOid = new int[][]{MibNode.get("commonRoleRuleFeatureName").getOid(), MibNode.get("commonRoleRuleOperation").getOid(), MibNode.get("commonRoleRuleOperPermitted").getOid()};
    final SnmpInt _CREATEANDGO = new SnmpInt(4);
    final SnmpInt _DELETE = new SnmpInt(6);

    public static CommonRoleUtil getInstance() {
        if (_instance == null) {
            _instance = new CommonRoleUtil();
        }
        return _instance;
    }

    public long getMaxRulePerRole(SnmpPeer peer, long maxRulePerRole) {
        if (maxRulePerRole == 0L) {
            maxRulePerRole = this.getMaxRulePerRoleNum(peer);
        }
        return maxRulePerRole;
    }

    long getMaxRulePerRoleNum(SnmpPeer peer) {
        long maxNum;
        block2: {
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
            int[] index = new int[]{0};
            pdu.addVar(new SnmpOID(MibNode.get("commonRoleMaxRulesPerRole").getOid(), index));
            maxNum = 0L;
            try {
                SnmpPDU resp = peer.send(pdu);
                SnmpVar vb = resp.getVariables().get(0).getVar();
                maxNum = ((SnmpGauge)vb).getValue();
            }
            catch (SnmpException ex) {
                if (!SnmpSession.isTrace()) break block2;
                ex.printStackTrace();
            }
        }
        return maxNum;
    }

    public HashMap getFeatureHash(SnmpPeer peer, HashMap features) {
        if (features == null || features.size() == 0) {
            features = this.getFeatureTable(peer);
        }
        return features;
    }

    public CommonRoleFeature getFeatureData(SnmpPeer peer, HashMap features) {
        if (features == null || features.size() == 0) {
            features = this.getFeatureTable(peer);
        }
        return new CommonRoleFeature(0, this.constructFeatureData(features, true));
    }

    public CommonRoleFeature getRuleData(SnmpPeer peer, String roleName, HashMap features) {
        if (features == null || features.size() == 0) {
            features = this.getFeatureTable(peer);
        } else {
            for (Object name : features.keySet()) {
                CommonRoleFeatureRule feature = (CommonRoleFeatureRule)features.get(name);
                feature._operationSelected = new int[6];
                feature._permits = new int[6];
                feature._ruleIndex = new int[6];
            }
        }
        commonRoleHash ruleData = this.getRuleTable(peer, roleName);
        HashMap rules = ruleData.getHashMap();
        for (Object name : rules.keySet()) {
            int i;
            CommonRoleFeatureRule rule = (CommonRoleFeatureRule)rules.get(name);
            int[] selectedOperations = rule.getOperations();
            int[] permits = rule.getPermits();
            int[] ruleIndex = rule.getRuleIndex();
            if (((String)name).equals("")) {
                for (int i2 = 0; i2 < selectedOperations.length; ++i2) {
                    if (selectedOperations[i2] != 1 || permits[i2] != 1) continue;
                    for (Object nameF : features.keySet()) {
                        CommonRoleFeatureRule feature = (CommonRoleFeatureRule)features.get(nameF);
                        if (feature.getOperations()[i2] != 1) continue;
                        feature.setOperationSelected(i2);
                        if (feature.getPermits()[i2] != 0) continue;
                        feature.setPermit(i2, 1);
                    }
                }
                continue;
            }
            CommonRoleFeatureRule feature = (CommonRoleFeatureRule)features.get(name);
            for (i = 0; i < selectedOperations.length; ++i) {
                if (selectedOperations[i] != 1) continue;
                feature.setOperationSelected(i);
            }
            for (i = 0; i < 6; ++i) {
                if (permits[i] == 0) continue;
                feature.setPermit(i, permits[i]);
            }
            feature._ruleIndex = ruleIndex;
        }
        return new CommonRoleFeature(ruleData.getLastRuleIndex(), this.constructFeatureData(features, false));
    }

    public Array constructFeatureData(HashMap features, boolean isNew) {
        Array<Object[]> featureData = new Array<Object[]>();
        Set set = features.keySet();
        Object[] keys = new Object[set.size()];
        set.toArray(keys);
        List<Object> tmpkeyList = Arrays.asList(keys);
        Collections.sort(tmpkeyList);
        for (Object name : tmpkeyList) {
            CommonRoleFeatureRule feature = (CommonRoleFeatureRule)features.get(name);
            Object[] row = new Object[10];
            row[0] = feature.getName();
            int i = 1;
            int j = 1;
            while (i <= 5) {
                row[i] = isNew ? Boolean.FALSE : (feature._operationSelected[j] == 1 && feature._permits[j] == 1 ? Boolean.TRUE : Boolean.FALSE);
                ++i;
                ++j;
            }
            row[7] = feature.getOperations();
            row[8] = feature.getPermits();
            row[9] = feature.getRuleIndex();
            featureData.addElement(row);
        }
        return featureData;
    }

    HashMap getFeatureTable(SnmpPeer peer) {
        HashMap<String, CommonRoleFeatureRule> features;
        block6: {
            features = new HashMap<String, CommonRoleFeatureRule>();
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("commonRoleFeatureName").getOid())));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("commonRoleFeatureOperation").getOid())));
            try {
                SnmpPDU resp = SnmpFetch.getBulk(peer, vbl);
                vbl = resp.getVariables();
                for (int i = 0; i < vbl.size(); i += 2) {
                    String name = ((SnmpString)vbl.get(i).getVar()).toString();
                    int oper = ((SnmpInt)vbl.get(i + 1).getVar()).getValue();
                    CommonRoleFeatureRule feature = (CommonRoleFeatureRule)features.remove(name);
                    if (feature != null) {
                        if (oper < 6) {
                            feature.setOperation(oper);
                        }
                    } else {
                        SnmpString operations = new SnmpString(new byte[1]);
                        SnmpString.setBit(operations.getValue(), oper);
                        feature = new CommonRoleFeatureRule(name, new int[6], operations, new SnmpString(new byte[1]), new int[6]);
                    }
                    features.put(name, feature);
                }
            }
            catch (SnmpException ex) {
                if (!SnmpSession.isTrace()) break block6;
                ex.printStackTrace();
            }
        }
        return features;
    }

    Array<CommonRoleFeatureRuleRaw> findExistingRules(SnmpPeer peer, String roleName) {
        Array<CommonRoleFeatureRuleRaw> rules;
        block4: {
            rules = new Array<CommonRoleFeatureRuleRaw>();
            byte[] b = roleName.getBytes();
            int[] index = new int[b.length + 1];
            index[0] = b.length;
            for (int j = 0; j < b.length; ++j) {
                index[j + 1] = b[j] & 0xFF;
            }
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("commonRoleRuleFeatureName").getOid(), index)));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("commonRoleRuleOperation").getOid(), index)));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("commonRoleRuleOperPermitted").getOid(), index)));
            try {
                SnmpPDU resp = SnmpFetch.getBulk(peer, vbl);
                vbl = resp.getVariables();
                for (int i = 0; i < vbl.size(); i += 3) {
                    int[] oid = vbl.get(i).getOid().getValue();
                    int ruleIndex = oid[oid.length - 1];
                    String name = ((SnmpString)vbl.get(i).getVar()).toString();
                    int oper = ((SnmpInt)vbl.get(i + 1).getVar()).getValue();
                    int permit = ((SnmpInt)vbl.get(i + 2).getVar()).getValue();
                    CommonRoleFeatureRuleRaw rule = new CommonRoleFeatureRuleRaw(ruleIndex, name, oper, permit);
                    rules.addElement(rule);
                }
            }
            catch (SnmpException ex) {
                if (!SnmpSession.isTrace()) break block4;
                ex.printStackTrace();
            }
        }
        return rules;
    }

    commonRoleHash getRuleTable(SnmpPeer peer, String roleName) {
        int ruleIndex;
        HashMap<String, CommonRoleFeatureRule> rules;
        block6: {
            rules = new HashMap<String, CommonRoleFeatureRule>();
            ruleIndex = 0;
            byte[] b = roleName.getBytes();
            int[] index = new int[b.length + 1];
            index[0] = b.length;
            for (int j = 0; j < b.length; ++j) {
                index[j + 1] = b[j] & 0xFF;
            }
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("commonRoleRuleFeatureName").getOid(), index)));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("commonRoleRuleOperation").getOid(), index)));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("commonRoleRuleOperPermitted").getOid(), index)));
            try {
                SnmpPDU resp = SnmpFetch.getBulk(peer, vbl);
                vbl = resp.getVariables();
                for (int i = 0; i < vbl.size(); i += 3) {
                    int[] oid = vbl.get(i).getOid().getValue();
                    ruleIndex = oid[oid.length - 1];
                    String name = ((SnmpString)vbl.get(i).getVar()).toString();
                    int oper = ((SnmpInt)vbl.get(i + 1).getVar()).getValue();
                    int permit = ((SnmpInt)vbl.get(i + 2).getVar()).getValue();
                    CommonRoleFeatureRule rule = (CommonRoleFeatureRule)rules.remove(name);
                    if (rule != null) {
                        rule.setOperation(oper);
                        rule.setOperationSelected(oper);
                        rule.setPermit(oper, permit);
                        rule.setRuleIndex(oper, ruleIndex);
                    } else {
                        SnmpString operations = new SnmpString(new byte[1]);
                        int[] permits = new int[6];
                        int[] ruleIndeces = new int[6];
                        SnmpString.setBit(operations.getValue(), oper);
                        permits[oper] = permit;
                        ruleIndeces[oper] = ruleIndex;
                        rule = new CommonRoleFeatureRule(name, ruleIndeces, operations, operations, permits);
                    }
                    rules.put(name, rule);
                }
            }
            catch (SnmpException ex) {
                if (!SnmpSession.isTrace()) break block6;
                ex.printStackTrace();
            }
        }
        return new commonRoleHash(ruleIndex, rules);
    }

    public boolean getNewRolePDU(Array pduList, Array rollbackPduList, int[] index, String roleName, SnmpString description, SnmpInt isVsan, SnmpBitmap scope, Array rules, long maxRules, SwitchVersion version) {
        boolean isExceedMaxRules = false;
        if (pduList.size() == 0) {
            pduList.addElement(new SnmpPDU(-93, new VarBindList()));
        }
        SnmpPDU pdu = (SnmpPDU)pduList.elementAt(pduList.size() - 1);
        if (index == null) {
            byte[] b = roleName.getBytes();
            index = new int[b.length + 1];
            index[0] = b.length;
            for (int j = 0; j < b.length; ++j) {
                index[j + 1] = b[j] & 0xFF;
            }
        }
        pdu.addVar(new SnmpOID(this._insertRoleVarOid, index), this._CREATEANDGO);
        pdu.addVar(new SnmpOID(this._roleVarVblOid[0], index), description);
        pdu.addVar(new SnmpOID(this._roleVarVblOid[1], index), isVsan);
        SnmpOID scopeOid = new SnmpOID(this._roleVarVblOid[2], index);
        if (scope != null) {
            pdu.addVar(new SnmpVarBind(scopeOid, scope));
            PortInterfaceUtil.getInstance(4).addVsan4k2Pdu(pdu, scopeOid, pdu.getVariables().get(3).getVar(), index);
        }
        if (rules != null && rules.size() > 0) {
            pduList.addElement(new SnmpPDU(-93, new VarBindList()));
            isExceedMaxRules = this.getRulePDU(pduList, rollbackPduList, index, roleName, rules, maxRules, version);
        } else {
            int[] idx = new int[index.length + 1];
            System.arraycopy(index, 0, idx, 0, index.length);
            if (version.lessThan(new SwitchVersion("2.1(0)"))) {
                this.getNMSDefFeaturesPDU(pduList, rollbackPduList, null, idx, 1);
            }
        }
        return isExceedMaxRules;
    }

    public boolean isPermitShowInterfaceRuleExist(Array rules) {
        if (rules == null) {
            return false;
        }
        for (int i = 0; i < rules.size(); ++i) {
            Object[] row = (Object[])rules.elementAt(i);
            String feature = (String)row[0];
            if (!feature.equals("interface")) continue;
            return (Boolean)row[4];
        }
        return false;
    }

    public boolean getRulePDU(Array pduList, Array rollbackPduList, int[] index, String roleName, Array rules, long maxRules, SwitchVersion version) {
        int nextRuleIndex = 1;
        if (index == null) {
            byte[] b = roleName.getBytes();
            index = new int[b.length + 2];
            index[0] = b.length;
            for (int j = 0; j < b.length; ++j) {
                index[j + 1] = b[j] & 0xFF;
            }
        } else {
            int[] idx = new int[index.length + 1];
            System.arraycopy(index, 0, idx, 0, index.length);
            index = idx;
        }
        enableAll[] isEnableAllApply = this.checkEnableAllApply(rules);
        nextRuleIndex = this.getEnableAllPDU(pduList, rollbackPduList, rules, isEnableAllApply, index, nextRuleIndex, version);
        if ((long)nextRuleIndex > maxRules + 1L) {
            return true;
        }
        if (version.lessThan(new SwitchVersion("2.1(0)"))) {
            nextRuleIndex = this.getNMSDefFeaturesPDU(pduList, rollbackPduList, isEnableAllApply, index, nextRuleIndex);
        }
        if (pduList.size() == 0) {
            pduList.addElement(new SnmpPDU(-93, new VarBindList()));
        }
        SnmpPDU pdu = (SnmpPDU)pduList.elementAt(pduList.size() - 1);
        SnmpPDU rollbackPdu = (SnmpPDU)rollbackPduList.elementAt(rollbackPduList.size() - 1);
        int vNo = pdu.getVariables().size();
        for (int i = 0; i < rules.size(); ++i) {
            Object[] row = (Object[])rules.elementAt(i);
            String feature = (String)row[0];
            int[] operations = new int[6];
            int j = 1;
            for (int k = 1; k <= 5; ++k) {
                operations[j] = (Boolean)row[k] != false ? 1 : 0;
                ++j;
            }
            for (j = 1; j < operations.length; ++j) {
                if (operations[j] == 0 || isEnableAllApply[j].getIsEnableAll() || version.lessThan(new SwitchVersion("2.1(0)")) && this.isDefaultNMSFeature(j, feature)) continue;
                if (vNo >= SnmpFetch._Max - 5) {
                    pdu = new SnmpPDU(-93, new VarBindList());
                    pduList.addElement(pdu);
                    rollbackPdu = new SnmpPDU(-93, new VarBindList());
                    rollbackPduList.addElement(rollbackPdu);
                    vNo = 4;
                } else {
                    vNo += 4;
                }
                index[index.length - 1] = nextRuleIndex++;
                pdu.addVar(new SnmpOID(this._insertVarOid, index), this._CREATEANDGO);
                pdu.addVar(new SnmpOID(this._varVblOid[0], index), new SnmpString(feature));
                pdu.addVar(new SnmpOID(this._varVblOid[1], index), new SnmpInt(j));
                pdu.addVar(new SnmpOID(this._varVblOid[2], index), new SnmpInt(1));
                rollbackPdu.addVar(new SnmpOID(this._insertVarOid, index), this._DELETE);
                if ((long)nextRuleIndex <= maxRules + 1L) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getSetRulePDU(Array pduList, Array rollbackPduList, SnmpPeer peer, SnmpPDU pdu, String roleName, CommonRoleFeature rulesTable, long maxRules, SwitchVersion version) {
        int i;
        Array rulesData = rulesTable.getData();
        Array<CommonRoleFeatureRuleRaw> existingRules = this.findExistingRules(peer, roleName);
        Array deletePduList = new Array();
        Array deleteRollbackPduList = new Array();
        this.deleteOldRules(deletePduList, roleName, existingRules, deleteRollbackPduList);
        boolean isExceedMaxRules = this.getRulePDU(pduList, rollbackPduList, null, roleName, rulesData, maxRules, version);
        for (i = deletePduList.size() - 1; i >= 0; --i) {
            pduList.insertElementAt(deletePduList.elementAt(i), 0);
        }
        for (i = deleteRollbackPduList.size() - 1; i >= 0; --i) {
            rollbackPduList.insertElementAt(deleteRollbackPduList.elementAt(i), 0);
        }
        return isExceedMaxRules;
    }

    enableAll[] checkEnableAllApply(Array rulesData) {
        enableAll[] isApply = new enableAll[6];
        int col = 1;
        for (int oper = 1; oper < isApply.length; ++oper) {
            int unChecked = 0;
            int checked = 0;
            Array<Integer> unCheckedCells = new Array<Integer>();
            for (int row = 0; row < rulesData.size(); ++row) {
                boolean isSelected = (Boolean)((Object[])rulesData.elementAt(row))[col];
                if (isSelected) {
                    ++checked;
                    continue;
                }
                if (((int[])((Object[])rulesData.elementAt(row))[7])[oper] != 1) continue;
                ++unChecked;
                unCheckedCells.addElement(new Integer(row));
            }
            isApply[oper] = new enableAll(checked > unChecked, unCheckedCells);
            ++col;
        }
        return isApply;
    }

    int getEnableAllPDU(Array pduList, Array rollbackPduList, Array rulesData, enableAll[] isEnableAllApply, int[] index, int nextRuleIndex, SwitchVersion version) {
        int oper;
        if (pduList.size() == 0) {
            pduList.addElement(new SnmpPDU(-93, new VarBindList()));
        }
        if (rollbackPduList.size() == 0) {
            rollbackPduList.addElement(new SnmpPDU(-93, new VarBindList()));
        }
        SnmpPDU pdu = (SnmpPDU)pduList.elementAt(pduList.size() - 1);
        SnmpPDU rollbackPdu = (SnmpPDU)rollbackPduList.elementAt(rollbackPduList.size() - 1);
        int vNo = pdu.getVariables().size();
        for (oper = 1; oper < isEnableAllApply.length; ++oper) {
            if (!isEnableAllApply[oper].getIsEnableAll()) continue;
            if (vNo >= SnmpFetch._Max - 5) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pduList.addElement(pdu);
                rollbackPdu = new SnmpPDU(-93, new VarBindList());
                rollbackPduList.addElement(rollbackPdu);
                vNo = 4;
            } else {
                vNo += 4;
            }
            index[index.length - 1] = nextRuleIndex++;
            pdu.addVar(new SnmpOID(this._insertVarOid, index), this._CREATEANDGO);
            pdu.addVar(new SnmpOID(this._varVblOid[0], index), new SnmpString(""));
            pdu.addVar(new SnmpOID(this._varVblOid[1], index), new SnmpInt(oper));
            pdu.addVar(new SnmpOID(this._varVblOid[2], index), new SnmpInt(1));
            rollbackPdu.addVar(new SnmpOID(this._insertVarOid, index), this._DELETE);
        }
        for (oper = 1; oper < isEnableAllApply.length; ++oper) {
            if (!isEnableAllApply[oper].getIsEnableAll()) continue;
            for (int i = 0; i < isEnableAllApply[oper].getUnCheckedCells().size(); ++i) {
                int row = (Integer)isEnableAllApply[oper].getUnCheckedCells().elementAt(i);
                String feature = (String)((Object[])rulesData.elementAt(row))[0];
                if (version.lessThan(new SwitchVersion("2.1(0)")) && this.isDefaultNMSFeature(oper, feature)) continue;
                if (vNo >= SnmpFetch._Max - 5) {
                    pdu = new SnmpPDU(-93, new VarBindList());
                    pduList.addElement(pdu);
                    rollbackPdu = new SnmpPDU(-93, new VarBindList());
                    rollbackPduList.addElement(rollbackPdu);
                    vNo = 4;
                } else {
                    vNo += 4;
                }
                index[index.length - 1] = nextRuleIndex++;
                pdu.addVar(new SnmpOID(this._insertVarOid, index), this._CREATEANDGO);
                pdu.addVar(new SnmpOID(this._varVblOid[0], index), new SnmpString(feature));
                pdu.addVar(new SnmpOID(this._varVblOid[1], index), new SnmpInt(oper));
                pdu.addVar(new SnmpOID(this._varVblOid[2], index), new SnmpInt(2));
                rollbackPdu.addVar(new SnmpOID(this._insertVarOid, index), this._DELETE);
            }
        }
        return nextRuleIndex;
    }

    int getNMSDefFeaturesPDU(Array pduList, Array rollbackPduList, enableAll[] isEnableAllApply, int[] index, int nextRuleIndex) {
        if (isEnableAllApply != null) {
            for (int oper = 1; oper < isEnableAllApply.length; ++oper) {
                if (!isEnableAllApply[oper].getIsEnableAll() || oper != 4) continue;
                return nextRuleIndex;
            }
        }
        nextRuleIndex = this.setupDefaultRulePDU(pduList, rollbackPduList, index, nextRuleIndex);
        return nextRuleIndex;
    }

    public int setupDefaultRulePDU(Array pduList, Array rollbackPduList, int[] index, int nextRuleIndex) {
        if (pduList.size() == 0) {
            pduList.addElement(new SnmpPDU(-93, new VarBindList()));
        }
        if (rollbackPduList.size() == 0) {
            rollbackPduList.addElement(new SnmpPDU(-93, new VarBindList()));
        }
        SnmpPDU pdu = (SnmpPDU)pduList.elementAt(pduList.size() - 1);
        SnmpPDU rollbackPdu = (SnmpPDU)rollbackPduList.elementAt(rollbackPduList.size() - 1);
        int vNo = pdu.getVariables().size();
        for (int i = 0; i < _defaultNMSFeatures.length; ++i) {
            if (vNo >= SnmpFetch._Max - 5) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pduList.addElement(pdu);
                rollbackPdu = new SnmpPDU(-93, new VarBindList());
                rollbackPduList.addElement(rollbackPdu);
                vNo = 4;
            } else {
                vNo += 4;
            }
            index[index.length - 1] = nextRuleIndex++;
            pdu.addVar(new SnmpOID(this._insertVarOid, index), this._CREATEANDGO);
            pdu.addVar(new SnmpOID(this._varVblOid[0], index), new SnmpString(_defaultNMSFeatures[i]));
            pdu.addVar(new SnmpOID(this._varVblOid[1], index), new SnmpInt(4));
            pdu.addVar(new SnmpOID(this._varVblOid[2], index), new SnmpInt(1));
            rollbackPdu.addVar(new SnmpOID(this._insertVarOid, index), this._DELETE);
        }
        return nextRuleIndex;
    }

    public void createDefaultRule(SnmpPDU pdu, int[] index, int nextRuleIndex, boolean bRW) {
        index[index.length - 1] = nextRuleIndex++;
        pdu.addVar(new SnmpOID(this._insertVarOid, index), this._CREATEANDGO);
        pdu.addVar(new SnmpOID(this._varVblOid[0], index), new SnmpString(""));
        pdu.addVar(new SnmpOID(this._varVblOid[1], index), new SnmpInt(4));
        pdu.addVar(new SnmpOID(this._varVblOid[2], index), new SnmpInt(1));
        if (bRW) {
            index[index.length - 1] = nextRuleIndex++;
            pdu.addVar(new SnmpOID(this._insertVarOid, index), this._CREATEANDGO);
            pdu.addVar(new SnmpOID(this._varVblOid[0], index), new SnmpString(""));
            pdu.addVar(new SnmpOID(this._varVblOid[1], index), new SnmpInt(2));
            pdu.addVar(new SnmpOID(this._varVblOid[2], index), new SnmpInt(1));
            index[index.length - 1] = nextRuleIndex++;
            pdu.addVar(new SnmpOID(this._insertVarOid, index), this._CREATEANDGO);
            pdu.addVar(new SnmpOID(this._varVblOid[0], index), new SnmpString(""));
            pdu.addVar(new SnmpOID(this._varVblOid[1], index), new SnmpInt(5));
            pdu.addVar(new SnmpOID(this._varVblOid[2], index), new SnmpInt(1));
        }
    }

    public StringBuffer getSummary(Array rules, SwitchVersion version) {
        int oper;
        StringBuffer sb = new StringBuffer();
        int ruleNo = 0;
        enableAll[] isEnableAllApply = this.checkEnableAllApply(rules);
        for (oper = 1; oper < isEnableAllApply.length; ++oper) {
            if (!isEnableAllApply[oper].getIsEnableAll()) continue;
            if (++ruleNo == 1) {
                sb.append("========================================\n");
                sb.append("Rule\tType\tOperation\tFeature\n");
                sb.append("========================================\n");
            }
            sb.append(ruleNo + ".\tpermit\t" + OPER_STRING[oper] + "\t*\n");
        }
        for (oper = 1; oper < isEnableAllApply.length; ++oper) {
            if (!isEnableAllApply[oper].getIsEnableAll()) continue;
            if (ruleNo == 1) {
                sb.append("========================================\n");
                sb.append("Rule\tType\tOperation\tFeature\n");
                sb.append("========================================\n");
            }
            for (int i = 0; i < isEnableAllApply[oper].getUnCheckedCells().size(); ++i) {
                int row = (Integer)isEnableAllApply[oper].getUnCheckedCells().elementAt(i);
                String feature = (String)((Object[])rules.elementAt(row))[0];
                if (version.lessThan(new SwitchVersion("2.1(0)")) && this.isDefaultNMSFeature(oper, feature)) continue;
                sb.append(++ruleNo + ".\tdeny\t" + OPER_STRING[oper] + "\t" + feature + "\n");
            }
        }
        for (int i = 0; i < rules.size(); ++i) {
            Object[] row = (Object[])rules.elementAt(i);
            String feature = (String)row[0];
            int[] operations = new int[6];
            int j = 1;
            for (int k = 1; k <= 5; ++k) {
                operations[j] = (Boolean)row[k] != false ? 1 : 0;
                ++j;
            }
            for (j = 1; j < operations.length; ++j) {
                if (operations[j] == 0 || isEnableAllApply[j].getIsEnableAll()) continue;
                if (++ruleNo == 1) {
                    sb.append("========================================\n");
                    sb.append("Rule\tType\tOperation\tFeature\n");
                    sb.append("========================================\n");
                }
                sb.append(ruleNo + ".\tpermit\t" + OPER_STRING[j] + "\t" + feature + "\n");
            }
        }
        return sb;
    }

    boolean isDefaultNMSFeature(int oper, String feature) {
        if (oper == 4) {
            for (int i = 0; i < _defaultNMSFeatures.length; ++i) {
                if (!feature.equals(_defaultNMSFeatures[i])) continue;
                return true;
            }
        }
        return false;
    }

    void deleteOldRules(Array pduList, String roleName, Array<CommonRoleFeatureRuleRaw> existingRules, Array rollbackPduList) {
        if (pduList.size() == 0) {
            pduList.addElement(new SnmpPDU(-93, new VarBindList()));
        }
        if (rollbackPduList.size() == 0) {
            rollbackPduList.addElement(new SnmpPDU(-93, new VarBindList()));
        }
        SnmpPDU pdu = (SnmpPDU)pduList.elementAt(pduList.size() - 1);
        SnmpPDU rollbackPdu = (SnmpPDU)rollbackPduList.elementAt(rollbackPduList.size() - 1);
        int vNo = 0;
        byte[] b = roleName.getBytes();
        int[] index = new int[b.length + 2];
        index[0] = b.length;
        for (int j = 0; j < b.length; ++j) {
            index[j + 1] = b[j] & 0xFF;
        }
        for (int i = 0; i < existingRules.size(); ++i) {
            vNo = pdu.getVariables().size();
            if (vNo >= SnmpFetch._Max - 2) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pduList.addElement(pdu);
                rollbackPdu = new SnmpPDU(-93, new VarBindList());
                rollbackPduList.addElement(rollbackPdu);
                vNo = 1;
            } else {
                ++vNo;
            }
            CommonRoleFeatureRuleRaw rule = existingRules.elementAt(i);
            index[index.length - 1] = rule.getRuleIndex();
            pdu.addVar(new SnmpOID(this._insertVarOid, index), this._DELETE);
            rollbackPdu.addVar(new SnmpOID(this._insertVarOid, index), this._CREATEANDGO);
            rollbackPdu.addVar(new SnmpOID(this._varVblOid[0], index), new SnmpString(rule.getName()));
            rollbackPdu.addVar(new SnmpOID(this._varVblOid[1], index), new SnmpInt(rule.getOperations()));
            rollbackPdu.addVar(new SnmpOID(this._varVblOid[2], index), new SnmpInt(rule.getPermits()));
        }
    }

    static {
        OPER_STRING = new String[]{"", "Clear", "Config", "Debug", "Show", "Exec"};
        _defaultNMSFeatures = new String[]{"system", "snmp", "module", "interface", "hardware", "environment"};
    }
}

