/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.mds.zm.AbstractMdsAction;
import com.cisco.dcbu.lib.mds.zm.ActionEnabler;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.util.ArrayList;

public class FeatureEnabler
extends ActionEnabler {
    static final int[] FEATURE_ACTION = MibNode.get("cfcFeatureCtrlAction").getOid();
    static final MibEnum[] FEATURE_ENUM = MibNode.get("cfcFeatureCtrlIndex").getEnums();
    static final int[] FEATURE_RESULT = MibNode.get("cfcFeatureCtrlLastActionResult").getOid();
    static final int[] FEATURE_FAIL_REASON = MibNode.get("cfcFeatureCtrlLastFailureReason").getOid();
    static final int[] FEATURE_OP_STATUSON = MibNode.get("cfcFeatureCtrlOpStatus").getOid();
    static final int ENABLED = 2;
    static final int DISABLED = 3;
    static final int SUCCESS = 2;
    static final int FAILED = 3;
    static final int IN_PROGRESS = 4;
    private boolean _enableFeature;

    public FeatureEnabler(ArrayList taskList, boolean enableFeature, StatusIf statusIf) {
        super(taskList, statusIf);
        this._taskList = taskList;
        this._enableFeature = enableFeature;
        this._statusIf = statusIf;
    }

    @Override
    protected void buildTask(Object task, int taskIndex) throws SnmpException {
        Object[] ob = (Object[])task;
        SnmpPeer sw = (SnmpPeer)ob[0];
        this._managers[taskIndex] = new PollerManager(this, sw);
        this.createAction(task, this._managers[taskIndex]);
        this._managers[taskIndex].start();
    }

    @Override
    protected AbstractMdsAction createAction(Object task, PollerManager manager) throws SnmpException {
        Object[] ob = (Object[])task;
        SnmpPeer peer = (SnmpPeer)ob[0];
        FeatureAction act = new FeatureAction(peer, (int[])ob[1], this);
        manager.addTask(act);
        return act;
    }

    class FeatureAction
    extends AbstractMdsAction {
        private SnmpPeer _peer;
        private int[] _featureIds;
        private ArrayList _failedFeatures;
        private ArrayList _successFeatures;
        private StringBuffer _failedReason;

        FeatureAction(SnmpPeer peer, int[] featureIds, PollerCallbackIf pollerCallBack) {
            super(pollerCallBack);
            this._failedFeatures = new ArrayList();
            this._successFeatures = new ArrayList();
            this._failedReason = new StringBuffer();
            this._peer = peer;
            this._featureIds = featureIds;
        }

        @Override
        public VarBindList getPollVarBind() {
            VarBindList vb = new VarBindList();
            for (int i = 0; i < this._featureIds.length; ++i) {
                vb.add(FEATURE_RESULT, this._featureIds[i]);
                vb.add(FEATURE_FAIL_REASON, this._featureIds[i]);
                vb.add(FEATURE_OP_STATUSON, this._featureIds[i]);
            }
            return vb;
        }

        @Override
        public VarBindList getActionVarBind() throws SnmpException {
            this._failedFeatures.clear();
            this._successFeatures.clear();
            this._failedReason.setLength(0);
            VarBindList vb = new VarBindList();
            for (int i = 0; i < this._featureIds.length; ++i) {
                vb.add(FEATURE_ACTION, this._featureIds[i], (SnmpVar)new SnmpInt(FeatureEnabler.this._enableFeature ? 2 : 3));
            }
            return vb;
        }

        @Override
        public String toString() {
            return (FeatureEnabler.this._enableFeature ? "enable features" : "disable features") + " on " + this._peer + "...";
        }

        @Override
        public VarBindList getCleanUpVarBind() {
            return null;
        }

        @Override
        public int pollStatus(PollerManager manager, VarBindList response, StringBuffer status) {
            block4: for (int i = 0; i < this._featureIds.length; ++i) {
                Integer featureInt = new Integer(this._featureIds[i]);
                int result = response.intValue(i * 3);
                switch (result) {
                    case 4: {
                        FeatureEnabler.this._statusIf.setStatus(this._peer + (FeatureEnabler.this._enableFeature ? ":enabling " : ":disabling ") + MibEnum.getLabel(FEATURE_ENUM, this._featureIds[i]).toUpperCase() + " ...");
                        continue block4;
                    }
                    case 2: {
                        if (response.intValue(i * 3 + 2) != (FeatureEnabler.this._enableFeature ? 2 : 3)) continue block4;
                        FeatureEnabler.this._statusIf.setStatus(this._peer + ":successfully " + (FeatureEnabler.this._enableFeature ? "enabled " : "disabled ") + "feature " + MibEnum.getLabel(FEATURE_ENUM, this._featureIds[i]).toUpperCase());
                        if (this._successFeatures.contains(featureInt)) continue block4;
                        this._successFeatures.add(featureInt);
                        continue block4;
                    }
                    default: {
                        FeatureEnabler.this._statusIf.setStatus(this._peer + ":failed to " + (FeatureEnabler.this._enableFeature ? "enable " : "disable ") + "feature " + MibEnum.getLabel(FEATURE_ENUM, this._featureIds[i]).toUpperCase());
                        if (!this._failedFeatures.contains(featureInt)) {
                            this._failedFeatures.add(featureInt);
                        }
                        this._failedReason.append(MibEnum.getLabel(FEATURE_ENUM, featureInt).toUpperCase() + ":" + response.stringValue(i * 3 + 1) + "\n");
                    }
                }
            }
            if (this._failedFeatures.size() + this._successFeatures.size() < this._featureIds.length) {
                return 0;
            }
            if (this._failedFeatures.size() > 0) {
                return 2;
            }
            return 1;
        }

        @Override
        public void failed(PollerManager manager, SnmpException ex) {
            super.failed(manager, this.getFailedReason().length() == 0 ? ex : new SnmpException(this.getFailedReason()));
        }

        boolean isFailed() {
            return this._failedFeatures.size() > 0;
        }

        String getFailedReason() {
            return this._failedReason.toString();
        }
    }
}

