/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class PortSet
extends SnmpString {
    public static final int MAX_PORT_PER_CARD = 64;
    public static final int MAX_CARD_PER_BOX = 16;
    public static final int MAX_PORT_BYTES = 128;
    static final int CARD_SHIFT = 6;
    private IfIndexIf _ifIndexIf;

    public PortSet(byte[] byteValue) {
        super(byteValue);
    }

    public void setIfIndexIf(IfIndexIf ifIndexIf) {
        this._ifIndexIf = ifIndexIf;
    }

    public final int size() {
        return this._byteValue.length * 8;
    }

    public static boolean getBit(byte[] b, int card, int port) {
        int pos = (card << 6) + port;
        return PortSet.getBit(b, pos);
    }

    public static boolean getBit(byte[] b, int pos) {
        int shift = pos % 8;
        if (shift == 8) {
            shift = 0;
        }
        return (b[pos / 8] >> shift & 1) != 0;
    }

    public static void setBit(byte[] b, int card, int port) {
        int pos = (card << 6) + port;
        PortSet.setBit(b, pos);
    }

    public static void setBit(byte[] b, int pos) {
        int shift = pos % 8;
        if (shift == 8) {
            shift = 0;
        }
        int n = pos / 8;
        b[n] = (byte)(b[n] | 1 << shift);
    }

    @Override
    protected void encode(SnmpOutputStream os) throws SnmpException {
        int i;
        for (i = this._byteValue.length - 1; i > 1 && this._byteValue[i] == 0; --i) {
        }
        this.encode(os, i + 1);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(PortEditorCardAttribute[] slotMembers) {
        int i;
        if (this._byteValue.length == 0) {
            return null;
        }
        if (this._value != null) {
            return this._value;
        }
        StringBuffer sb = new StringBuffer();
        int max = this._byteValue.length * 8;
        for (i = 0; i < max && !PortSet.getBit(this._byteValue, i); ++i) {
        }
        while (i < max) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(this.portToName(i, slotMembers));
            while (i < max) {
                int j;
                for (j = i + 1; j < max && PortSet.getBit(this._byteValue, j); ++j) {
                }
                if (j > i + 1) {
                    sb.append('-');
                    sb.append(this.portToName(j - 1, slotMembers));
                }
                for (i = j; i < max && !PortSet.getBit(this._byteValue, i); ++i) {
                }
                if (i >= max) continue;
                sb.append(',');
                sb.append(this.portToName(i, slotMembers));
            }
        }
        this._value = sb.toString();
        return this._value;
    }

    public static PortSet parse(String portSet) throws SnmpException {
        return PortSet.parse(portSet, null);
    }

    public static PortSet parse(String portSet, PortEditorCardAttribute[] slotMembers) throws SnmpException {
        return PortSet.parse(portSet, slotMembers, null);
    }

    public static PortSet parse(String portSet, PortEditorCardAttribute[] slotMembers, Integer[] excludePortIfTypes) throws SnmpException {
        List<Integer> excludePortIfTypesList = null;
        excludePortIfTypesList = excludePortIfTypes != null ? Arrays.asList(excludePortIfTypes) : new ArrayList<Integer>();
        byte[] b = new byte[128];
        PortSet set = new PortSet(b);
        StringTokenizer st = new StringTokenizer(portSet, ",-", true);
        boolean thru = false;
        int startCard = 0;
        int startPort = 0;
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if (t.charAt(0) == ',') continue;
            if (t.charAt(0) == '-') {
                thru = true;
                continue;
            }
            int ifIndex = IfIndexUtil.nameToIfIndex(t);
            int type = IfIndexUtil.getType(ifIndex);
            int card = type == 31 ? IfIndexUtil.ifIndex2SatSwitchId(ifIndex) + 1 : IfIndexUtil.ifIndex2Card(ifIndex) + 1;
            int port = IfIndexUtil.ifIndex2Port(ifIndex);
            int portIfType = IfIndexUtil.ifNameToifType(t);
            PortEditorCardAttribute cardAttr = null;
            int cardPosition = -1;
            if (slotMembers != null) {
                for (int loop = 0; loop < slotMembers.length; ++loop) {
                    PortEditorCardAttribute nextCard = slotMembers[loop];
                    if (nextCard._card != card) continue;
                    cardAttr = nextCard;
                    cardPosition = loop;
                    break;
                }
            }
            if (slotMembers != null && cardAttr != null && port <= cardAttr._numOfPorts) {
                if (portIfType == 2) {
                    if (cardAttr._cardType == 22 || cardAttr._cardType == 27) {
                        port += 14;
                    } else if (cardAttr._cardType == 39 || cardAttr._cardType == 41) {
                        port += 18;
                    } else if (cardAttr._cardType == 68) {
                        port += 50;
                    }
                } else if (portIfType == 26) {
                    if (cardAttr._cardType == 68) {
                        port += 40;
                    }
                } else if (portIfType == 1) {
                    if (cardAttr._cardType == 10000002 || cardAttr._cardType == 30000003) {
                        port += 4;
                    } else if (cardAttr._cardType == 10000012) {
                        port += 8;
                    }
                }
            }
            if (thru) {
                for (int i = startCard; i <= cardPosition; ++i) {
                    for (int j = startPort; j <= port; ++j) {
                        if (excludePortIfTypesList.contains(portIfType)) continue;
                        PortSet.setBit(b, i, j);
                    }
                }
                thru = false;
                continue;
            }
            if (!excludePortIfTypesList.contains(portIfType)) {
                PortSet.setBit(b, cardPosition, port);
            }
            startCard = cardPosition;
            startPort = port;
        }
        return set;
    }

    String portToName(int pos, PortEditorCardAttribute[] slotMembers) {
        StringBuffer sb = new StringBuffer();
        int port = PortSet.getPort(pos) + 1;
        int card = PortSet.getCard(pos) + 1;
        if (slotMembers != null && card <= slotMembers.length && slotMembers[card - 1] != null && port <= slotMembers[card - 1]._numOfPorts) {
            IfIndexIf ifIndexIf = this._ifIndexIf != null ? this._ifIndexIf : MibVariableFormat._IfIndexIf;
            sb.append(ifIndexIf.ifTypeToifName(slotMembers[card - 1]._ifTypes[port - 1]));
            if ((slotMembers[card - 1]._cardType == 22 || slotMembers[card - 1]._cardType == 27) && port > 14) {
                port -= 14;
            } else if ((slotMembers[card - 1]._cardType == 39 || slotMembers[card - 1]._cardType == 41) && port > 18) {
                port -= 18;
            } else if (slotMembers[card - 1]._cardType == 68) {
                if (port > 48) {
                    port -= 48;
                } else if (port > 40) {
                    port -= 40;
                }
            } else if ((slotMembers[card - 1]._cardType == 10000002 || slotMembers[card - 1]._cardType == 30000003) && port > 4) {
                port -= 4;
            } else if (slotMembers[card - 1]._cardType == 10000012 && port > 8) {
                port -= 8;
            }
        }
        String cardStr = slotMembers != null ? slotMembers[card - 1].getCardStr() : null;
        sb.append(cardStr != null ? cardStr : Integer.valueOf(card));
        sb.append('/');
        sb.append(port);
        return sb.toString();
    }

    static int getCard(int pos) {
        return pos >> 6;
    }

    static int getPort(int pos) {
        return pos % 64;
    }

    public Integer[] getCards() {
        if (this._byteValue.length == 0) {
            return null;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int max = this._byteValue.length * 8;
        int i = 0;
        while (i < max) {
            if (!PortSet.getBit(this._byteValue, i)) {
                ++i;
                continue;
            }
            int card = PortSet.getCard(i) + 1;
            rows.add(card);
            ++i;
        }
        return rows.toArray(new Integer[0]);
    }

    public Integer[] getPorts() {
        if (this._byteValue.length == 0) {
            return null;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int max = this._byteValue.length * 8;
        int i = 0;
        while (i < max) {
            if (!PortSet.getBit(this._byteValue, i)) {
                ++i;
                continue;
            }
            int port = PortSet.getPort(i) + 1;
            rows.add(port);
            ++i;
        }
        return rows.toArray(new Integer[0]);
    }
}

