/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.mds.FCIPDefaults;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.util.HashMap;

public class SharedUtil {
    static final int[] _ciiIPIfAddressStatusOid = MibNode.get("ciiIPIfAddressStatus").getOid();
    static final int[] _ipAddressOid = MibNode.get("ciiIPIfAddressPrefixLength").getOid();
    public static final MibEnum[] _EntSensorScaleEnums = MibNode.get("entSensorScale").getEnums();
    public static final int[] Scale = new int[]{0, -24, -21, -18, -15, -12, -9, -6, -3, 0, 3, 6, 9, 12, 15, 18, 21, 24};
    public static final MibEnum[] SensorType = new MibEnum[]{new MibEnum("Voltage", 3), new MibEnum("Current", 5), new MibEnum("Temperature", 8), new MibEnum("Rx Power", 14), new MibEnum("Tx Power", 15)};
    public static final int PORT_SENSOR_STOP_OFFSET = 15;

    public static void getSetIpAddressPDU(SnmpPDU pdu, SnmpPDU ipAddressPDU, int ifIndex, String newIpAddress, String oldIpAddress) throws SnmpException {
        byte[] ipAddrB = new byte[]{0, 0, 0, 0};
        int mask = 24;
        if (!newIpAddress.equals("n/a")) {
            int slash = newIpAddress.indexOf(47);
            if (slash == -1) {
                ipAddrB = SnmpIpAddress.parse(newIpAddress);
                mask = ipAddrB.length == 16 ? 64 : 24;
            } else {
                ipAddrB = SnmpIpAddress.parse(newIpAddress.substring(0, slash));
                mask = Integer.parseInt(newIpAddress.substring(slash + 1, newIpAddress.length()));
            }
        }
        int[] ipAddr = SnmpString.valueOf(ipAddrB, false);
        int[] ipIndex = new int[ipAddr.length + 3];
        ipIndex[0] = ifIndex;
        ipIndex[1] = ipAddrB.length != 16 ? 1 : 2;
        ipIndex[2] = ipAddrB.length;
        System.arraycopy(ipAddr, 0, ipIndex, 3, ipAddr.length);
        int action = SharedUtil.ipAddressChange(newIpAddress, oldIpAddress);
        if (action == 1) {
            pdu.addVar(new SnmpOID(_ipAddressOid, ipIndex), new SnmpUnsignedInt(mask));
        } else {
            if (action == 3 || action == 4) {
                int slash = oldIpAddress.indexOf(47);
                ipAddrB = slash == -1 ? SnmpIpAddress.parse(oldIpAddress) : SnmpIpAddress.parse(oldIpAddress.substring(0, slash));
                int[] oldIpAddr = SnmpString.valueOf(ipAddrB, false);
                int[] oldIpIndex = new int[oldIpAddr.length + 3];
                oldIpIndex[0] = ifIndex;
                oldIpIndex[1] = ipAddrB.length != 16 ? 1 : 2;
                oldIpIndex[2] = ipAddrB.length;
                System.arraycopy(oldIpAddr, 0, oldIpIndex, 3, oldIpAddr.length);
                ipAddressPDU.addVar(new SnmpOID(_ciiIPIfAddressStatusOid, oldIpIndex), new SnmpInt(6));
            }
            if (action == 2 || action == 4) {
                ipAddressPDU.addVar(new SnmpOID(_ciiIPIfAddressStatusOid, ipIndex), new SnmpInt(4));
                ipAddressPDU.addVar(new SnmpOID(_ipAddressOid, ipIndex), new SnmpUnsignedInt(mask));
            }
        }
    }

    public static int ipAddressChange(String newIpAddress, String oldIpAddress) {
        if (oldIpAddress.equals(newIpAddress)) {
            return 0;
        }
        int slash = oldIpAddress.indexOf(47);
        if (slash != -1 && !oldIpAddress.equals("n/a")) {
            oldIpAddress = oldIpAddress.substring(0, slash);
        }
        if ((slash = newIpAddress.indexOf(47)) != -1 && !newIpAddress.equals("n/a")) {
            newIpAddress = newIpAddress.substring(0, slash);
        }
        if (oldIpAddress.equals(newIpAddress)) {
            return 1;
        }
        if (oldIpAddress.equals("n/a") || newIpAddress.equals("n/a")) {
            return oldIpAddress.equals("n/a") ? 2 : 3;
        }
        return 4;
    }

    public static boolean isIpAddress(String initiatorName, boolean needMask) {
        int splash = needMask ? initiatorName.indexOf(47) : -1;
        try {
            SnmpIpAddress.parse(splash == -1 ? initiatorName : initiatorName.substring(0, splash));
        }
        catch (SnmpException ex) {
            return false;
        }
        return true;
    }

    public static String ipAddressPadding(String initiatorName, boolean needMask) {
        if (!SharedUtil.isIpAddress(initiatorName, needMask)) {
            return initiatorName;
        }
        StringBuffer sb = new StringBuffer(initiatorName);
        for (int i = initiatorName.length(); i < 16; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String maskPadding(String initiatorName) throws NumberFormatException {
        int maxMask;
        int splash = initiatorName.indexOf(47);
        byte[] ipAddrB = new byte[]{};
        try {
            ipAddrB = SnmpIpAddress.parse(splash == -1 ? initiatorName : initiatorName.substring(0, splash));
        }
        catch (SnmpException ex) {
            return initiatorName;
        }
        int defaultMask = ipAddrB.length == 16 ? 64 : 32;
        int n = maxMask = ipAddrB.length == 16 ? 128 : 32;
        if (splash == -1 || splash == initiatorName.length() - 1) {
            initiatorName = initiatorName + (splash == -1 ? "/" : "") + defaultMask;
        } else {
            int mask = Integer.parseInt(initiatorName.substring(splash + 1));
            if (mask < 1 || mask > maxMask) {
                throw new NumberFormatException("bad mask : 1.." + maxMask);
            }
        }
        return initiatorName;
    }

    public static String[] getEthIpAddress(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList();
        int[] ciiIPIfAddressPrefixLength = MibNode.get("ciiIPIfAddressPrefixLength").getOid();
        int oidLen = ciiIPIfAddressPrefixLength.length;
        vbl.add(new SnmpVarBind(new SnmpOID(ciiIPIfAddressPrefixLength)));
        vbl = SnmpFetch.getBulk(peer, vbl).getVariables();
        if (vbl.size() == 0) {
            return null;
        }
        Array<String> ipAddress = new Array<String>();
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid = vbl.get(i).getOid().getValue();
            if (IfIndexUtil.getType(oid[oidLen]) != 2 && IfIndexUtil.getType(oid[oidLen]) != 26 && IfIndexUtil.getType(oid[oidLen]) != 31 && IfIndexUtil.getType(oid[oidLen]) != 4) continue;
            if (oid[oidLen + 1] == 2) {
                if (oid[oidLen + 3] == 254 && oid[oidLen + 4] == 128) continue;
                ipAddress.addElement(SnmpIpAddress.toHexString(oid, oidLen + 3, oid.length));
                continue;
            }
            ipAddress.addElement(SnmpOID.toString(oid, oidLen + 3, oid.length));
        }
        if (ipAddress.size() == 0) {
            return null;
        }
        String[] names = new String[ipAddress.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)ipAddress.elementAt(i);
        }
        return names;
    }

    public static HashMap<String, FCIPDefaults> getEthIpAddressFCIPDefaults(SnmpPeer peer, SwitchAttrIf sw) throws SnmpException {
        VarBindList vbl = new VarBindList();
        int[] ciiIPIfAddressPrefixLength = MibNode.get("ciiIPIfAddressPrefixLength").getOid();
        int oidLen = ciiIPIfAddressPrefixLength.length;
        vbl.add(new SnmpVarBind(new SnmpOID(ciiIPIfAddressPrefixLength)));
        vbl = SnmpFetch.getBulk(peer, vbl).getVariables();
        if (vbl.size() == 0) {
            return null;
        }
        HashMap<String, FCIPDefaults> defaultsMap = new HashMap<String, FCIPDefaults>();
        VarBindList speedVbl = new VarBindList();
        int[] ifHighSpeed = MibNode.get("ifHighSpeed").getOid();
        int speedOidLen = ifHighSpeed.length;
        HashMap<Integer, String> ipAddressIfIndexMap = new HashMap<Integer, String>();
        for (int i = 0; i < vbl.size(); ++i) {
            String ipAddress;
            int[] oid = vbl.get(i).getOid().getValue();
            if (IfIndexUtil.getType(oid[oidLen]) != 2 && IfIndexUtil.getType(oid[oidLen]) != 26 && IfIndexUtil.getType(oid[oidLen]) != 31 && IfIndexUtil.getType(oid[oidLen]) != 4) continue;
            int ifIndex = oid[oidLen];
            if (oid[oidLen + 1] == 2) {
                if (oid[oidLen + 3] == 254 && oid[oidLen + 4] == 128) continue;
                ipAddress = SnmpIpAddress.toHexString(oid, oidLen + 3, oid.length);
            } else {
                ipAddress = SnmpOID.toString(oid, oidLen + 3, oid.length);
            }
            speedVbl.add(ifHighSpeed, ifIndex);
            ipAddressIfIndexMap.put(ifIndex, ipAddress);
        }
        if (speedVbl.size() == 0) {
            return null;
        }
        SnmpPDU speedPDU = SnmpFetch.get(peer, speedVbl);
        VarBindList speedResp = speedPDU.getVariables();
        for (int i = 0; i < speedResp.size(); ++i) {
            int[] oid = speedResp.get(i).getOid().getValue();
            int ifInd = oid[speedOidLen];
            SnmpVarBind speedVar = speedResp.get(i);
            int speed = 0;
            if (!speedVar.isNull()) {
                speed = speedVar.intValue();
            }
            String ipAddr = (String)ipAddressIfIndexMap.get(ifInd);
            FCIPDefaults fcipDefaults = new FCIPDefaults(ifInd, sw.getFCIPMaxBWDefault(speed), sw.getFCIPMinAvailBWDefault(speed));
            defaultsMap.put(ipAddr, fcipDefaults);
        }
        return defaultsMap;
    }

    public static int getSensorSlot(int sensorIndex) {
        return (sensorIndex - 25814) / 4096;
    }

    public static int getSensorSlot(boolean is6_1_0_above, int sensorIndex) {
        return is6_1_0_above ? (sensorIndex - 300000000) / 450560 : (sensorIndex - 25814) / 4096;
    }

    public static int getSensorPort(int sensorIndex, int slot) {
        return (sensorIndex - 25814 - slot * 256 * 16) / 16;
    }

    public static int getSensorPort(boolean is6_1_0_above, int sensorIndex, int slot) {
        return is6_1_0_above ? (sensorIndex - 300000000 - slot * 256 * 16 * 110) / 1760 : (sensorIndex - 25814 - slot * 256 * 16) / 16;
    }

    public static int getSensorLane(boolean is6_1_0_above, int sensorIndex, int slot, int port) {
        return is6_1_0_above ? (sensorIndex - 300000000 - slot * 256 * 16 * 110 - port * 16 * 110) / 16 : 0;
    }

    public static int getSensorType(int ifIndex, int slot) {
        return (ifIndex - 25814 - slot * 256 * 16) % 16 + 1;
    }

    public static int getSensorType(boolean is6_1_0_above, int ifIndex, int slot, int port, int lane) {
        return is6_1_0_above ? ifIndex - 300000000 - slot * 256 * 16 * 110 - port * 16 * 110 - lane * 16 + 1 : (ifIndex - 25814 - slot * 256 * 16) % 16 + 1;
    }

    public static Object getSensorString(int scale, int currentValue, String type) {
        return scale >= 0 ? Double.valueOf((double)currentValue * Math.pow(10.0, scale)) : (double)currentValue / Math.pow(10.0, -scale) + (type == null ? "" : " " + type);
    }

    public static int getSensorIndex(int ifIndex, int cardType) {
        int slot = IfIndexUtil.ifIndex2Card(ifIndex);
        int port = IfIndexUtil.ifIndex2Port(ifIndex);
        port = IfIndexUtil.getPortIf2Entity(port, cardType, IfIndexUtil.getType(ifIndex));
        int newIndex = 25813 + slot * 256 * 16 + port * 16;
        return newIndex;
    }

    public static int getSensorStartingIndex(boolean is6_1_0_above) {
        return is6_1_0_above ? 299999999 : 25813;
    }

    public static int getSensorIndex(boolean is6_1_0_above, int ifIndex, int cardType) {
        int slot = IfIndexUtil.ifIndex2Card(ifIndex);
        int port = IfIndexUtil.ifIndex2Port(ifIndex);
        port = IfIndexUtil.getPortIf2Entity(port, cardType, IfIndexUtil.getType(ifIndex));
        int newIndex = is6_1_0_above ? 299999999 + slot * 256 * 16 * 110 + port * 16 * 110 : 25813 + slot * 256 * 16 + port * 16;
        return newIndex;
    }

    public static int getSensorIndex4Slot(boolean is6_1_0_above, int slot) {
        int port = 0;
        int newIndex = is6_1_0_above ? 299999999 + slot * 256 * 16 * 110 + port * 16 * 110 : 25813 + slot * 256 * 16 + port * 16;
        return newIndex;
    }

    public static int getSensorStopOffset(boolean is6_1_0_above, int interfaceIndex) {
        return is6_1_0_above ? interfaceIndex + 1760 - 1 : interfaceIndex + 15;
    }

    public static int getSensorStopOffset4Slot(boolean is6_1_0_above, int slot, int numPortsOnSlot) {
        int startIndex = SharedUtil.getSensorIndex4Slot(is6_1_0_above, slot);
        return is6_1_0_above ? startIndex + 1760 * numPortsOnSlot - 1 : startIndex + 15 * numPortsOnSlot;
    }
}

