/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.protocol;

import com.cisco.dcbu.lib.protocol.SSHWrapper;
import com.cisco.dcbu.lib.protocol.TelnetWrapper;
import com.cisco.dcbu.lib.snmp.SnmpSession;

public class MDSWrapper {
    TelnetWrapper _tw = null;
    SSHWrapper _sshw = null;
    boolean _isTelnet = true;
    String _telnetPrompt = "#";

    private MDSWrapper() {
    }

    public MDSWrapper(String hostName, String userName, String passwd, String protocolToUse) throws Exception {
        if (!protocolToUse.equals("TELNET") && !protocolToUse.equals("SSH")) {
            throw new Exception("Protocol Not Supported.");
        }
        if (protocolToUse.equals("TELNET")) {
            this._isTelnet = true;
            this._tw = new TelnetWrapper(hostName);
            String loginOut = this.mdsLogin(this._tw, userName, passwd);
            if (loginOut.indexOf("incorrect") != -1) {
                throw new Exception("Telnet failed to " + hostName + ", please check user name and password.");
            }
            this._tw.sendAndExpect("terminal length 0", this._telnetPrompt);
        }
        if (protocolToUse.equals("SSH")) {
            this._isTelnet = false;
            this._sshw = new SSHWrapper(hostName, userName, passwd);
        }
        this.log("Succesfully logged into user@host : " + userName + "@" + hostName + " using : " + (this._isTelnet ? "Telnet" : "SSH"));
    }

    public String sendCommand(String cmd) throws Exception {
        String result = "";
        result = this._isTelnet ? this._tw.sendAndExpect(cmd, this._telnetPrompt) : this._sshw.sendCommand(cmd);
        return result;
    }

    private String mdsLogin(TelnetWrapper tw, String userName, String passwd) throws Exception {
        String telnetNotAllowedStr = "Instead of telnet and ftp, please use ssh and sftp";
        String[] toExpect = new String[]{"login:", telnetNotAllowedStr};
        String returnResult = tw.expect(toExpect);
        if (returnResult.indexOf(telnetNotAllowedStr) != -1) {
            throw new Exception("Telnet connection not allowed by this host.");
        }
        tw.send(userName);
        this.sleepFor(500L);
        tw.expect("Password: ");
        tw.send(passwd);
        String[] returnExpect = new String[]{"login:", telnetNotAllowedStr, this._telnetPrompt};
        return tw.expect(returnExpect);
    }

    public void disconnect() {
        try {
            if (this._isTelnet) {
                this._tw.disconnect();
            } else {
                this._sshw.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sleepFor(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void log(String msg) {
        if (SnmpSession.isTrace()) {
            System.out.println(msg);
        }
    }
}

