/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.protocol;

import com.cisco.dcbu.lib.protocol.SSHWrapper;
import com.cisco.dcbu.lib.protocol.TelnetWrapper;
import com.cisco.dcbu.lib.snmp.SnmpSession;

public class McDataWrapper {
    TelnetWrapper _tw = null;
    SSHWrapper _sshw = null;
    boolean _isTelnet = true;
    String _telnetPrompt = ">";

    private McDataWrapper() {
    }

    public McDataWrapper(String hostName, String userName, String passwd, String protocolToUse) throws Exception {
        this.log("McDataWrapper - Entered constructor");
        if (!protocolToUse.equals("TELNET") && !protocolToUse.equals("SSH")) {
            throw new Exception("Protocol Not Supported.");
        }
        if (protocolToUse.equals("TELNET")) {
            this._isTelnet = true;
            this._tw = new TelnetWrapper(hostName);
            String loginOut = "";
            try {
                loginOut = this.mcDataLogin(this._tw, userName, passwd);
            }
            catch (Exception e) {
                try {
                    this._tw.disconnect();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw new Exception(e.getMessage());
            }
            if (loginOut.indexOf("Username:") != -1) {
                if (this._tw != null) {
                    this._tw.disconnect();
                }
                throw new Exception("Telnet failed to " + hostName + ", please check user name and password.");
            }
        }
        if (protocolToUse.equals("SSH")) {
            this._isTelnet = false;
            this._sshw = new SSHWrapper(hostName, userName, passwd);
        }
        this.log("Succesfully logged into user@host : " + userName + "@" + hostName + " using : " + (this._isTelnet ? "Telnet" : "SSH"));
    }

    public String sendCommand(String cmd) throws Exception {
        this.log("Class McDataWrapper, method sendCommand. command to send : " + cmd);
        String result = "";
        result = this._isTelnet ? this._tw.sendAndExpect(cmd, this._telnetPrompt) : this._sshw.sendCommand(cmd);
        this.log("Class McDataWrapper, method sendCommand. result : " + result);
        return result;
    }

    private String mcDataLogin(TelnetWrapper tw, String userName, String passwd) throws Exception {
        String telnetNotAllowedStr = "Instead of telnet and ftp, please use ssh and sftp";
        String engagedStr = "engaged";
        this.log("McDataWrapper.mcDataLogin - Entered method");
        String[] toExpect = new String[]{"Username:", engagedStr, telnetNotAllowedStr, "login:"};
        String returnResult = tw.expect(toExpect);
        if (returnResult == null || returnResult.indexOf("engaged") != -1) {
            try {
                tw.disconnect();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new Exception("The system is engaged.");
        }
        if (returnResult.indexOf(telnetNotAllowedStr) != -1) {
            throw new Exception("Telnet connection not allowed by this host.");
        }
        if (returnResult.indexOf("login:") != -1) {
            throw new Exception("This does not look like a McData Switch.");
        }
        tw.send(userName);
        this.sleepFor(500L);
        tw.expect("Password: ");
        tw.send(passwd);
        String[] returnExpect = new String[]{"Username:", engagedStr, telnetNotAllowedStr, "login:", this._telnetPrompt};
        return tw.expect(returnExpect);
    }

    public void disconnect() {
        this.log("Class McDataWrapper, method disconnect. Entering method");
        try {
            if (this._isTelnet) {
                this._tw.disconnect();
            } else {
                this._sshw.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sleepFor(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void log(String msg) {
        if (SnmpSession.isTrace()) {
            System.out.println(msg);
        }
    }
}

