/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MibEnum {
    String _label;
    int _value;

    MibEnum() {
    }

    public MibEnum(String label, int value) {
        this._label = label;
        this._value = value;
    }

    public final String getLabel() {
        return this._label;
    }

    public final void setLabel(String label) {
        this._label = label;
    }

    public final int getValue() {
        return this._value;
    }

    public String toString() {
        return this._label;
    }

    public static String getLabel(MibEnum[] enums, int value) {
        if (enums != null) {
            for (int i = 0; i < enums.length; ++i) {
                if (enums[i]._value != value) continue;
                return enums[i]._label;
            }
        }
        return "Unknown: " + value;
    }

    public static int getValue(MibEnum[] enums, String label) {
        if (enums != null) {
            for (int i = 0; i < enums.length; ++i) {
                if (!enums[i]._label.equals(label)) continue;
                return enums[i]._value;
            }
        }
        return -1;
    }

    public static MibEnum getEnum(MibEnum[] enums, int value) {
        if (enums != null) {
            for (int i = 0; i < enums.length; ++i) {
                if (enums[i]._value != value) continue;
                return enums[i];
            }
        }
        return null;
    }

    void write(DataOutputStream os) throws IOException {
        os.writeUTF(this._label);
        os.writeInt(this._value);
    }

    void read(DataInputStream is) throws IOException {
        this._label = is.readUTF().intern();
        this._value = is.readInt();
    }
}

