/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpReportException;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public final class SnmpAggregrate
implements SnmpCallbackIf {
    private static final int TIMEOUT = 20000;
    private Object _lock;
    private SnmpAggregrateIf _target;
    private int _pending;
    private int _successfulSets;
    private StringBuffer _errors;
    private List<SnmpPDU> _responses;
    private int _timeOut = 20000;

    public void setTimeOut(int timeout) {
        this._timeOut = timeout;
    }

    public int set(Iterator peers, Iterator pdus) throws SnmpException {
        return this.set(peers, pdus, null);
    }

    public int set(Iterator peers, Iterator pdus, SnmpAggregrateIf target) throws SnmpException {
        return this.set(peers, pdus, (Object)pdus, target);
    }

    public int set(Iterator peers, Iterator pdus, Object monitor, SnmpAggregrateIf target) throws SnmpException {
        return this.set(peers, pdus, monitor, target, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set(Iterator peers, Iterator pdus, Object monitor, SnmpAggregrateIf target, boolean fragOnPduByte) throws SnmpException {
        Object pdu;
        this._lock = monitor;
        this._target = target;
        this._pending = 0;
        this._successfulSets = 0;
        this._errors = new StringBuffer();
        this._responses = null;
        boolean bSet = false;
        while (pdus.hasNext()) {
            pdu = (SnmpPDU)pdus.next();
            if (((SnmpPDU)pdu).getVariables().size() == 0) continue;
            SnmpPeer peer = (SnmpPeer)peers.next();
            VarBindList vbl = ((SnmpPDU)pdu).getVariables();
            bSet = true;
            this.fragmentPdu(peer, vbl, SnmpFetch._Max, (byte)-93, fragOnPduByte, ((SnmpPDU)pdu).getTimeout());
        }
        if (bSet) {
            try {
                pdu = this._lock;
                synchronized (pdu) {
                    this._lock.wait(this._timeOut);
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        return this._successfulSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set(SnmpPeer[] peers, SnmpPDU[] pdus, Object monitor, SnmpAggregrateIf target, boolean fragOnPduByte) throws SnmpException {
        this._lock = monitor;
        this._target = target;
        this._pending = 0;
        this._successfulSets = 0;
        this._errors = new StringBuffer();
        this._responses = null;
        boolean bSet = false;
        for (int i = 0; i < pdus.length; ++i) {
            SnmpPDU pdu = pdus[i];
            if (pdu.getVariables().size() == 0) continue;
            SnmpPeer peer = peers[i];
            VarBindList vbl = pdu.getVariables();
            bSet = true;
            this.fragmentPdu(peer, vbl, SnmpFetch._Max, (byte)-93, fragOnPduByte, pdu.getTimeout());
        }
        if (bSet) {
            try {
                Object i = this._lock;
                synchronized (i) {
                    this._lock.wait(this._timeOut);
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        return this._successfulSets;
    }

    void fragmentPdu(SnmpPeer peer, VarBindList vbl, int maxVbl, byte op, boolean fragOnPduByte, int pdutimeout) throws SnmpException {
        if (fragOnPduByte) {
            this.fragmentPduByte(peer, vbl, op, pdutimeout);
        } else {
            this.fragmentPduSize(peer, vbl, maxVbl, op, pdutimeout);
        }
    }

    void fragmentPduSize(SnmpPeer peer, VarBindList vbl, int maxVbl, byte op, int pdutimeout) throws SnmpException {
        if (vbl.size() > SnmpFetch._Max) {
            int numPdus = vbl.size() / maxVbl;
            if (vbl.size() % maxVbl > 0) {
                ++numPdus;
            }
            int vNo = 0;
            for (int i = 0; i < numPdus; ++i) {
                VarBindList pduVbl = new VarBindList();
                int max = vNo + maxVbl;
                if (max > vbl.size()) {
                    max = vbl.size();
                }
                while (vNo < max) {
                    pduVbl.add(vbl.get(vNo++));
                }
                SnmpPDU pdu = new SnmpPDU(op, pduVbl);
                if (pdutimeout != -1) {
                    pdu.setTimeout(pdutimeout);
                }
                ++this._pending;
                peer.send(pdu, this);
            }
        } else {
            ++this._pending;
            SnmpPDU pdu = new SnmpPDU(op, vbl);
            if (pdutimeout != -1) {
                pdu.setTimeout(pdutimeout);
            }
            peer.send(pdu, this);
        }
    }

    void fragmentPduByte(SnmpPeer peer, VarBindList vbl, byte op, int pdutimeout) throws SnmpException {
        Array<SnmpPDU> pdus = SnmpFetch.fragment(vbl, op);
        for (int i = 0; i < pdus.size(); ++i) {
            SnmpPDU pdu = pdus.elementAt(i);
            if (pdutimeout != -1) {
                pdu.setTimeout(pdutimeout);
            }
            ++this._pending;
            peer.send(pdu, this);
        }
    }

    public int set(SnmpPeer[] peers, VarBindList varBindList, Object monitor, SnmpAggregrateIf target) throws SnmpException {
        return this.set(peers, varBindList, monitor, target, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set(SnmpPeer[] peers, VarBindList varBindList, Object monitor, SnmpAggregrateIf target, boolean fragOnPduByte) throws SnmpException {
        this._lock = monitor;
        this._target = target;
        this._pending = 0;
        this._successfulSets = 0;
        this._errors = new StringBuffer();
        this._responses = null;
        for (int i = 0; i < peers.length; ++i) {
            this.fragmentPdu(peers[i], varBindList, SnmpFetch._Max, (byte)-93, false, -1);
        }
        try {
            Object i = this._lock;
            synchronized (i) {
                this._lock.wait(this._timeOut);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return this._successfulSets;
    }

    public int set(SnmpPeer[] peers, VarBindList varBindList) throws SnmpException {
        return this.set(peers, varBindList, (Object)varBindList, null);
    }

    public SnmpPDU[] get(SnmpPeer[] peers, VarBindList varBindList) throws SnmpException {
        return this.get(peers, varBindList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPDU[] get(SnmpPeer[] peers, VarBindList varBindList, boolean fragOnPduByte) throws SnmpException {
        this._lock = varBindList;
        this._pending = 0;
        this._responses = new ArrayList<SnmpPDU>();
        for (int i = 0; i < peers.length; ++i) {
            this.fragmentPdu(peers[i], varBindList, SnmpFetch._Max, (byte)-96, fragOnPduByte, -1);
        }
        try {
            Object i = this._lock;
            synchronized (i) {
                this._lock.wait(this._timeOut);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return this._responses.toArray(new SnmpPDU[this._responses.size()]);
    }

    public SnmpPDU[] get(SnmpPeer[] peers, VarBindList[] varBindList) throws SnmpException {
        return this.get(peers, varBindList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPDU[] get(SnmpPeer[] peers, VarBindList[] varBindList, boolean fragOnPduByte) throws SnmpException {
        this._lock = varBindList;
        this._pending = 0;
        this._responses = new ArrayList<SnmpPDU>();
        for (int i = 0; i < peers.length; ++i) {
            this.fragmentPdu(peers[i], varBindList[i], SnmpFetch._Max, (byte)-96, fragOnPduByte, -1);
        }
        try {
            Object i = this._lock;
            synchronized (i) {
                this._lock.wait(this._timeOut);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return this._responses.toArray(new SnmpPDU[this._responses.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPDU[] getBulk(SnmpPeer[] peers, VarBindList varBindList) throws SnmpException {
        this._lock = varBindList;
        this._pending = peers.length;
        this._responses = new ArrayList<SnmpPDU>();
        for (int i = 0; i < peers.length; ++i) {
            new SnmpFetch().getBulk(peers[i], varBindList, (SnmpCallbackIf)this);
        }
        try {
            Object i = this._lock;
            synchronized (i) {
                this._lock.wait(this._timeOut);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this._responses.toArray(new SnmpPDU[this._responses.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPDU[] getBulkWithStartIndexFix(SnmpPeer[] peers, VarBindList[] varBindList, int[][] startIndexes, int[] stopIndex) throws SnmpException {
        this._lock = varBindList;
        this._pending = peers.length;
        this._responses = new ArrayList<SnmpPDU>();
        for (int i = 0; i < peers.length; ++i) {
            new SnmpFetch().getBulk(peers[i], varBindList[i], startIndexes[i], stopIndex, (SnmpCallbackIf)this);
        }
        try {
            Object i = this._lock;
            synchronized (i) {
                this._lock.wait(this._timeOut);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return this._responses.toArray(new SnmpPDU[this._responses.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPDU[] getBulkWithStartIndexFix(SnmpPeer[] peers, VarBindList varBindList, int[] startIndex, int[] stopIndex) throws SnmpException {
        this._lock = varBindList;
        this._pending = peers.length;
        this._responses = new ArrayList<SnmpPDU>();
        for (int i = 0; i < peers.length; ++i) {
            new SnmpFetch().getBulk(peers[i], varBindList, startIndex, stopIndex, (SnmpCallbackIf)this);
        }
        try {
            Object i = this._lock;
            synchronized (i) {
                this._lock.wait(this._timeOut);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return this._responses.toArray(new SnmpPDU[this._responses.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object node;
        if (this._responses == null) {
            if (timedOut || pdu.getError() != 0) {
                node = pdu._peer;
                if (node == null) {
                    SnmpPeer.findPeer(pdu.getAddress());
                }
                this.processError((SnmpPeer)node, pdu, timedOut);
            } else {
                if (this._target != null) {
                    this._target.snmpAggregrate(pdu, "");
                }
                ++this._successfulSets;
            }
        } else {
            if (timedOut) {
                pdu.setVariables(null);
            }
            this._responses.add(pdu);
        }
        --this._pending;
        if (this._pending == 0) {
            try {
                if (this._responses != null && this._responses.size() > 0) {
                    this._responses = this.sortResponses(this._responses);
                }
                node = this._lock;
                synchronized (node) {
                    this._lock.notify();
                }
            }
            catch (IllegalMonitorStateException ex) {
                pdu.getLogger().log((Priority)Level.ERROR, (Object)"SnmpAggregate::callback() error", (Throwable)ex);
            }
        }
    }

    private List<SnmpPDU> sortResponses(List<SnmpPDU> responses) {
        ArrayList<SnmpPDU> recombinedPDUsPerPeer = new ArrayList<SnmpPDU>();
        HashMap<SnmpPeer, ArrayList<SnmpPDU>> responsesPerPeer = new HashMap<SnmpPeer, ArrayList<SnmpPDU>>();
        boolean moreThanOneResponseForAPeer = false;
        for (SnmpPDU nextPdu : responses) {
            SnmpPeer nextPeer = nextPdu._peer;
            ArrayList<SnmpPDU> peerPdus = (ArrayList<SnmpPDU>)responsesPerPeer.get(nextPeer);
            if (peerPdus == null) {
                peerPdus = new ArrayList<SnmpPDU>();
                responsesPerPeer.put(nextPeer, peerPdus);
            } else {
                moreThanOneResponseForAPeer = true;
            }
            peerPdus.add(nextPdu);
        }
        if (!moreThanOneResponseForAPeer) {
            return responses;
        }
        Set peerKeySet = responsesPerPeer.keySet();
        for (SnmpPeer nextPeer : peerKeySet) {
            List peerResponses = (List)responsesPerPeer.get(nextPeer);
            int nOfPDUs = peerResponses.size();
            if (nOfPDUs > 1) {
                recombinedPDUsPerPeer.add(SnmpFetch.sortResponses(peerResponses.toArray(new SnmpPDU[peerResponses.size()])));
                continue;
            }
            if (nOfPDUs == 0) continue;
            recombinedPDUsPerPeer.add((SnmpPDU)peerResponses.get(0));
        }
        return recombinedPDUsPerPeer;
    }

    void processError(SnmpPeer peer, SnmpPDU pdu, boolean timedOut) {
        String err = "";
        if (timedOut) {
            err = peer + ": timeout";
            if (this._target != null) {
                this._target.snmpAggregrate(pdu, err);
            }
            this._errors.append(err + "\n");
        } else {
            ++this._pending;
            Thread t = new Thread((Runnable)new SnmpErrorDetailRunnable(peer, pdu), "SnmpErrorDetailRunnable");
            t.start();
        }
    }

    public String getErrors() {
        if (this._errors != null) {
            return this._errors.toString();
        }
        return null;
    }

    class SnmpErrorDetailRunnable
    implements Runnable {
        SnmpPDU _errorPdu;
        SnmpPeer _peer;

        SnmpErrorDetailRunnable(SnmpPeer peer, SnmpPDU pdu) {
            this._peer = peer;
            this._errorPdu = pdu;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String strErr = SnmpReportException.getError(this._errorPdu);
            String strErrorDetail = this._peer.getSnmpErrorDetail(strErr, this._errorPdu);
            String err = this._peer + ": " + strErrorDetail;
            if (SnmpAggregrate.this._target != null) {
                SnmpAggregrate.this._target.snmpAggregrate(this._errorPdu, err);
            }
            SnmpAggregrate.this._errors.append(err + "\n");
            SnmpAggregrate.this._pending--;
            if (SnmpAggregrate.this._pending <= 0) {
                try {
                    Object object = SnmpAggregrate.this._lock;
                    synchronized (object) {
                        SnmpAggregrate.this._lock.notifyAll();
                    }
                }
                catch (IllegalMonitorStateException ex) {
                    this._peer._session._log.log((Priority)Level.ERROR, (Object)"SnmpAggregate::callback() error", (Throwable)ex);
                }
            }
        }
    }
}

