/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.SnmpASN1;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInputStream;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SnmpTimeticks
extends SnmpUnsignedInt {
    String _cache;
    private static DateFormat _DateFormat;
    public static boolean _ShowDateTime;

    public SnmpTimeticks(long t) {
        super(t);
        this._type = (byte)67;
    }

    protected SnmpTimeticks(SnmpInputStream is, int len) throws SnmpException {
        this(SnmpASN1.parseLong(is, len));
    }

    public String toString(long value) {
        if (value == 0L) {
            return "n/a";
        }
        if (this._cache != null) {
            return this._cache;
        }
        this._cache = _ShowDateTime ? SnmpTimeticks.formatTimeAsDate(value) : SnmpTimeticks.formatTimeElapsed(value);
        return this._cache;
    }

    public static String formatTimeElapsed(long value) {
        StringBuffer sb = new StringBuffer();
        int secs = (int)(value / 100L);
        int days = secs / 86400;
        int hours = (secs %= 86400) / 3600;
        secs %= 3600;
        if (days == 1) {
            sb.append("1 day, ");
        } else if (days > 1) {
            sb.append(days + " days, ");
        }
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        int min = secs / 60;
        if (min < 10) {
            sb.append('0');
        }
        sb.append(min);
        sb.append(':');
        if ((secs %= 60) < 10) {
            sb.append('0');
        }
        sb.append(secs);
        return sb.toString();
    }

    public static String formatTimeAsDate(long value) {
        _DateFormat = SnmpTimeticks.getDateFormat();
        Date d = new Date();
        long time = d.getTime() - value * 10L;
        d.setTime(time);
        return _DateFormat.format(d);
    }

    public static DateFormat getDateFormat() {
        if (_DateFormat == null) {
            _DateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        }
        return _DateFormat;
    }

    static {
        _ShowDateTime = true;
    }
}

