/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.proxy;

import com.cisco.dcbu.lib.net.AbstractNetService;
import com.cisco.dcbu.lib.snmp.proxy.ProxySession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SnmpProxyService
extends AbstractNetService {
    static final String PROP_SNMP_LOCALADDRESS = "snmp.localaddress";
    static final int SOCKET_SEND_BUF = 6256;

    public SnmpProxyService() {
        this._log = LogManager.getLogger((String)"snmp.proxy");
        this.setName("SNMP Proxy");
    }

    @Override
    protected void initImpl(Object[] params) throws Exception {
        if (params != null) {
            this.setConfiguration("bindAddr", (String)params[0]);
            this.setConfiguration("bindPort", (String)params[1]);
            if (params.length > 2 && params[2] != null) {
                this.setConfiguration("maxConn", (String)params[2]);
            }
            if (params.length > 3 && params[3] != null) {
                this._log = (Logger)params[3];
            }
            if (params.length > 4 && params[4] != null) {
                this.setConfiguration(PROP_SNMP_LOCALADDRESS, (String)params[4]);
            }
        } else {
            this.setConfiguration("bindPort", System.getProperty("proxy.localport"));
        }
        super.initImpl(params);
    }

    @Override
    public void serve(Socket client) throws IOException {
        client.setSendBufferSize(12512);
        ProxySession session = new ProxySession(client);
        session._log = this._log;
        session.serve();
    }

    @Override
    public boolean handshake(Socket s) {
        try {
            InputStream in = s.getInputStream();
            OutputStream out = s.getOutputStream();
            int len = in.read();
            byte[] buf = new byte[len];
            in.read(buf);
            String packageName = new String(buf);
            Package pack = Package.getPackage(packageName);
            if (pack != null) {
                out.write(127);
                return true;
            }
            out.write(-128);
            this._log.debug((Object)("handshake with " + s.getInetAddress().getHostAddress() + "/" + s.getPort() + " failed: package " + packageName + " not found"));
        }
        catch (IOException ioe) {
            this._log.error((Object)("handshake with " + s.getInetAddress().getHostAddress() + "/" + s.getPort() + " failed: " + ioe.getMessage()));
        }
        return false;
    }

    public static void main(String[] args) {
        String s = "SnmpProxyService [-a localAddress] [-p port] [-s snmpLocalAddress]";
        String bindAddr = null;
        String port = null;
        String snmpAddr = null;
        Logger logger = LogManager.getLogger((String)"proxy");
        try {
            block7: for (int i = 0; i < args.length; ++i) {
                if (args[i].charAt(0) != '-') continue;
                switch (args[i].charAt(1)) {
                    case 'a': {
                        bindAddr = args[++i];
                        continue block7;
                    }
                    case 'p': {
                        port = args[++i];
                        continue block7;
                    }
                    case 's': {
                        snmpAddr = args[++i];
                        continue block7;
                    }
                    default: {
                        logger.error((Object)("unknown option: " + args[i] + '\n' + s));
                        return;
                    }
                }
            }
            SnmpProxyService service = new SnmpProxyService();
            service.init(new Object[]{bindAddr, port, null, logger, snmpAddr});
            logger.info((Object)(service + " started"));
            service.start();
        }
        catch (Exception ioe) {
            logger.log((Priority)Level.FATAL, (Object)"cannot start SnmpProxyService", (Throwable)ioe);
        }
    }
}

