/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.transport;

import com.cisco.dcbu.lib.snmp.transport.AbstractIpTransportOptions;
import java.net.InetAddress;

public class TcpTransportOptions
extends AbstractIpTransportOptions {
    private static final long serialVersionUID = 1L;
    protected InetAddress _remoteAddress;
    protected int _remotePort;
    protected transient String _sessionId;

    public TcpTransportOptions(InetAddress remoteAddr, int remotePort, int localPort) {
        this(remoteAddr, remotePort, null, localPort);
    }

    public TcpTransportOptions(InetAddress remoteAddr, int remotePort, String localAddr, int localPort) {
        super(localAddr, localPort);
        this._remoteAddress = remoteAddr;
        this.setRemotePort(remotePort);
    }

    public InetAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public void setRemoteAddress(InetAddress addr) {
        this._remoteAddress = addr;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public void setRemotePort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this._remotePort = port;
    }

    public String getSessionId() {
        if (this._sessionId == null) {
            this._sessionId = this._remoteAddress.getHostAddress() + "/" + this._remotePort;
        }
        return this._sessionId;
    }
}

