/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.LabelDescription;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public final class DialogUtil {
    public static Insets _Insets = new Insets(1, 2, 1, 2);
    public static Insets _MarginInsets = new Insets(8, 8, 8, 8);
    public static Border _Margin = new EmptyBorder(_MarginInsets);

    private DialogUtil() {
    }

    public static final Insets getInsets() {
        return _Insets;
    }

    public static void constrain(Container container, Component component, GridBagConstraints gbc, int gridx, int gridy, int fill, int anchor) {
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.fill = fill;
        gbc.anchor = anchor;
        container.add(component, gbc);
    }

    public static JPanel buildPanel(Component[] components, int[][] coordinates, int anchor) {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = anchor;
        gbc.insets = _Insets;
        for (int i = 0; i < components.length; ++i) {
            gbc.gridx = coordinates[i][0];
            gbc.gridy = coordinates[i][1];
            p.add(components[i], gbc);
        }
        return p;
    }

    public static Point getPointOnScreen(Point p, Component c, Dimension windowSize) {
        SwingUtilities.convertPointToScreen(p, c);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        d.height -= windowSize.height;
        d.width -= windowSize.width;
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.y > d.height) {
            p.y = d.height;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.x > d.width) {
            p.x = d.width;
        }
        return p;
    }

    public static JLabel[] buildLabels(String[] label) {
        JLabel[] labels = new JLabel[label.length];
        for (int i = 0; i < labels.length; ++i) {
            if (label[i] == null) continue;
            labels[i] = new JLabel(label[i], 4);
        }
        return labels;
    }

    public static JPanel buildPanel(JComponent[] labels, JComponent[] value) {
        JPanel panel = new JPanel(new GridBagLayout());
        DialogUtil.buildPanel(panel, labels, value);
        return panel;
    }

    public static void buildPanel(Container panel, JComponent[] labels, JComponent[] value) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = _Insets;
        gbc.gridwidth = 1;
        for (int i = 0; i < labels.length; ++i) {
            gbc.gridy = i + 1;
            if (labels[i] != null) {
                gbc.anchor = 13;
                gbc.gridx = 0;
                panel.add((Component)labels[i], gbc);
            }
            if (value[i] == null) continue;
            gbc.anchor = 17;
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            if (value[i] instanceof JTextField && ((JTextField)value[i]).getColumns() == 0) {
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof FieldPanel && ((FieldPanel)value[i]).getColumns() == 0) {
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof DialogSeparator || value[i] instanceof LabelDescription) {
                gbc.gridx = 0;
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof JScrollPane) {
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof FieldPanel || value[i] instanceof JTextField || value[i] instanceof JComboBox || value[i] instanceof RadioButtonPanel || value[i] instanceof JCheckBox || value[i] instanceof JButton) {
                panel.add((Component)value[i], gbc);
            } else {
                gbc.fill = 1;
                panel.add((Component)value[i], gbc);
                gbc.fill = 0;
            }
            gbc.weightx = 0.0;
        }
    }

    public static void buildPanel(GridBagConstraints gbc, Container panel, JComponent[] labels, JComponent[] value) {
        int initialgridy = gbc.gridy;
        for (int i = 0; i < labels.length; ++i) {
            gbc.gridy += i;
            if (labels[i] != null) {
                gbc.anchor = 13;
                gbc.gridx = 0;
                panel.add((Component)labels[i], gbc);
            }
            if (value[i] == null) continue;
            gbc.anchor = 17;
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            if (value[i] instanceof JTextField && ((JTextField)value[i]).getColumns() == 0) {
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof FieldPanel && ((FieldPanel)value[i]).getColumns() == 0) {
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof DialogSeparator || value[i] instanceof LabelDescription) {
                gbc.gridx = 0;
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof JScrollPane) {
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof FieldPanel || value[i] instanceof JTextField || value[i] instanceof JComboBox || value[i] instanceof RadioButtonPanel || value[i] instanceof JCheckBox || value[i] instanceof JButton) {
                panel.add((Component)value[i], gbc);
            } else {
                gbc.fill = 1;
                panel.add((Component)value[i], gbc);
                gbc.fill = 0;
            }
            gbc.weightx = 0.0;
        }
    }

    public static JPanel buildTablePanel(JComponent[] labels, JComponent[] value) {
        JPanel panel = new JPanel(new GridBagLayout());
        DialogUtil.buildTablePanel(panel, labels, value);
        return panel;
    }

    public static void buildTablePanel(Container panel, JComponent[] labels, JComponent[] value) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = _Insets;
        gbc.gridwidth = 1;
        for (int i = 0; i < labels.length; ++i) {
            gbc.gridy = i + 1;
            if (labels[i] != null) {
                gbc.anchor = 13;
                gbc.gridx = 0;
                panel.add((Component)labels[i], gbc);
            }
            if (value[i] == null) continue;
            gbc.anchor = 17;
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            if (value[i] instanceof JTextField && ((JTextField)value[i]).getColumns() == 0) {
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof FieldPanel && ((FieldPanel)value[i]).getColumns() == 0) {
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof DialogSeparator || value[i] instanceof LabelDescription) {
                gbc.gridx = 0;
                DialogUtil.extend(gbc, panel, value[i]);
            } else if (value[i] instanceof JScrollPane) {
                gbc.fill = 1;
                gbc.weighty = 10.0;
                gbc.weightx = 15.0;
                gbc.gridwidth = 0;
                panel.add((Component)value[i], gbc);
                gbc.fill = 0;
                gbc.weighty = 0.0;
                gbc.weightx = 0.0;
                gbc.gridwidth = 1;
                gbc.fill = 0;
            } else if (value[i] instanceof FieldPanel || value[i] instanceof JTextField || value[i] instanceof JLabel || value[i] instanceof JComboBox || value[i] instanceof RadioButtonPanel || value[i] instanceof JCheckBox || value[i] instanceof JButton) {
                panel.add((Component)value[i], gbc);
            } else {
                gbc.fill = 1;
                gbc.weighty = 10.0;
                gbc.weightx = 10.0;
                panel.add((Component)value[i], gbc);
                gbc.fill = 0;
                gbc.weighty = 0.0;
                gbc.weightx = 0.0;
            }
            gbc.weightx = 0.0;
        }
    }

    public static JPanel buildStatusPanel(JButton[] buttons, JLabel status) {
        return DialogUtil.buildStatusPanel(buttons, status, 6);
    }

    public static JPanel buildStatusPanel(JButton[] buttons, JLabel status, int hGap) {
        JPanel south = new JPanel(new BorderLayout());
        if (buttons != null) {
            JPanel buttonPanel = new JPanel(new FlowLayout(2, hGap, 3));
            for (int i = 0; i < buttons.length; ++i) {
                buttonPanel.add(buttons[i]);
            }
            south.add("Center", buttonPanel);
        }
        status.setText(" ");
        south.add("South", status);
        south.setBorder(new EmptyBorder(new Insets(4, 0, 0, 0)));
        return south;
    }

    public static void extend(GridBagConstraints gbc, Container panel, JComponent value) {
        DialogUtil.extend(gbc, panel, value, 2, gbc.weightx, gbc.weighty);
    }

    public static void extend(GridBagConstraints gbc, Container panel, JComponent value, int fill, double weightx, double weighty) {
        gbc.fill = fill;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.gridwidth = 0;
        panel.add((Component)value, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
    }

    public static JButton[] buildButtons(String[] labels, ActionListener listener) {
        JButton[] b = new JButton[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            b[i] = new JButton(labels[i]);
            b[i].addActionListener(listener);
        }
        return b;
    }

    public static JButton[] buildButtons(String[][] attributes, ActionListener listener) {
        JButton[] b = new JButton[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            b[i] = new JButton(attributes[i][0]);
            b[i].setActionCommand(attributes[i][1]);
            b[i].addActionListener(listener);
        }
        return b;
    }

    public static JButton getButton(String label, JButton[] buttons) {
        for (int i = 0; i < buttons.length; ++i) {
            if (!buttons[i].getText().equals(label)) continue;
            return buttons[i];
        }
        return null;
    }

    public static void buildDialog(JDialog dialog, Container parent, Container fields) {
        String[] buttons = new String[]{"OK", "Close"};
        DialogUtil.buildDialog(dialog, parent, fields, (AbstractButton[])DialogUtil.buildButtons(buttons, (ActionListener)((Object)dialog)));
    }

    public static void buildDialog(JDialog dialog, Container parent, Container fields, AbstractButton[] buttons) {
        DialogUtil.buildDialog((Container)dialog, parent, fields, buttons, true);
    }

    public static void buildDialog(Container target, Container parent, Container fields, AbstractButton[] buttons, boolean bIsDialog) {
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < buttons.length; ++i) {
            buttonPanel.add(buttons[i]);
        }
        if (bIsDialog) {
            ((JDialog)target).getRootPane().setDefaultButton((JButton)buttons[0]);
        } else {
            ((JFrame)target).getRootPane().setDefaultButton((JButton)buttons[0]);
        }
        DialogUtil.buildDialog(target, parent, fields, buttonPanel, bIsDialog);
    }

    public static void buildDialog(JDialog dialog, Container parent, Container fields, JPanel buttonPanel) {
        DialogUtil.buildDialog((Container)dialog, parent, fields, buttonPanel, true);
    }

    static void buildDialog(Container target, Container parent, Container fields, JPanel buttonPanel, boolean bIsDialog) {
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(_Margin);
        main.add("Center", fields);
        main.add("South", buttonPanel);
        if (bIsDialog) {
            ((JDialog)target).getContentPane().add(main);
            ((JDialog)target).pack();
            ((JDialog)target).setResizable(false);
            ((JDialog)target).setLocationRelativeTo(parent);
        } else {
            ((JFrame)target).getContentPane().add(main);
            ((JFrame)target).pack();
            ((JFrame)target).setResizable(false);
            ((JFrame)target).setLocationRelativeTo(parent);
        }
    }

    public static void buildDialog(JFrame dialog, Container parent, Container fields, AbstractButton[] buttons) {
        DialogUtil.buildDialog((Container)dialog, parent, fields, buttons, false);
    }

    public static void buildDialog(JFrame dialog, Container parent, Container fields, JPanel buttonPanel) {
        DialogUtil.buildDialog((Container)dialog, parent, fields, buttonPanel, false);
    }

    public static void addKeyListener(Container container, KeyListener keyListener) {
        Component[] child = container.getComponents();
        for (int i = 0; i < child.length; ++i) {
            if (child[i] instanceof JPanel || child[i] instanceof Box) {
                DialogUtil.addKeyListener((Container)child[i], keyListener);
                continue;
            }
            if (child[i] instanceof JLabel) continue;
            child[i].addKeyListener(keyListener);
        }
    }
}

