/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import com.cisco.dcbu.lib.ui.ButtonFocusListener;
import com.cisco.dcbu.lib.ui.ButtonMouseListener;
import com.cisco.dcbu.lib.ui.PatternFileFilter;
import com.cisco.dcbu.lib.ui.PerspectiveIf;
import com.cisco.dcbu.lib.ui.PerspectiveManager;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public final class Util {
    static String _Directory;
    static ButtonMouseListener _ButtonMouseListener;
    static ButtonFocusListener _ButtonFocusListener;
    static HashMap _Icons;
    static Logger _Logger;
    public static String PERSPECTIVE_FILTERABLE_TYPE;
    public static String STATIC_TYPE;
    public static final Integer[] EMPTY_INTEGER_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final MouseAdapter EMPTY_MOUSE_ADAPTER;
    public static final KeyAdapter EMPTY_KEY_ADAPTER;
    static final Insets _NoBorder;

    public static Insets getNoBorder() {
        return _NoBorder;
    }

    private Util() {
    }

    public static String getErrorMessage(Exception ex) {
        return Util.getErrorMessage(ex, true);
    }

    public static String getErrorMessage(Exception ex, boolean wrapText) {
        int breakIndex;
        int exPos;
        int dot;
        String msg;
        int colon;
        if (ex == null) {
            return "";
        }
        if (ex instanceof RemoteException && ex.getCause() != null) {
            ex = (Exception)ex.getCause();
        }
        if ((colon = (msg = ex.toString()).indexOf(58)) != -1 && (dot = msg.substring(0, colon).lastIndexOf(46)) != -1) {
            msg = msg.substring(dot + 1);
        }
        if ((exPos = msg.indexOf("Exception")) == 0) {
            msg = msg.substring(11);
        } else if (exPos > 0) {
            msg = msg.substring(0, exPos).equals("Remote") ? msg.substring(exPos + 11) : msg.replaceFirst("Exception", "");
        }
        int msgLength = msg.length();
        if (wrapText && msgLength > 120 && (breakIndex = msg.indexOf("\n")) == -1) {
            StringBuilder wrappedString = new StringBuilder();
            int startIndex = 0;
            boolean done = false;
            while (!done) {
                if (msgLength - startIndex <= 120) {
                    wrappedString.append(msg.substring(startIndex > msgLength ? msgLength : startIndex, msgLength));
                    done = true;
                    continue;
                }
                int endIndex = startIndex + 120;
                int whiteSpaceAfter120 = msg.indexOf(" ", endIndex);
                if (whiteSpaceAfter120 == -1) {
                    whiteSpaceAfter120 = msgLength;
                }
                wrappedString.append(msg.substring(startIndex, whiteSpaceAfter120)).append("\n");
                startIndex = whiteSpaceAfter120 + 1;
            }
            msg = wrappedString.toString();
        }
        return msg;
    }

    public static void errorMessageInfoLevel(Component parentComponent, Exception ex) {
        _Logger.info((Object)"", (Throwable)ex);
        Util.errorMessage(parentComponent, Util.getErrorMessage(ex), false);
    }

    public static void errorMessage(final Component parent, String title, String logMsg, final Component display) {
        Window w;
        Toolkit.getDefaultToolkit().beep();
        if (logMsg != null) {
            _Logger.error((Object)logMsg);
        }
        if ((w = (Window)SwingUtilities.getRoot(parent)) != null) {
            if (w instanceof JFrame) {
                title = ((JFrame)w).getTitle();
            } else if (w instanceof JDialog) {
                title = ((JDialog)w).getTitle();
            }
        }
        final String titleFinal = title;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parent, display, titleFinal, 0);
            }
        });
    }

    public static void errorMessage(Component parentComponent, Exception ex) {
        _Logger.error((Object)"", (Throwable)ex);
        Util.errorMessage(parentComponent, Util.getErrorMessage(ex), false);
    }

    public static void errorMessage(Component parent, String msg) {
        Util.errorMessage(parent, msg, true);
    }

    public static void errorMessage(Component parent, String msg, String title) {
        Util.errorMessage(parent, msg, title, true);
    }

    public static void errorMessage(Component parent, String msg, boolean log) {
        Util.errorMessage(parent, msg, log, true);
    }

    public static void errorMessage(final Component parent, final String msg, boolean log, boolean invokeLater) {
        Toolkit.getDefaultToolkit().beep();
        if (msg == null) {
            return;
        }
        if (log) {
            _Logger.error((Object)msg);
        }
        String title = null;
        Window w = (Window)SwingUtilities.getRoot(parent);
        if (w != null) {
            if (w instanceof JFrame) {
                title = ((JFrame)w).getTitle();
            } else if (w instanceof JDialog) {
                title = ((JDialog)w).getTitle();
            }
        }
        final String titleFinal = title;
        if (!invokeLater) {
            JOptionPane.showMessageDialog(parent, msg, "ERROR " + titleFinal, 0);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int warningIndex = msg.indexOf("WARNING:");
                    if (warningIndex == -1) {
                        JOptionPane.showMessageDialog(parent, msg, "ERROR " + titleFinal, 0);
                    } else {
                        JOptionPane.showMessageDialog(parent, msg.substring(warningIndex + "WARNING:".length()), titleFinal, 2);
                    }
                }
            });
        }
    }

    public static void errorMessage(final Component parent, final String msg, final String titleFinal, boolean log) {
        Toolkit.getDefaultToolkit().beep();
        if (msg == null) {
            return;
        }
        if (log) {
            _Logger.error((Object)msg);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int warningIndex = msg.indexOf("WARNING:");
                if (warningIndex == -1) {
                    JOptionPane.showMessageDialog(parent, msg, "ERROR " + titleFinal, 0);
                } else {
                    JOptionPane.showMessageDialog(parent, msg.substring(warningIndex + "WARNING:".length()), titleFinal, 2);
                }
            }
        });
    }

    public static void infoMessage(final Component parent, final String msg, boolean log) {
        Toolkit.getDefaultToolkit().beep();
        if (msg == null) {
            return;
        }
        if (log) {
            _Logger.error((Object)msg);
        }
        String title = null;
        Window w = (Window)SwingUtilities.getRoot(parent);
        if (w != null) {
            if (w instanceof JFrame) {
                title = ((JFrame)w).getTitle();
            } else if (w instanceof JDialog) {
                title = ((JDialog)w).getTitle();
            }
        }
        final String titleFinal = title;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parent, msg, "INFO " + titleFinal, 1);
            }
        });
    }

    public static JFrame getFrameAncestor(Component c) {
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JFrame)) continue;
            return (JFrame)p;
        }
        return null;
    }

    public static JDialog getDialogAncestor(Component c) {
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JDialog)) continue;
            return (JDialog)p;
        }
        return null;
    }

    public static String getFileName(JFrame parent, String pattern, int type) {
        return Util.getFileName(parent, null, pattern, type, true);
    }

    public static String getFileName(JFrame parent, String pattern, int type, boolean fullPath) {
        return Util.getFileName(parent, null, pattern, type, fullPath);
    }

    public static String getFileName(JFrame parent, String fileName, String pattern, int type, boolean fullPath) {
        FileDialog f = new FileDialog((Frame)parent, parent.getTitle(), type);
        if (pattern != null && pattern.length() > 0) {
            f.setFilenameFilter(new PatternFileFilter(pattern));
            f.setFile(pattern);
        }
        if (fileName != null && fileName.length() > 0) {
            f.setFile(fileName);
        }
        if (_Directory != null) {
            f.setDirectory(_Directory);
        }
        f.setVisible(true);
        String fName = f.getFile();
        if (fName != null) {
            _Directory = f.getDirectory();
            if (fullPath) {
                return f.getDirectory() + fName;
            }
            return fName;
        }
        return null;
    }

    public static String getFileName(JFrame parent, String pattern, int type, String directory, boolean fullPath) {
        return Util.getFileName(parent, parent.getTitle(), pattern, type, directory, fullPath);
    }

    public static String getFileName(JFrame parent, String title, String pattern, int type, String directory, boolean fullPath) {
        FileDialog f = new FileDialog((Frame)parent, title, type);
        if (pattern != null && pattern.length() > 0) {
            f.setFilenameFilter(new PatternFileFilter(pattern));
            f.setFile(pattern);
        }
        if (directory != null) {
            f.setDirectory(directory);
        } else if (_Directory != null) {
            f.setDirectory(_Directory);
        }
        f.setVisible(true);
        String fName = f.getFile();
        if (fName != null) {
            _Directory = f.getDirectory();
            if (fullPath) {
                return f.getDirectory() + fName;
            }
            return fName;
        }
        return null;
    }

    public static JMenu createMenu(String label) {
        int mnemonic = label.lastIndexOf(38);
        JideMenu menu = mnemonic == -1 ? new JideMenu(label) : new JideMenu(Util.removeMnemonic(label, mnemonic));
        menu.setMnemonic(label.charAt(mnemonic + 1));
        return menu;
    }

    public static JMenu createMenu(String label, String xmlfilterKey, String type) {
        PerspectiveIf view;
        if (PERSPECTIVE_FILTERABLE_TYPE.equals(type) && ((view = PerspectiveManager.getInstance().getView()) == null || !view.isVisible("menu", xmlfilterKey))) {
            return null;
        }
        int mnemonic = label.lastIndexOf(38);
        JideMenu menu = mnemonic == -1 ? new JideMenu(label) : new JideMenu(Util.removeMnemonic(label, mnemonic));
        menu.setMnemonic(label.charAt(mnemonic + 1));
        return menu;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(String label, String action, ActionListener actionListener) {
        JCheckBoxMenuItem mi;
        int mnemonic = label.lastIndexOf(38);
        if (mnemonic == -1) {
            mi = new JCheckBoxMenuItem(label);
        } else {
            mi = new JCheckBoxMenuItem(Util.removeMnemonic(label, mnemonic));
            mi.setMnemonic(label.charAt(mnemonic + 1));
        }
        mi.setActionCommand(action);
        mi.addActionListener(actionListener);
        return mi;
    }

    public static JMenuItem createMenuItem(String label, String action, ActionListener actionListener) {
        int mnemonic = label.lastIndexOf(38);
        JMenuItem mi = mnemonic == -1 ? new JMenuItem(label, label.charAt(0)) : new JMenuItem(Util.removeMnemonic(label, mnemonic), label.charAt(mnemonic + 1));
        mi.setActionCommand(action);
        mi.addActionListener(actionListener);
        return mi;
    }

    public static JMenuItem createMenuItem(String label, String action, String xmlFilterKey, ActionListener actionListener) {
        PerspectiveIf view;
        int mnemonic = label.lastIndexOf(38);
        JMenuItem mi = mnemonic == -1 ? new JMenuItem(label, label.charAt(0)) : new JMenuItem(Util.removeMnemonic(label, mnemonic), label.charAt(mnemonic + 1));
        mi.setActionCommand(action);
        mi.addActionListener(actionListener);
        String className = actionListener.getClass().getName();
        if ((className.startsWith("com.cisco.dcbu.sm.client.gui.UIControl") || className.startsWith("com.cisco.dcbu.sm.client.map") || className.startsWith("com.cisco.dcbu.sm.client.logicaltree.VsanTree")) && ((view = PerspectiveManager.getInstance().getView()) == null || !view.isVisible("menu", xmlFilterKey))) {
            mi.setVisible(false);
            mi.setEnabled(false);
        }
        return mi;
    }

    public static void enableMenuItem(JMenuBar menuBar, String menuName, String menuItemName, boolean enable) {
        for (int i = 0; i < menuBar.getComponentCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (!menu.getText().equals(menuName)) continue;
            for (int j = 0; j < menu.getMenuComponentCount(); ++j) {
                JMenuItem item = menu.getItem(j);
                if (item == null || !item.getText().startsWith(menuItemName)) continue;
                item.setEnabled(enable);
            }
        }
    }

    public static String removeMnemonic(String name, int mnemonic) {
        if (mnemonic == 0) {
            return name.substring(1);
        }
        return name.substring(0, mnemonic) + name.substring(mnemonic + 1);
    }

    public static JideButton createJideButton(String path, String tooltip, String action, ActionListener actionListener) {
        JideButton b = path == null || "".equals(path) ? new JideButton(tooltip) : new JideButton((Icon)Util.loadIcon(path));
        Util.setIconButtonAttr((AbstractButton)b, tooltip, action, actionListener);
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setBorder((Border)new EmptyBorder(2, 2, 2, 2));
        if (_ButtonMouseListener == null) {
            _ButtonMouseListener = new ButtonMouseListener();
        }
        b.addMouseListener((MouseListener)_ButtonMouseListener);
        if (_ButtonFocusListener == null) {
            _ButtonFocusListener = new ButtonFocusListener();
        }
        b.addFocusListener((FocusListener)_ButtonFocusListener);
        return b;
    }

    public static JButton createButton(String path, String tooltip, String action, ActionListener actionListener) {
        JButton b = path == null || "".equals(path) ? new JButton(tooltip) : new JButton(Util.loadIcon(path));
        Util.setIconButtonAttr(b, tooltip, action, actionListener);
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        if (_ButtonMouseListener == null) {
            _ButtonMouseListener = new ButtonMouseListener();
        }
        b.addMouseListener(_ButtonMouseListener);
        if (_ButtonFocusListener == null) {
            _ButtonFocusListener = new ButtonFocusListener();
        }
        b.addFocusListener(_ButtonFocusListener);
        return b;
    }

    public static JButton createRolloverButton(String path, String inActivePath, String tooltip, String action, ActionListener actionListener) {
        JButton b = new JButton(Util.loadIcon(inActivePath));
        Util.setIconButtonAttr(b, tooltip, action, actionListener);
        b.setRolloverIcon(Util.loadIcon(path));
        b.setBorderPainted(false);
        if (_ButtonMouseListener == null) {
            _ButtonMouseListener = new ButtonMouseListener();
        }
        b.addMouseListener(_ButtonMouseListener);
        return b;
    }

    public static JToggleButton createToggleButton(String path, String tooltip, String action, ActionListener actionListener) {
        JToggleButton b = new JToggleButton(Util.loadIcon(path));
        Util.setIconButtonAttr(b, tooltip, action, actionListener);
        return b;
    }

    static void setIconButtonAttr(AbstractButton b, String tooltip, String action, ActionListener actionListener) {
        b.setToolTipText(tooltip);
        b.setMargin(_NoBorder);
        if (action != null) {
            b.addActionListener(actionListener);
            b.setActionCommand(action);
        }
    }

    public static Image getIconImage(String path, int height) {
        ImageIcon icon = Util.loadIcon(path);
        if (icon == null) {
            return null;
        }
        if (height != 0 && height != icon.getIconHeight()) {
            int width = (int)((float)icon.getIconWidth() * (float)height / (float)icon.getIconHeight());
            Image scaledImage = icon.getImage().getScaledInstance(width, height, 1);
            if (scaledImage != null) {
                MediaTracker tracker = new MediaTracker(new Panel());
                tracker.addImage(scaledImage, 0);
                try {
                    tracker.waitForID(0, 30000L);
                }
                catch (InterruptedException exception) {
                    System.err.println(path + " getIconImage: " + exception);
                }
                int stat = tracker.statusID(0, false);
                if ((stat & 8) == 0) {
                    System.err.println(path + " getIconImage: failed to load in 30 seconds");
                }
                tracker.removeImage(scaledImage, 0);
                return scaledImage;
            }
        }
        return icon.getImage();
    }

    public static Image getIconImage(String path) {
        ImageIcon icon = Util.loadIcon(path);
        if (icon != null) {
            return icon.getImage();
        }
        return null;
    }

    public static Image getDisabledIconImage(String path) {
        ImageIcon icon = Util.loadIcon(path);
        Image image = null;
        Image dImage = null;
        if (icon != null) {
            image = icon.getImage();
        }
        if (image != null) {
            dImage = GrayFilter.createDisabledImage(image);
        }
        return dImage;
    }

    public static ImageIcon getImageIcon(String path, int height) {
        ImageIcon icon = Util.loadIcon(path);
        if (icon == null) {
            return null;
        }
        if (height != 0 && height != icon.getIconHeight()) {
            int width = (int)((float)icon.getIconWidth() * (float)height / (float)icon.getIconHeight());
            return new ImageIcon(icon.getImage().getScaledInstance(width, height, 1));
        }
        return icon;
    }

    public static ImageIcon loadIcon(String path) {
        ImageIcon icon = (ImageIcon)_Icons.get(path);
        if (icon != null) {
            return icon;
        }
        try {
            URL url = Util.class.getResource("/" + path);
            icon = new ImageIcon(url);
            if (icon == null) {
                return null;
            }
            _Icons.put(path, icon);
            return icon;
        }
        catch (Exception ex) {
            System.err.println(path + " loadIcon: " + ex);
            return null;
        }
    }

    public static String getFileExtension(File f) {
        if (f == null) {
            return null;
        }
        String s = f.getName();
        return Util.getFileExtension(s);
    }

    public static String getFileExtension(String f) {
        if (f == null) {
            return null;
        }
        String ext = null;
        int i = f.lastIndexOf(46);
        if (i > 0 && i < f.length() - 1) {
            ext = f.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static void load(HashMap p, String fName) throws IOException {
        InputStream is = Util.class.getResourceAsStream(fName);
        if (is == null) {
            throw new IOException(fName);
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            Util.load(p, br);
        }
    }

    public static void load(HashMap p, BufferedReader br) throws IOException {
        String line = null;
        while ((line = br.readLine()) != null) {
            int equals;
            if (line.length() == 0 || line.charAt(0) == '#' || (equals = line.indexOf(61)) == -1) continue;
            p.put(line.substring(0, equals).intern(), line.substring(equals + 1).intern());
        }
    }

    public static String getModParentTitle(Frame parent) {
        int dashInd;
        if (null != parent && -1 != (dashInd = parent.getTitle().indexOf(45))) {
            return parent.getTitle().substring(0, dashInd + 1);
        }
        return "";
    }

    public static void updateSeparatorVisibility(JMenuBar menubar) {
        if (menubar != null) {
            int count = menubar.getComponentCount();
            for (int index = 0; index < count; ++index) {
                Util.updateSeparatorVisibility(menubar.getMenu(index));
            }
        }
    }

    public static void updateSeparatorVisibility(JMenu menu) {
        if (menu != null) {
            int count = menu.getMenuComponentCount();
            Component prevVisibleComp = null;
            for (int index = 0; index < count; ++index) {
                Component thisComponent = menu.getMenuComponent(index);
                if (thisComponent instanceof JSeparator) {
                    thisComponent.setVisible(prevVisibleComp != null && !(prevVisibleComp instanceof JSeparator));
                } else if (thisComponent instanceof JMenu && thisComponent.isVisible()) {
                    Util.updateSeparatorVisibility((JMenu)thisComponent);
                }
                if (!thisComponent.isVisible()) continue;
                prevVisibleComp = thisComponent;
            }
            if (prevVisibleComp instanceof JSeparator) {
                prevVisibleComp.setVisible(false);
            }
        }
    }

    public static void setBusy(boolean busy, JComponent comp) {
        RootPaneContainer rpc = (RootPaneContainer)((Object)comp.getTopLevelAncestor());
        if (rpc == null) {
            return;
        }
        rpc.getGlassPane().setCursor(Cursor.getPredefinedCursor(busy ? 3 : 0));
        if (busy) {
            rpc.getGlassPane().addMouseListener(EMPTY_MOUSE_ADAPTER);
            rpc.getGlassPane().addKeyListener(EMPTY_KEY_ADAPTER);
        } else {
            rpc.getGlassPane().removeMouseListener(EMPTY_MOUSE_ADAPTER);
            rpc.getGlassPane().removeKeyListener(EMPTY_KEY_ADAPTER);
        }
        rpc.getGlassPane().setVisible(busy);
    }

    static {
        _Icons = new HashMap();
        _Logger = Logger.getLogger(Util.class);
        PERSPECTIVE_FILTERABLE_TYPE = "FM";
        STATIC_TYPE = "DM";
        EMPTY_INTEGER_ARRAY = new Integer[0];
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_MOUSE_ADAPTER = new MouseAdapter(){};
        EMPTY_KEY_ADAPTER = new KeyAdapter(){};
        _NoBorder = new Insets(0, 0, 0, 0);
    }
}

