/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.comps;

import com.cisco.dcbu.lib.ui.comps.FileListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JFilePanel
extends JPanel
implements ActionListener,
FocusListener {
    private JFileChooser _chooser = new JFileChooser();
    private JTextField _file = new JTextField(20);
    private JButton _launcher = new JButton("...");
    private int _mode;
    private File _absFile = null;
    private Vector _listeners = new Vector();
    private JLabel _label = null;

    public JFilePanel(int mode) {
        this._mode = mode;
        this._launcher.setPreferredSize(new Dimension((int)this._launcher.getPreferredSize().getWidth(), (int)this._file.getPreferredSize().getHeight()));
        this._launcher.addActionListener(this);
        this._file.addActionListener(this);
        this._file.addFocusListener(this);
        switch (mode) {
            case 0: {
                this._label = new JLabel("Open File:");
                this.add(this._label);
                break;
            }
            case 1: {
                this._label = new JLabel("Save File:");
                this.add(this._label);
                break;
            }
            default: {
                this.add(new JLabel("File:"));
            }
        }
        this.add(this._file);
        this.add(this._launcher);
        this._launcher.requestFocus();
    }

    public void setFile(String str) {
        this._absFile = new File(str);
        if (this._absFile != null) {
            this._file.setText(this._absFile.getAbsolutePath());
            this._chooser.setSelectedFile(this._absFile);
        }
    }

    public String getFile() {
        this._absFile = new File(this._file.getText());
        return this._absFile.getAbsolutePath();
    }

    public void addFileListener(FileListener fl) {
        this._listeners.add(fl);
    }

    public void removeFileListener(FileListener fl) {
        this._listeners.remove(fl);
    }

    @Override
    public void requestFocus() {
        this._file.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result;
        if (e.getSource() == this._launcher && (result = this._mode == 0 ? this._chooser.showOpenDialog(this) : (this._mode == 1 ? this._chooser.showSaveDialog(this) : this._chooser.showDialog(this, "OK"))) == 0) {
            this._absFile = this._chooser.getSelectedFile();
            this._file.setText(this._absFile.getAbsolutePath());
            this.notifyListeners();
        }
        if (e.getSource() == this._file) {
            String tmp = this._file.getText();
            if (tmp != null && !tmp.trim().equals("")) {
                this._absFile = new File(tmp);
            }
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            FileListener l = (FileListener)this._listeners.elementAt(i);
            if (l == null || this._absFile == null) continue;
            l.fileSelected(this._absFile);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.notifyListeners();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this._chooser.setEnabled(b);
        this._file.setEnabled(b);
        this._launcher.setEnabled(b);
        this._label.setEnabled(b);
    }
}

