/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.table;

import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class ChangedCellRenderer
extends DefaultTableCellRenderer {
    static Font _NormalFont = (Font)UIManager.getDefaults().get("Table.font");
    static Font _ChangedFont = new Font(_NormalFont.getName(), 1, _NormalFont.getSize());
    static Font _ItalicFont = new Font(_NormalFont.getName(), 2, _NormalFont.getSize());
    protected static Border _NoSuchInstanceBorder = BorderFactory.createLineBorder(Color.red);
    private boolean toolTipEnabled = false;
    private boolean wrapLongTooltips = false;
    private int wrapCharCount = 70;

    public ChangedCellRenderer() {
        this.setVerticalAlignment(1);
    }

    public static Font getChangeFont() {
        return _ChangedFont;
    }

    public static Font getNormalFont() {
        return _NormalFont;
    }

    public static Font getItalicFont() {
        return _ItalicFont;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(2, 2);
    }

    public void setUIProperties(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!((KTableModel)table.getModel()).isCellActive(row, table.convertColumnIndexToModel(column))) {
            this.setForeground(Color.gray);
        } else if (isSelected) {
            this.setForeground(table.getSelectionForeground());
        } else {
            super.setForeground(table.getForeground());
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else if (table.isCellEditable(row, column)) {
            this.setBackground(UIManager.getColor("TextField.background"));
        } else {
            this.setBackground(table.getBackground());
        }
        if (!isSelected && ((KTableModel)table.getModel()).isCellActive(row, table.convertColumnIndexToModel(column)) && !table.isCellEditable(row, column) && table.getBackground() != null && !table.getBackground().equals(Color.black)) {
            this.setForeground(Color.black);
        }
        if (((KTableModel)table.getModel()).isChanged(row, table.convertColumnIndexToModel(column))) {
            this.setFont(_ChangedFont);
        } else {
            this.setFont(table.getFont());
        }
        this.setValue(value);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setUIProperties(table, value, isSelected, hasFocus, row, column);
        if (((KTableModel)table.getModel()).isNoSuchInstance(row, table.convertColumnIndexToModel(column))) {
            this.setBorder(_NoSuchInstanceBorder);
        } else if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else if (table.isRowSelected(row)) {
            this.setBorder(BorderCellRenderer.getRowSelectBorder());
        } else {
            this.setBorder(noFocusBorder);
        }
        if (this.toolTipEnabled) {
            if (value == null) {
                this.setToolTipText(null);
            } else if (this.wrapLongTooltips) {
                this.setToolTipText(this.wrapToolTipText(value.toString(), this.wrapCharCount));
            } else {
                this.setToolTipText(value.toString());
            }
        }
        return this;
    }

    public void setWrapToolTip(boolean wantWrapToolTipEnabled) {
        this.wrapLongTooltips = wantWrapToolTipEnabled;
    }

    public void setToolTipWrapLength(int charCount) {
        this.wrapCharCount = charCount;
    }

    public void setEnableToolTip(boolean wantToolTipEnabled) {
        this.toolTipEnabled = wantToolTipEnabled;
    }

    private String wrapToolTipText(String text, int columnWidth) {
        StringBuilder results = new StringBuilder("<html>");
        if (text.length() > columnWidth) {
            StringTokenizer st = new StringTokenizer(text, " ", true);
            int lineLength = 0;
            boolean lineCount = true;
            while (st.hasMoreTokens()) {
                String nextWord = st.nextToken();
                if (lineLength + nextWord.length() > columnWidth && lineLength != 0) {
                    if (!lineCount) {
                        results.append("</br>");
                    }
                    lineLength = 0;
                    results.append("<br>");
                    if (nextWord.equals(" ")) continue;
                }
                lineLength += nextWord.length();
                results.append(nextWord);
            }
        } else {
            return text;
        }
        results.append("</html>");
        return results.toString();
    }
}

